/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.init;

import com.google.common.collect.Lists;
import com.litewolf101.illagers_plus.objects.enchantments.IllagerBaneEnchantment;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="illagers_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnchantmentInit {
    private static final List<Enchantment> ENCHANTMENTS = Lists.newArrayList();
    public static final Enchantment ILLAGERS_BANE = EnchantmentInit.register(EnchantmentInit.name("illagers_bane"), new IllagerBaneEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlotType.MAINHAND));

    @SubscribeEvent
    public static void registerAll(RegistryEvent.Register<Enchantment> event) {
        for (Enchantment enchantment : ENCHANTMENTS) {
            event.getRegistry().register((IForgeRegistryEntry)enchantment);
        }
    }

    private static Enchantment register(String name, Enchantment enchantment) {
        Enchantment e1 = (Enchantment)enchantment.setRegistryName(name);
        ENCHANTMENTS.add(e1);
        return e1;
    }

    private static String name(String name) {
        return new ResourceLocation("illagers_plus", name).toString();
    }
}

