/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.init;

import com.google.common.collect.Lists;
import com.litewolf101.illagers_plus.IllagersPlus;
import com.litewolf101.illagers_plus.objects.entity.EntityArcher;
import com.litewolf101.illagers_plus.objects.entity.EntityBerserker;
import com.litewolf101.illagers_plus.objects.entity.EntityBlackIronGolem;
import com.litewolf101.illagers_plus.objects.entity.EntityEnchanter;
import com.litewolf101.illagers_plus.objects.entity.EntityFallingIce;
import com.litewolf101.illagers_plus.objects.entity.EntityFrostmancer;
import com.litewolf101.illagers_plus.objects.entity.EntityFurantur;
import com.litewolf101.illagers_plus.objects.entity.EntityHoarder;
import com.litewolf101.illagers_plus.objects.entity.EntityIceBall;
import com.litewolf101.illagers_plus.objects.entity.EntityIceSpike;
import com.litewolf101.illagers_plus.objects.entity.EntityIllagerGeneral;
import com.litewolf101.illagers_plus.objects.entity.EntityIllagerKing;
import com.litewolf101.illagers_plus.objects.entity.EntityMiner;
import com.litewolf101.illagers_plus.objects.entity.EntityNecromancer;
import com.litewolf101.illagers_plus.objects.entity.EntitySupportColumn;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="illagers_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityInit {
    public static Item entity_egg_item;
    private static final List<EntityType> ENTITIES;
    public static final EntityType<EntityArcher> ARCHER;
    public static final EntityType<EntityBerserker> BERSERKER;
    public static final EntityType<EntityBlackIronGolem> BLACK_IRON_GOLEM;
    public static final EntityType<EntityEnchanter> ENCHANTER;
    public static final EntityType<EntityFrostmancer> FROSTMANCER;
    public static final EntityType<EntityFurantur> FURANTUR;
    public static final EntityType<EntityHoarder> HOARDER;
    public static final EntityType<EntityIllagerGeneral> ILLAGER_GENERAL;
    public static final EntityType<EntityIllagerKing> ILLAGER_KING;
    public static final EntityType<EntityMiner> MINER;
    public static final EntityType<EntityNecromancer> NECROMANCER;
    public static final EntityType<EntityFallingIce> FALLING_ICE;
    public static final EntityType<EntityIceSpike> ICE_SPIKE;
    public static final EntityType<EntityIceBall> ICE_BALL;
    public static final EntityType<EntitySupportColumn> SUPPORT_COLUMN;

    private static <T extends Entity> EntityType<T> createEntity(Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = new ResourceLocation("illagers_plus", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_206830_a(location.toString());
        entity.setRegistryName(location);
        ENTITIES.add(entity);
        return entity;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType entity : ENTITIES) {
            event.getRegistry().register((IForgeRegistryEntry)entity);
        }
        GlobalEntityTypeAttributes.put(ARCHER, (AttributeModifierMap)EntityArcher.attributes());
        GlobalEntityTypeAttributes.put(BERSERKER, (AttributeModifierMap)EntityBerserker.attributes());
        GlobalEntityTypeAttributes.put(BLACK_IRON_GOLEM, (AttributeModifierMap)EntityBlackIronGolem.attributes());
        GlobalEntityTypeAttributes.put(ENCHANTER, (AttributeModifierMap)PillagerEntity.func_234296_eI_().func_233813_a_());
        GlobalEntityTypeAttributes.put(FROSTMANCER, (AttributeModifierMap)EntityFrostmancer.attributes());
        GlobalEntityTypeAttributes.put(FURANTUR, (AttributeModifierMap)EntityFurantur.attributes());
        GlobalEntityTypeAttributes.put(HOARDER, (AttributeModifierMap)EntityHoarder.attributes());
        GlobalEntityTypeAttributes.put(ILLAGER_GENERAL, (AttributeModifierMap)PillagerEntity.func_234296_eI_().func_233813_a_());
        GlobalEntityTypeAttributes.put(ILLAGER_KING, (AttributeModifierMap)EntityIllagerKing.attributes());
        GlobalEntityTypeAttributes.put(MINER, (AttributeModifierMap)EntityMiner.attributes());
        GlobalEntityTypeAttributes.put(NECROMANCER, (AttributeModifierMap)EntityNecromancer.attributes());
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{entity_egg_item = EntityInit.registerSpawnEgg(ARCHER, "archer", 0x959B9B, 10657441), entity_egg_item = EntityInit.registerSpawnEgg(BERSERKER, "berserker", 0x959B9B, 15613979), entity_egg_item = EntityInit.registerSpawnEgg(BLACK_IRON_GOLEM, "black_iron_golem", 4410461, 16694040), entity_egg_item = EntityInit.registerSpawnEgg(ENCHANTER, "enchanter", 0x959B9B, 0x6464A4), entity_egg_item = EntityInit.registerSpawnEgg(FROSTMANCER, "frostmancer", 0x959B9B, 705279), entity_egg_item = EntityInit.registerSpawnEgg(FURANTUR, "furantur", 0x959B9B, 0x64A464), entity_egg_item = EntityInit.registerSpawnEgg(HOARDER, "hoarder", 0x959B9B, 9135268), entity_egg_item = EntityInit.registerSpawnEgg(ILLAGER_GENERAL, "illager_general", 5466674, 0x959B9B), entity_egg_item = EntityInit.registerSpawnEgg(ILLAGER_KING, "illager_king", 0xFF0000, 0x959B9B), entity_egg_item = EntityInit.registerSpawnEgg(MINER, "miner", 0x959B9B, 10711924), entity_egg_item = EntityInit.registerSpawnEgg(NECROMANCER, "necromancer", 0x959B9B, 0)});
    }

    public static Item registerSpawnEgg(EntityType<?> entityType, String name, int primaryClr, int secondaryClr) {
        SpawnEggItem egg = new SpawnEggItem(entityType, primaryClr, secondaryClr, new Item.Properties().func_200916_a(IllagersPlus.ILLAGERS_PLUS));
        egg.setRegistryName("illagers_plus", name + "_egg");
        return egg;
    }

    static {
        ENTITIES = Lists.newArrayList();
        ARCHER = EntityInit.createEntity(EntityArcher.class, EntityArcher::new, EntityClassification.MONSTER, "archer", 0.6f, 1.95f);
        BERSERKER = EntityInit.createEntity(EntityBerserker.class, EntityBerserker::new, EntityClassification.MONSTER, "berserker", 0.6f, 1.95f);
        BLACK_IRON_GOLEM = EntityInit.createEntity(EntityBlackIronGolem.class, EntityBlackIronGolem::new, EntityClassification.MONSTER, "black_iron_golem", 1.75f, 4.25f);
        ENCHANTER = EntityInit.createEntity(EntityEnchanter.class, EntityEnchanter::new, EntityClassification.MONSTER, "enchanter", 0.7f, 2.0f);
        FROSTMANCER = EntityInit.createEntity(EntityFrostmancer.class, EntityFrostmancer::new, EntityClassification.MONSTER, "frostmancer", 0.7f, 2.0f);
        FURANTUR = EntityInit.createEntity(EntityFurantur.class, EntityFurantur::new, EntityClassification.MONSTER, "furantur", 0.7f, 2.0f);
        HOARDER = EntityInit.createEntity(EntityHoarder.class, EntityHoarder::new, EntityClassification.MONSTER, "hoarder", 0.7f, 2.0f);
        ILLAGER_GENERAL = EntityInit.createEntity(EntityIllagerGeneral.class, EntityIllagerGeneral::new, EntityClassification.MONSTER, "illager_general", 0.6f, 1.95f);
        ILLAGER_KING = EntityInit.createEntity(EntityIllagerKing.class, EntityIllagerKing::new, EntityClassification.MONSTER, "illager_king", 1.65f, 4.0f);
        MINER = EntityInit.createEntity(EntityMiner.class, EntityMiner::new, EntityClassification.MONSTER, "miner", 0.6f, 1.95f);
        NECROMANCER = EntityInit.createEntity(EntityNecromancer.class, EntityNecromancer::new, EntityClassification.MONSTER, "necromancer", 0.7f, 2.0f);
        FALLING_ICE = EntityInit.createEntity(EntityFallingIce.class, EntityFallingIce::new, EntityClassification.MISC, "falling_ice", 0.5f, 0.5f);
        ICE_SPIKE = EntityInit.createEntity(EntityIceSpike.class, EntityIceSpike::new, EntityClassification.MISC, "ice_spike", 3.0f, 3.0f);
        ICE_BALL = EntityInit.createEntity(EntityIceBall.class, EntityIceBall::new, EntityClassification.MISC, "ice_ball", 0.75f, 0.75f);
        SUPPORT_COLUMN = EntityInit.createEntity(EntitySupportColumn.class, EntitySupportColumn::new, EntityClassification.MISC, "support_column", 1.0f, 1.0f);
    }
}

