/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.objects.entity;

import com.litewolf101.illagers_plus.objects.entity.EntityAbstractIllagerPlus;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityAbstractIPSpellcaster
extends EntityAbstractIllagerPlus {
    private static final DataParameter<Byte> SPELL = EntityDataManager.func_187226_a(EntityAbstractIPSpellcaster.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected int spellTicks;
    private SpellType activeSpell = SpellType.NONE;

    protected EntityAbstractIPSpellcaster(EntityType<? extends EntityAbstractIPSpellcaster> type, World p_i48551_2_) {
        super(type, p_i48551_2_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPELL, (Object)0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.spellTicks = compound.func_74762_e("SpellTicks");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SpellTicks", this.spellTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.isSpellcasting()) {
            return AbstractIllagerEntity.ArmPose.SPELLCASTING;
        }
        return this.func_213656_en() ? AbstractIllagerEntity.ArmPose.CELEBRATING : AbstractIllagerEntity.ArmPose.CROSSED;
    }

    public boolean isSpellcasting() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpellType(SpellType spellType) {
        this.activeSpell = spellType;
        this.field_70180_af.func_187227_b(SPELL, (Object)((byte)spellType.id));
    }

    protected SpellType getSpellType() {
        return !this.field_70170_p.field_72995_K ? this.activeSpell : SpellType.getFromId(((Byte)this.field_70180_af.func_187225_a(SPELL)).byteValue());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isSpellcasting()) {
            SpellType spellcastingillagerentity$spelltype = this.getSpellType();
            double d0 = spellcastingillagerentity$spelltype.particleSpeed[0];
            double d1 = spellcastingillagerentity$spelltype.particleSpeed[1];
            double d2 = spellcastingillagerentity$spelltype.particleSpeed[2];
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract SoundEvent getSpellSound();

    public abstract class UseSpellGoal
    extends Goal {
        protected int spellWarmup;
        protected int spellCooldown;

        protected UseSpellGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = EntityAbstractIPSpellcaster.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                if (EntityAbstractIPSpellcaster.this.isSpellcasting()) {
                    return false;
                }
                return EntityAbstractIPSpellcaster.this.field_70173_aa >= this.spellCooldown;
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = EntityAbstractIPSpellcaster.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntityAbstractIPSpellcaster.this.spellTicks = this.getCastingTime();
            this.spellCooldown = EntityAbstractIPSpellcaster.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                EntityAbstractIPSpellcaster.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
            EntityAbstractIPSpellcaster.this.setSpellType(this.getSpellType());
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                EntityAbstractIPSpellcaster.this.func_184185_a(EntityAbstractIPSpellcaster.this.getSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SpellType getSpellType();
    }

    public static enum SpellType {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_FALLING_ICE_SPEAR(1, 0.56, 0.89, 0.96),
        CHILLING_SWALLOW(2, 1.0, 1.0, 1.0),
        ICE_CAP_ATTACK(3, 1.0, 1.0, 1.0),
        ICE_THROW(4, 0.7, 0.7, 0.7),
        CIRCLE_OF_FANG(5, 0.4, 0.3, 0.35),
        SUMMON_ZOMBIES(6, 0.5, 0.5, 0.2),
        VAMPIRISM(7, 0.9, 0.1, 0.2);

        private final int id;
        private final double[] particleSpeed;

        private SpellType(int idIn, double xParticleSpeed, double yParticleSpeed, double zParticleSpeed) {
            this.id = idIn;
            this.particleSpeed = new double[]{xParticleSpeed, yParticleSpeed, zParticleSpeed};
        }

        public static SpellType getFromId(int idIn) {
            for (SpellType spellcastingillagerentity$spelltype : SpellType.values()) {
                if (idIn != spellcastingillagerentity$spelltype.id) continue;
                return spellcastingillagerentity$spelltype;
            }
            return NONE;
        }
    }

    public class CastingASpellGoal
    extends Goal {
        public CastingASpellGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EntityAbstractIPSpellcaster.this.getSpellTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityAbstractIPSpellcaster.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityAbstractIPSpellcaster.this.setSpellType(SpellType.NONE);
        }

        public void func_75246_d() {
            if (EntityAbstractIPSpellcaster.this.func_70638_az() != null) {
                EntityAbstractIPSpellcaster.this.func_70671_ap().func_75651_a((Entity)EntityAbstractIPSpellcaster.this.func_70638_az(), (float)EntityAbstractIPSpellcaster.this.func_184649_cE(), (float)EntityAbstractIPSpellcaster.this.func_70646_bf());
            }
        }
    }
}

