/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.objects.entity;

import com.litewolf101.illagers_plus.objects.entity.EntityAbstractIllagerPlus;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class EntityBlackIronGolem
extends EntityAbstractIllagerPlus {
    private static final DataParameter<Integer> SPECIAL_ATTACK_WARMUP_TICK = EntityDataManager.func_187226_a(EntityBlackIronGolem.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SPECIAL_ATTACK_TYPE = EntityDataManager.func_187226_a(EntityBlackIronGolem.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SPECIAL_ATTACK_TICK = EntityDataManager.func_187226_a(EntityBlackIronGolem.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityBlackIronGolem(EntityType<? extends EntityBlackIronGolem> type, World world) {
        super(type, world);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PillagerEntity.class}));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false).func_190882_b(300));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPECIAL_ATTACK_TICK, (Object)100);
        this.field_70180_af.func_187214_a(SPECIAL_ATTACK_WARMUP_TICK, (Object)20);
        this.field_70180_af.func_187214_a(SPECIAL_ATTACK_TYPE, (Object)0);
    }

    public int getAttackTick() {
        return (Integer)this.field_70180_af.func_187225_a(SPECIAL_ATTACK_TICK);
    }

    public void setAttackTick(int tick) {
        this.field_70180_af.func_187227_b(SPECIAL_ATTACK_TICK, (Object)tick);
    }

    public int getWarmupTick() {
        return (Integer)this.field_70180_af.func_187225_a(SPECIAL_ATTACK_WARMUP_TICK);
    }

    public void setWarmupTick(int tick) {
        this.field_70180_af.func_187227_b(SPECIAL_ATTACK_WARMUP_TICK, (Object)tick);
    }

    public int getAttackType() {
        return (Integer)this.field_70180_af.func_187225_a(SPECIAL_ATTACK_TYPE);
    }

    public void setAttackType(int tick) {
        this.field_70180_af.func_187227_b(SPECIAL_ATTACK_TYPE, (Object)tick);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getAttackTick() == 100) {
            this.setAttackType(this.field_70146_Z.nextInt(4));
        }
        if (this.getAttackType() > 3) {
            this.setAttackType(3);
        } else if (this.getAttackType() < 0) {
            this.setAttackType(0);
        }
        if (this.getAttackTick() > 0 && this.func_70638_az() != null) {
            this.setAttackTick(this.getAttackTick() - 1);
        }
        if (this.getAttackTick() == 0) {
            this.setWarmupTick(this.getWarmupTick() - 1);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
            if (this.getWarmupTick() == 19 && this.getAttackType() == 0) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_219650_fj, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getWarmupTick() <= 0) {
                if (this.getAttackType() == 2) {
                    this.createParticles();
                }
                this.attack();
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.2499999940395355);
                this.setWarmupTick(20);
                this.setAttackTick(this.field_70146_Z.nextInt(100) + 100);
            }
        }
    }

    private void attack() {
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity livingentity;
            Object target;
            if (this.getAttackType() == 1 && (target = this.func_70638_az()) != null) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187724_dU, SoundCategory.HOSTILE, 2.0f, 0.0f);
                if ((double)target.func_70032_d((Entity)this) < 4.0) {
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 8.0f);
                    this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187835_fT, SoundCategory.HOSTILE, 2.0f, 0.0f);
                    this.launch((Entity)target, 8.0);
                }
            }
            if (this.getAttackType() == 2) {
                for (Entity entity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(4.0))) {
                    if (!(entity instanceof AbstractIllagerEntity) && !(entity instanceof EntityBlackIronGolem)) {
                        entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 6.0f);
                    }
                    this.launch(entity, 4.0);
                    this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 1.0f, (float)(this.field_70146_Z.nextInt(3) / 10) + 0.2f);
                }
            }
            if (this.getAttackType() == 3 && (livingentity = this.func_70638_az()) != null) {
                Vector3d vec3d = this.func_70676_i(1.0f);
                double d2 = livingentity.func_226277_ct_() - (this.func_226277_ct_() + vec3d.field_72450_a * 4.0);
                double d3 = livingentity.func_174813_aQ().field_72338_b + (double)(livingentity.func_213302_cg() / 2.0f) - (0.5 + this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f));
                double d4 = livingentity.func_226281_cx_() - (this.func_226281_cx_() + vec3d.field_72449_c * 4.0);
                this.field_70170_p.func_217378_a((PlayerEntity)null, 1016, new BlockPos((Vector3i)this.func_233580_cy_()), 0);
                FireballEntity fireballentity = new FireballEntity(this.field_70170_p, (LivingEntity)this, d2, d3, d4);
                fireballentity.field_92057_e = 1;
                fireballentity.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a * 2.0, this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f) + 0.5, this.func_226281_cx_() + vec3d.field_72449_c * 2.0);
                this.field_70170_p.func_217376_c((Entity)fireballentity);
            }
        }
    }

    private void launch(Entity entity, double amplifier) {
        double d0 = entity.func_226277_ct_() - this.func_226277_ct_();
        double d1 = entity.func_226281_cx_() - this.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.func_70024_g(d0 / d2 * amplifier, 0.2, d1 / d2 * amplifier);
    }

    private void createParticles() {
        Vector3d vec3d = this.func_174813_aQ().func_189972_c();
        for (int i = 0; i < 40; ++i) {
            double d0 = this.field_70170_p.field_73012_v.nextGaussian() * 0.4;
            double d1 = this.field_70170_p.field_73012_v.nextGaussian() * 0.4;
            double d2 = this.field_70170_p.field_73012_v.nextGaussian() * 0.4;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, d0, d1, d2);
        }
    }

    public static AttributeModifierMap attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.2499999940395355).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233820_c_, 20.0).func_233813_a_();
    }

    protected ResourceLocation func_184647_J() {
        return IllagerPlusLootTable.BLACK_IRON_GOLEM;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AttackTick", this.getAttackTick());
        compound.func_74768_a("AttackWarmupTick", this.getWarmupTick());
        compound.func_74768_a("AttackType", this.getAttackType());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAttackTick(compound.func_74762_e("AttackTick"));
        this.setWarmupTick(compound.func_74762_e("AttackWarmupTick"));
        if (compound.func_74762_e("AttackType") > 3) {
            this.setAttackType(3);
        } else if (compound.func_74762_e("AttackType") < 0) {
            this.setAttackType(0);
        } else {
            this.setAttackType(compound.func_74762_e("AttackType"));
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }
}

