/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.objects.entity;

import com.litewolf101.illagers_plus.init.EntityInit;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFallingIce
extends Entity {
    private static final DataParameter<Integer> GROWING_TIME = EntityDataManager.func_187226_a(EntityFallingIce.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_GROWTH_TIME = EntityDataManager.func_187226_a(EntityFallingIce.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int castingDelay = 12;
    private LivingEntity caster;
    private UUID casterUuid;
    public boolean clientSideAttackStarted;
    public boolean sentSpikeEvent;

    public EntityFallingIce(EntityType<? extends EntityFallingIce> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public EntityFallingIce(World worldIn, double x, double y, double z, float rot, int castingDelay, LivingEntity casterIn, int maxGrowthTime) {
        this(EntityInit.FALLING_ICE, worldIn);
        this.castingDelay = castingDelay;
        this.setMaxGrowthTime(maxGrowthTime);
        this.setCaster(casterIn);
        this.field_70177_z = rot * 57.295776f;
        this.func_70107_b(x, y, z);
    }

    public void onRemovedFromWorld() {
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187561_bM, SoundCategory.HOSTILE, 1.0f, 1.0f);
        for (int i = 0; i < 16; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150432_aD.func_176223_P()), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), this.field_70146_Z.nextDouble(), 0.0, this.field_70146_Z.nextDouble());
        }
        super.onRemovedFromWorld();
    }

    public int getGrowthTicks() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_TIME);
    }

    public void setGrowthTicks(int amount) {
        this.field_70180_af.func_187227_b(GROWING_TIME, (Object)amount);
    }

    public int getMaxGrowthTime() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_GROWTH_TIME);
    }

    public void setMaxGrowthTime(int amount) {
        this.field_70180_af.func_187227_b(MAX_GROWTH_TIME, (Object)amount);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(GROWING_TIME, (Object)0);
        this.field_70180_af.func_187214_a(MAX_GROWTH_TIME, (Object)10);
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.castingDelay = compound.func_74762_e("CastingDelay");
        this.setGrowthTicks(compound.func_74762_e("GrowthTick"));
        this.setMaxGrowthTime(compound.func_74762_e("MaxGrowthTime"));
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("CastingDelay", this.castingDelay);
        compound.func_74768_a("GrowthTick", this.getGrowthTicks());
        compound.func_74768_a("MaxGrowthTime", this.getMaxGrowthTime());
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                double d1 = this.func_226278_cu_() + 0.05 + this.field_70146_Z.nextDouble();
                double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                if (this.field_70146_Z.nextInt(10) > 7) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        } else if (--this.castingDelay < 0) {
            if (this.getGrowthTicks() < this.getMaxGrowthTime()) {
                this.setGrowthTicks(this.getGrowthTicks() + 1);
            } else {
                float f;
                Vector3d vector3d = this.func_213322_ci();
                double d2 = this.func_226277_ct_() + vector3d.field_72450_a;
                double d0 = this.func_226278_cu_() + vector3d.field_72448_b;
                double d1 = this.func_226281_cx_() + vector3d.field_72449_c;
                if (this.func_70090_H()) {
                    for (int i = 0; i < 4; ++i) {
                        float f1 = 0.25f;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d2 - vector3d.field_72450_a * 0.25, d0 - vector3d.field_72448_b * 0.25, d1 - vector3d.field_72449_c * 0.25, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                    }
                    f = 0.8f;
                } else {
                    f = 0.99f;
                }
                this.func_213317_d(vector3d.func_186678_a((double)f));
                if (!this.func_189652_ae()) {
                    Vector3d vector3d1 = this.func_213322_ci();
                    this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b - 0.02, vector3d1.field_72449_c);
                }
                this.func_70107_b(d2, d0, d1);
                for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
        }
        if (!this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_203425_a(Blocks.field_150350_a)) {
            this.func_70106_y();
        }
    }

    private void damage(LivingEntity entity) {
        LivingEntity livingentity = this.getCaster();
        if (entity.func_70089_S() && !entity.func_190530_aW() && entity != livingentity) {
            if (livingentity == null) {
                entity.func_70097_a(DamageSource.field_76376_m, 6.0f);
            } else {
                if (livingentity.func_184191_r((Entity)entity)) {
                    return;
                }
                entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)livingentity), 6.0f);
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 3));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191242_bl, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.castingDelay - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - partialTicks) / 20.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGrowingPercentage(float partialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        return (float)this.getGrowthTicks() / (float)this.getMaxGrowthTime();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

