/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.objects.entity;

import com.litewolf101.illagers_plus.objects.entity.EntityAbstractIPSpellcaster;
import com.litewolf101.illagers_plus.objects.entity.EntityFallingIce;
import com.litewolf101.illagers_plus.objects.entity.EntityIceBall;
import com.litewolf101.illagers_plus.objects.entity.EntityIceSpike;
import com.litewolf101.illagers_plus.objects.entity.EntitySupportColumn;
import com.litewolf101.illagers_plus.utils.INeedIllagerBoost;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityFrostmancer
extends EntityAbstractIPSpellcaster
implements INeedIllagerBoost {
    private static final Predicate<Entity> TARGET_SELECTOR = p_213489_0_ -> {
        if (p_213489_0_ instanceof PlayerEntity) {
            return !((PlayerEntity)p_213489_0_).func_184812_l_() && !p_213489_0_.func_175149_v();
        }
        return p_213489_0_.func_70089_S() && !p_213489_0_.func_175149_v() && !(p_213489_0_ instanceof PatrollerEntity) && !(p_213489_0_ instanceof EntityFallingIce) && !(p_213489_0_ instanceof EntityIceSpike) && !(p_213489_0_ instanceof EvokerFangsEntity) && !(p_213489_0_ instanceof EntitySupportColumn);
    };

    public EntityFrostmancer(EntityType<? extends EntityAbstractIPSpellcaster> type, World world) {
        super(type, world);
        this.field_70728_aV = 15;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonFallingIceGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new ChillingSwallowGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new IceSpikeGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new IceBallGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.6).func_233815_a_(Attributes.field_233819_b_, 15.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233813_a_();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, Blocks.field_196604_cC.func_176223_P()), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.getSpellType() == EntityAbstractIPSpellcaster.SpellType.CHILLING_SWALLOW) {
            for (int i = 0; i < 50; ++i) {
                BlockPos pos = new BlockPos(this.func_226282_d_(32.0), this.func_226279_cv_(), this.func_226287_g_(32.0));
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197602_M, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (this.func_226277_ct_() - (double)pos.func_177958_n()) / 24.0, -0.01, (this.func_226281_cx_() - (double)pos.func_177952_p()) / 24.0);
            }
            List entities = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_72314_b(24.0, 3.0, 24.0), TARGET_SELECTOR);
            for (Entity entity : entities) {
                if (entity instanceof PatrollerEntity || entity instanceof EntityFallingIce) continue;
                if (entity.func_70068_e((Entity)this) > 3.0) {
                    entity.func_70024_g((this.func_226277_ct_() - entity.func_226277_ct_()) / 128.0, 0.0, (this.func_226281_cx_() - entity.func_226281_cx_()) / 128.0);
                }
                entity.func_70097_a(DamageSource.field_76376_m, 0.01f);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected ResourceLocation func_184647_J() {
        return IllagerPlusLootTable.FROSTMANCER;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219624_cV;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191246_bp;
    }

    @Override
    protected SoundEvent getSpellSound() {
        return SoundEvents.field_191244_bn;
    }

    class IceBallGoal
    extends EntityAbstractIPSpellcaster.UseSpellGoal {
        private IceBallGoal() {
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 60;
        }

        @Override
        protected void castSpell() {
            LivingEntity target = EntityFrostmancer.this.func_70638_az();
            if (target != null) {
                EntityIceBall ball = new EntityIceBall(EntityFrostmancer.this.field_70170_p, (LivingEntity)EntityFrostmancer.this);
                double d0 = target.func_226280_cw_() - (double)1.1f;
                double d1 = target.func_226277_ct_() - EntityFrostmancer.this.func_226277_ct_();
                double d2 = d0 - ball.func_226278_cu_();
                double d3 = target.func_226281_cx_() - EntityFrostmancer.this.func_226281_cx_();
                float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
                ball.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
                EntityFrostmancer.this.func_184185_a(SoundEvents.field_187797_fA, 1.0f, 0.4f / (EntityFrostmancer.this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                EntityFrostmancer.this.field_70170_p.func_217376_c((Entity)ball);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected EntityAbstractIPSpellcaster.SpellType getSpellType() {
            return EntityAbstractIPSpellcaster.SpellType.ICE_THROW;
        }
    }

    class IceSpikeGoal
    extends EntityAbstractIPSpellcaster.UseSpellGoal {
        private IceSpikeGoal() {
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 60;
        }

        @Override
        protected void castSpell() {
            LivingEntity livingentity = EntityFrostmancer.this.func_70638_az();
            float f = (float)MathHelper.func_181159_b((double)(livingentity.func_226281_cx_() - EntityFrostmancer.this.func_226281_cx_()), (double)(livingentity.func_226277_ct_() - EntityFrostmancer.this.func_226277_ct_()));
            EntityFrostmancer.this.field_70170_p.func_217376_c((Entity)new EntityIceSpike(EntityFrostmancer.this.field_70170_p, livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), f, 20, (LivingEntity)EntityFrostmancer.this, 20, 60));
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected EntityAbstractIPSpellcaster.SpellType getSpellType() {
            return EntityAbstractIPSpellcaster.SpellType.ICE_CAP_ATTACK;
        }
    }

    class SummonFallingIceGoal
    extends EntityAbstractIPSpellcaster.UseSpellGoal {
        private SummonFallingIceGoal() {
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected void castSpell() {
            LivingEntity livingentity = EntityFrostmancer.this.func_70638_az();
            double d0 = Math.min(livingentity.func_226278_cu_(), EntityFrostmancer.this.func_226278_cu_());
            double d1 = Math.max(livingentity.func_226278_cu_(), EntityFrostmancer.this.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(livingentity.func_226281_cx_() - EntityFrostmancer.this.func_226281_cx_()), (double)(livingentity.func_226277_ct_() - EntityFrostmancer.this.func_226277_ct_()));
            for (int l = 0; l < 16; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                int j = 1 * l;
                this.spawnFangs(EntityFrostmancer.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, EntityFrostmancer.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
            }
        }

        private void spawnFangs(double x, double z, double height, double y, float rotYaw, int delay) {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos = new BlockPos(x, y, z);
            boolean flag = false;
            double d0 = 0.0;
            BlockPos blockpos1 = blockpos.func_177984_a();
            BlockState blockstate = EntityFrostmancer.this.field_70170_p.func_180495_p(blockpos1);
            if (!EntityFrostmancer.this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = EntityFrostmancer.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)EntityFrostmancer.this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            if (flag = true) {
                EntityFrostmancer.this.field_70170_p.func_217376_c((Entity)new EntityFallingIce(EntityFrostmancer.this.field_70170_p, x, (double)blockpos.func_177956_o() + 2.0, z, rotYaw, delay, (LivingEntity)EntityFrostmancer.this, 20));
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected EntityAbstractIPSpellcaster.SpellType getSpellType() {
            return EntityAbstractIPSpellcaster.SpellType.SUMMON_FALLING_ICE_SPEAR;
        }
    }

    class ChillingSwallowGoal
    extends EntityAbstractIPSpellcaster.UseSpellGoal {
        private ChillingSwallowGoal() {
        }

        @Override
        protected int getCastingTime() {
            return 120;
        }

        @Override
        protected int getCastWarmupTime() {
            return 80;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void castSpell() {
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected EntityAbstractIPSpellcaster.SpellType getSpellType() {
            return EntityAbstractIPSpellcaster.SpellType.CHILLING_SWALLOW;
        }
    }

    class CastingSpellGoal
    extends EntityAbstractIPSpellcaster.CastingASpellGoal {
        private CastingSpellGoal() {
        }

        @Override
        public void func_75246_d() {
            if (EntityFrostmancer.this.func_70638_az() != null) {
                EntityFrostmancer.this.func_70671_ap().func_75651_a((Entity)EntityFrostmancer.this.func_70638_az(), (float)EntityFrostmancer.this.func_184649_cE(), (float)EntityFrostmancer.this.func_70646_bf());
            }
        }
    }
}

