/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.objects.entity;

import com.litewolf101.illagers_plus.init.EntityInit;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityIceSpike
extends Entity {
    private static final DataParameter<Integer> GROWING_TIME = EntityDataManager.func_187226_a(EntityIceSpike.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_GROWTH_TIME = EntityDataManager.func_187226_a(EntityIceSpike.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int castingDelay = 12;
    private LivingEntity caster;
    private UUID casterUuid;
    public boolean clientSideAttackStarted;
    public boolean sentSpikeEvent;
    public int lifeTick = 150;

    public EntityIceSpike(EntityType<? extends EntityIceSpike> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public EntityIceSpike(World worldIn, double x, double y, double z, float rot, int castingDelay, LivingEntity casterIn, int maxGrowthTime, int lifeTick) {
        this(EntityInit.ICE_SPIKE, worldIn);
        this.castingDelay = castingDelay;
        this.setMaxGrowthTime(maxGrowthTime);
        this.setCaster(casterIn);
        this.lifeTick = lifeTick;
        this.field_70177_z = rot * 57.295776f;
        this.func_70107_b(x, y, z);
    }

    public int getGrowthTime() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_TIME);
    }

    public void setGrowthTime(int amount) {
        this.field_70180_af.func_187227_b(GROWING_TIME, (Object)amount);
    }

    public int getMaxGrowthTime() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_GROWTH_TIME);
    }

    public void setMaxGrowthTime(int amount) {
        this.field_70180_af.func_187227_b(MAX_GROWTH_TIME, (Object)amount);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(GROWING_TIME, (Object)0);
        this.field_70180_af.func_187214_a(MAX_GROWTH_TIME, (Object)10);
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.castingDelay = compound.func_74762_e("CastingDelay");
        this.setGrowthTime(compound.func_74762_e("GrowthTick"));
        this.setMaxGrowthTime(compound.func_74762_e("MaxGrowthTime"));
        this.lifeTick = compound.func_74762_e("LifeTick");
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("CastingDelay", this.castingDelay);
        compound.func_74768_a("GrowthTick", this.getGrowthTime());
        compound.func_74768_a("MaxGrowthTime", this.getMaxGrowthTime());
        compound.func_74768_a("LifeTick", this.lifeTick);
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        List list;
        double d2;
        double d1;
        double d0;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                // empty if block
            }
        } else if (--this.castingDelay < 0) {
            if (this.getGrowthTime() < this.getMaxGrowthTime()) {
                this.setGrowthTime(this.getGrowthTime() + 1);
            } else {
                --this.lifeTick;
                for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
        }
        if (this.lifeTick < 0) {
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187561_bM, SoundCategory.HOSTILE, 1.0f, 0.0f);
            this.func_70106_y();
        }
        if (this.getGrowthTime() < this.getMaxGrowthTime()) {
            d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
            d1 = this.func_226278_cu_() + 0.05 + this.field_70146_Z.nextDouble();
            d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150403_cj.func_176223_P()), d0, d1, d2, 0.0, 0.0, 0.0);
        } else {
            d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
            d1 = this.func_226278_cu_() + 0.05 + this.field_70146_Z.nextDouble();
            d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, d0, d1, d2, 0.0, 0.0, 0.0);
        }
        if (this.getGrowthTime() >= this.getMaxGrowthTime() && !(list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())).isEmpty()) {
            for (Entity entity : list) {
                if (entity instanceof ShulkerEntity || entity.field_70145_X) continue;
                entity.func_213315_a(MoverType.SHULKER, new Vector3d((this.func_226277_ct_() + entity.func_226277_ct_()) * 7.5E-5, (this.func_226278_cu_() + entity.func_226278_cu_()) * 7.5E-5, (this.func_226281_cx_() + entity.func_226281_cx_()) * 7.5E-5));
            }
        }
    }

    private void damage(LivingEntity entity) {
        LivingEntity livingentity = this.getCaster();
        if (entity.func_70089_S() && !entity.func_190530_aW() && entity != livingentity) {
            if (livingentity == null) {
                entity.func_70097_a(DamageSource.field_76376_m, 12.0f);
            } else {
                if (livingentity.func_184191_r((Entity)entity)) {
                    return;
                }
                entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)livingentity), 6.0f);
                double d0 = entity.func_226277_ct_() - this.func_226277_ct_();
                double d1 = entity.func_226281_cx_() - this.func_226281_cx_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                entity.func_70024_g(d0 / d2 * 2.0, 0.6, d1 / d2 * 2.0);
            }
        }
    }

    public boolean func_70067_L() {
        return this.getGrowthTime() >= this.getMaxGrowthTime();
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.castingDelay - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - partialTicks) / 20.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGrowingPercentage(float partialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        return (float)this.getGrowthTime() / (float)this.getMaxGrowthTime();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

