/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.objects.entity;

import com.litewolf101.illagers_plus.objects.entity.EntityAbstractIPSpellcaster;
import com.litewolf101.illagers_plus.utils.INeedIllagerBoost;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityNecromancer
extends EntityAbstractIPSpellcaster
implements INeedIllagerBoost {
    private static final Predicate<LivingEntity> TARGET_SELECTOR = p_213489_0_ -> {
        if (p_213489_0_ instanceof PlayerEntity) {
            return !((PlayerEntity)p_213489_0_).func_184812_l_() && !p_213489_0_.func_175149_v();
        }
        return p_213489_0_.func_70089_S() && !p_213489_0_.func_175149_v() && !(p_213489_0_ instanceof PatrollerEntity);
    };

    public EntityNecromancer(EntityType<? extends EntityNecromancer> type, World world) {
        super((EntityType<? extends EntityAbstractIPSpellcaster>)type, world);
        this.field_70728_aV = 17;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.3, 0.5));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonZombiesGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new SummonFangsGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new VanpirismGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PillagerEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.6).func_233815_a_(Attributes.field_233819_b_, 15.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233813_a_();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_213660_a(int wave, boolean p_213660_2_) {
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219624_cV;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List zombies = this.field_70170_p.func_217357_a(ZombieEntity.class, this.func_174813_aQ().func_186662_g(10.0));
        for (ZombieEntity zombieEntity : zombies) {
            if (!(zombieEntity.func_70638_az() instanceof AbstractRaiderEntity)) continue;
            if (this.func_70638_az() != null) {
                zombieEntity.func_70624_b(this.func_70638_az());
                continue;
            }
            zombieEntity.func_70624_b(null);
        }
    }

    protected ResourceLocation func_184647_J() {
        return IllagerPlusLootTable.NECROMANCER;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191246_bp;
    }

    @Override
    protected SoundEvent getSpellSound() {
        return SoundEvents.field_191244_bn;
    }

    class VanpirismGoal
    extends EntityAbstractIPSpellcaster.UseSpellGoal {
        private VanpirismGoal() {
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 200;
        }

        @Override
        protected void castSpell() {
            int i = 0;
            for (LivingEntity entity : EntityNecromancer.this.field_70170_p.func_175647_a(LivingEntity.class, EntityNecromancer.this.func_174813_aQ().func_186662_g(15.0), TARGET_SELECTOR)) {
                ++i;
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)EntityNecromancer.this), 6.0f);
            }
            if (i > 0) {
                EntityNecromancer.this.func_70691_i((float)i / 2.0f);
            }
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (EntityNecromancer.this.field_70170_p.field_72995_K) {
                for (LivingEntity entity : EntityNecromancer.this.field_70170_p.func_175647_a(LivingEntity.class, EntityNecromancer.this.func_174813_aQ().func_186662_g(15.0), TARGET_SELECTOR)) {
                    for (int i = 0; i < 20; ++i) {
                        EntityNecromancer.this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(0.7f + (float)(EntityNecromancer.this.field_70146_Z.nextDouble() * 2.0), 0.0f, 0.0f, 1.0f), entity.func_226282_d_(0.5), entity.func_226279_cv_(), entity.func_226282_d_(0.5), 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_193789_dh;
        }

        @Override
        protected EntityAbstractIPSpellcaster.SpellType getSpellType() {
            return EntityAbstractIPSpellcaster.SpellType.VAMPIRISM;
        }
    }

    class SummonFangsGoal
    extends EntityAbstractIPSpellcaster.UseSpellGoal {
        private SummonFangsGoal() {
        }

        @Override
        protected int getCastingTime() {
            return 50;
        }

        @Override
        protected int getCastingInterval() {
            return 70;
        }

        @Override
        protected void castSpell() {
            int k;
            LivingEntity entitylivingbase = EntityNecromancer.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.func_226278_cu_(), EntityNecromancer.this.func_226278_cu_());
            double d1 = Math.max(entitylivingbase.func_226278_cu_(), EntityNecromancer.this.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.func_226281_cx_() - EntityNecromancer.this.func_226281_cx_()), (double)(entitylivingbase.func_226277_ct_() - EntityNecromancer.this.func_226277_ct_()));
            for (int i = 0; i < 5; ++i) {
                float f1 = f + (float)i * (float)Math.PI * 0.4f;
                this.spawnFangs(EntityNecromancer.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f1) * 1.5, EntityNecromancer.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f1) * 1.5, d0, d1, f1, 0);
            }
            for (k = 0; k < 8; ++k) {
                float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                this.spawnFangs(EntityNecromancer.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.5, EntityNecromancer.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, 5);
            }
            for (k = 0; k < 13; ++k) {
                float f3 = f + (float)k * (float)Math.PI * 2.0f / 13.0f + 0.62831855f;
                this.spawnFangs(EntityNecromancer.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f3) * 3.5, EntityNecromancer.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f3) * 3.5, d0, d1, f3, 10);
            }
            for (k = 0; k < 16; ++k) {
                float f4 = f + (float)k * (float)Math.PI * 2.0f / 16.0f + 0.31415927f;
                this.spawnFangs(EntityNecromancer.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f4) * 4.5, EntityNecromancer.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f4) * 4.5, d0, d1, f4, 15);
            }
        }

        private void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = EntityNecromancer.this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)EntityNecromancer.this.field_70170_p, blockpos1, Direction.UP)) continue;
                if (!EntityNecromancer.this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = EntityNecromancer.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)EntityNecromancer.this.field_70170_p, blockpos)).func_197766_b()) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                EntityNecromancer.this.field_70170_p.func_217376_c((Entity)new EvokerFangsEntity(EntityNecromancer.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)EntityNecromancer.this));
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected EntityAbstractIPSpellcaster.SpellType getSpellType() {
            return EntityAbstractIPSpellcaster.SpellType.CIRCLE_OF_FANG;
        }
    }

    class SummonZombiesGoal
    extends EntityAbstractIPSpellcaster.UseSpellGoal {
        private SummonZombiesGoal() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int i = EntityNecromancer.this.field_70170_p.func_217357_a(ZombieEntity.class, EntityNecromancer.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EntityNecromancer.this.field_70146_Z.nextInt(8) + 1 > i;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 200;
        }

        @Override
        protected void castSpell() {
            ServerWorld serverWorld;
            double x = EntityNecromancer.this.func_226277_ct_() + (double)EntityNecromancer.this.field_70146_Z.nextInt(6) - 3.0;
            double y = EntityNecromancer.this.func_226278_cu_() + (double)EntityNecromancer.this.field_70146_Z.nextInt(2) - 1.0;
            double z = EntityNecromancer.this.func_226281_cx_() + (double)EntityNecromancer.this.field_70146_Z.nextInt(6) - 3.0;
            BlockPos zombiepos = this.isAvailableLocation(EntityNecromancer.this.field_70170_p, x, y, z);
            for (int i = 0; i <= EntityNecromancer.this.field_70146_Z.nextInt(5); ++i) {
                ZombieEntity zombie = new ZombieEntity(EntityNecromancer.this.field_70170_p);
                zombie.func_70012_b((double)zombiepos.func_177958_n(), (double)(zombiepos.func_177956_o() + 1), (double)zombiepos.func_177952_p(), EntityNecromancer.this.field_70177_z, EntityNecromancer.this.field_70125_A);
                zombie.func_200203_b((ITextComponent)new StringTextComponent(this.giveRandomName()));
                zombie.func_174805_g(true);
                zombie.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151024_Q));
                zombie.func_70624_b(EntityNecromancer.this.func_70638_az());
                EntityNecromancer.this.field_70170_p.func_217376_c((Entity)zombie);
            }
            if (EntityNecromancer.this.field_70146_Z.nextInt(10) == 1 && EntityNecromancer.this.field_70170_p.func_73046_m() != null && (serverWorld = EntityNecromancer.this.field_70170_p.func_73046_m().func_71218_a(EntityNecromancer.this.field_70170_p.func_234923_W_())) != null) {
                ZombieVillagerEntity zombieVillager = new ZombieVillagerEntity(EntityType.field_200727_aF, EntityNecromancer.this.field_70170_p);
                zombieVillager.func_213792_a(new VillagerData(VillagerType.func_242371_a((Optional)serverWorld.func_242406_i(EntityNecromancer.this.func_233580_cy_())), VillagerProfession.field_221151_a, EntityNecromancer.this.field_70146_Z.nextInt(4)));
                zombieVillager.func_70012_b((double)zombiepos.func_177958_n(), (double)(zombiepos.func_177956_o() + 1), (double)zombiepos.func_177952_p(), EntityNecromancer.this.field_70177_z, EntityNecromancer.this.field_70125_A);
                zombieVillager.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151024_Q));
                EntityNecromancer.this.field_70170_p.func_217376_c((Entity)zombieVillager);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected EntityAbstractIPSpellcaster.SpellType getSpellType() {
            return EntityAbstractIPSpellcaster.SpellType.SUMMON_ZOMBIES;
        }

        public BlockPos isAvailableLocation(World world, double x, double y, double z) {
            BlockPos position = new BlockPos(x, y, z);
            boolean isNotValidLocation = world.func_180495_p(position).func_200132_m() || world.func_180495_p(position.func_177984_a()).func_200132_m();
            boolean check = false;
            if (isNotValidLocation) {
                check = true;
            }
            while (check) {
                position = new BlockPos((int)EntityNecromancer.this.func_226277_ct_() + EntityNecromancer.this.field_70146_Z.nextInt(6) - 3, (int)EntityNecromancer.this.func_226278_cu_() + EntityNecromancer.this.field_70146_Z.nextInt(2) - 1, (int)EntityNecromancer.this.func_226281_cx_() + EntityNecromancer.this.field_70146_Z.nextInt(6) - 3);
                if (world.func_180495_p(position).func_200132_m() && world.func_180495_p(position.func_177984_a()).func_200132_m()) continue;
                check = false;
                break;
            }
            return position;
        }

        public String giveRandomName() {
            Random random = new Random();
            int chance = random.nextInt(3);
            switch (chance) {
                case 0: {
                    return "Cod";
                }
                case 1: {
                    return "Zoomblez";
                }
                case 2: {
                    return "NomNom";
                }
            }
            return "Stitches";
        }
    }

    class CastingSpellGoal
    extends EntityAbstractIPSpellcaster.CastingASpellGoal {
        private CastingSpellGoal() {
        }

        @Override
        public void func_75246_d() {
            if (EntityNecromancer.this.func_70638_az() != null) {
                EntityNecromancer.this.func_70671_ap().func_75651_a((Entity)EntityNecromancer.this.func_70638_az(), (float)EntityNecromancer.this.func_184649_cE(), (float)EntityNecromancer.this.func_70646_bf());
            }
        }
    }
}

