/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.objects.entity;

import com.litewolf101.illagers_plus.init.EntityInit;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySupportColumn
extends Entity {
    private static final Map<BlockPos, Block> BLOCK_MAP = new HashMap<BlockPos, Block>();
    private static final DataParameter<Integer> BUILDING_TICK = EntityDataManager.func_187226_a(EntitySupportColumn.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COOLDOWN_TICK = EntityDataManager.func_187226_a(EntitySupportColumn.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_COOLDOWN_TIME = EntityDataManager.func_187226_a(EntitySupportColumn.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntitySupportColumn(EntityType<? extends EntitySupportColumn> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
        this.setMaxCooldownTime(200);
    }

    public EntitySupportColumn(World worldIn, double x, double y, double z, int maxCooldownTime) {
        this(EntityInit.SUPPORT_COLUMN, worldIn);
        this.func_70107_b((double)((int)x) + 0.5, y, (double)((int)z) + 0.5);
        this.setMaxCooldownTime(maxCooldownTime);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BUILDING_TICK, (Object)20);
        this.func_184212_Q().func_187214_a(COOLDOWN_TICK, (Object)0);
        this.func_184212_Q().func_187214_a(MAX_COOLDOWN_TIME, (Object)200);
    }

    public int getBuildingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(BUILDING_TICK);
    }

    public void setBuildingTicks(int amount) {
        this.field_70180_af.func_187227_b(BUILDING_TICK, (Object)amount);
    }

    public int getCooldownTicks() {
        return (Integer)this.field_70180_af.func_187225_a(COOLDOWN_TICK);
    }

    public void setCooldownTicks(int amount) {
        this.field_70180_af.func_187227_b(COOLDOWN_TICK, (Object)amount);
    }

    public int getMaxCooldownTime() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_COOLDOWN_TIME);
    }

    public void setMaxCooldownTime(int amount) {
        this.field_70180_af.func_187227_b(MAX_COOLDOWN_TIME, (Object)amount);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setBuildingTicks(compound.func_74762_e("BuildingTick"));
        this.setCooldownTicks(compound.func_74762_e("CooldownTick"));
        this.setMaxCooldownTime(compound.func_74762_e("MaxCooldownTime"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("BuildingTick", this.getBuildingTicks());
        compound.func_74768_a("CooldownTick", this.getCooldownTicks());
        compound.func_74768_a("MaxCooldownTime", this.getMaxCooldownTime());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos absPos = new BlockPos(Math.floor(this.func_226277_ct_()), Math.floor(this.func_226278_cu_()), Math.floor(this.func_226281_cx_()));
        if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b((double)absPos.func_177958_n() + 0.5, absPos.func_177956_o(), (double)absPos.func_177952_p() + 0.5);
            this.setBuildingTicks(this.getBuildingTicks() - 1);
            int check = 0;
            for (BlockPos pos : BLOCK_MAP.keySet()) {
                if (this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_177230_c() == BLOCK_MAP.get(pos)) {
                    ++check;
                    continue;
                }
                if (this.getBuildingTicks() >= 0) continue;
                this.field_70170_p.func_225521_a_(this.func_233580_cy_().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), true, (Entity)this);
                this.field_70170_p.func_175656_a(this.func_233580_cy_().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), BLOCK_MAP.get(pos).func_176223_P());
                this.field_70170_p.func_180495_p(pos).func_215705_a(this.field_70170_p, pos, this.field_70170_p.func_180495_p(pos), false);
                this.field_70170_p.func_180495_p(pos).func_235734_a_((IWorld)this.field_70170_p, pos, 3);
                this.field_70170_p.func_184133_a(null, pos, this.field_70170_p.func_180495_p(pos).func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.setBuildingTicks(100);
                break;
            }
            if (check == BLOCK_MAP.size()) {
                if (this.getCooldownTicks() > this.getMaxCooldownTime()) {
                    double x = this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(10) - 5.0;
                    double z = this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(10) - 5.0;
                    PillagerEntity pillager = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a(this.field_70170_p);
                    pillager.func_70107_b(x, (double)this.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z), z);
                    RegistryKey key = this.field_70170_p.func_234923_W_();
                    pillager.func_213386_a((IServerWorld)this.field_70170_p.func_73046_m().func_71218_a(key), this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                    this.field_70170_p.func_217376_c((Entity)pillager);
                    this.setCooldownTicks(0);
                } else {
                    this.setCooldownTicks(this.getCooldownTicks() + 1);
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_70106_y();
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        BLOCK_MAP.put(new BlockPos(1, -1, 1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(1, -1, -1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(-1, -1, -1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(-1, -1, 1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(1, 0, 1), Blocks.field_196696_di);
        BLOCK_MAP.put(new BlockPos(1, 0, -1), Blocks.field_196696_di);
        BLOCK_MAP.put(new BlockPos(-1, 0, -1), Blocks.field_196696_di);
        BLOCK_MAP.put(new BlockPos(-1, 0, 1), Blocks.field_196696_di);
        BLOCK_MAP.put(new BlockPos(0, 0, 1), Blocks.field_222413_lB);
        BLOCK_MAP.put(new BlockPos(1, 0, 0), Blocks.field_222413_lB);
        BLOCK_MAP.put(new BlockPos(0, 0, -1), Blocks.field_222413_lB);
        BLOCK_MAP.put(new BlockPos(-1, 0, 0), Blocks.field_222413_lB);
        BLOCK_MAP.put(new BlockPos(1, 1, 1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(1, 1, -1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(-1, 1, -1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(-1, 1, 1), Blocks.field_196672_s);
        BLOCK_MAP.put(new BlockPos(0, -1, 0), Blocks.field_196696_di);
        BLOCK_MAP.put(new BlockPos(0, 1, 0), Blocks.field_196696_di);
    }
}

