/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.utils;

import com.google.common.collect.Sets;
import com.litewolf101.illagers_plus.utils.FortRaidManager;
import com.litewolf101.illagers_plus.utils.FortRaidMobs;
import com.litewolf101.illagers_plus.utils.IllagerFortReinforcementGoal;
import com.litewolf101.illagers_plus.world.ModStructures;
import com.litewolf101.illagers_plus.world.structures.IllagerFortStructure;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class FortRaid {
    private final int id;
    private final ServerWorld world;
    ITextComponent RAID = new StringTextComponent(TextFormatting.RED + "Time Until Next Reinforcements");
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.RAID, BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true).func_186743_c(true);
    private BlockPos center;
    private boolean started;
    private boolean active;
    private long ticksActive;
    private Status status;
    private int currentWave;
    private final int maxWaves;

    public FortRaid(int id, ServerWorld world, BlockPos pos, int waves) {
        this.id = id;
        this.world = world;
        this.center = pos;
        this.active = true;
        this.bossInfo.func_186735_a(0.0f);
        this.status = Status.ONGOING;
        this.currentWave = 0;
        this.maxWaves = waves;
    }

    public FortRaid(ServerWorld world, CompoundNBT nbt) {
        this.world = world;
        this.id = nbt.func_74762_e("Id");
        this.center = new BlockPos(nbt.func_74762_e("CX"), nbt.func_74762_e("CY"), nbt.func_74762_e("CZ"));
        this.started = nbt.func_74767_n("Started");
        this.active = nbt.func_74767_n("Active");
        this.status = Status.getByName(nbt.func_74779_i("Status"));
        this.ticksActive = nbt.func_74763_f("TicksActive");
        this.currentWave = nbt.func_74762_e("CurrentWave");
        this.maxWaves = nbt.func_74762_e("MaxWaves");
    }

    public World getWorld() {
        return this.world;
    }

    public void tick() {
        if (!this.isStopped() && this.status == Status.ONGOING) {
            boolean flag = this.active;
            this.active = this.world.func_175667_e(this.center);
            if (this.world.func_175659_aa() == Difficulty.PEACEFUL) {
                this.stop();
                return;
            }
            if (this.currentWave > this.maxWaves) {
                this.stop();
                return;
            }
            if (flag != this.active) {
                this.bossInfo.func_186758_d(this.active);
            }
            if (!this.active) {
                return;
            }
            int i = (int)this.ticksActive % 5000;
            this.bossInfo.func_186735_a((float)i / 5000.0f);
            if (i == 0) {
                this.spawnWave(this.center);
                ++this.currentWave;
            }
            this.bossInfo.func_186739_a((ITextComponent)this.RAID.func_230532_e_().func_240702_b_(" - ").func_230529_a_((ITextComponent)new StringTextComponent("(" + this.currentWave + "/" + this.maxWaves + ")")));
            this.updateBossInfoVisibility();
            ++this.ticksActive;
            this.markDirty();
        }
    }

    private void spawnWave(BlockPos center) {
        if (this.world.func_241827_a(SectionPos.func_218167_a((BlockPos)center), (Structure)ModStructures.ILLAGER_FORT.get()).findAny().isPresent()) {
            Optional fort = this.world.func_241827_a(SectionPos.func_218167_a((BlockPos)center), (Structure)ModStructures.ILLAGER_FORT.get()).findAny();
            BlockPos start = ((IllagerFortStructure.Start)((Object)fort.get())).getStructureEntrance();
            for (int i = 0; i < this.world.field_73012_v.nextInt(12) + 12; ++i) {
                MobEntity entity = (MobEntity)FortRaidMobs.getRandomRaidMob(this.world.field_73012_v).func_200721_a((World)this.world);
                entity.func_70107_b((double)start.func_177958_n() + this.world.field_73012_v.nextDouble(), (double)start.func_177956_o(), (double)start.func_177952_p() + this.world.field_73012_v.nextDouble());
                entity.func_213386_a((IServerWorld)this.world, this.world.func_175649_E(start), SpawnReason.EVENT, null, null);
                entity.func_110163_bv();
                entity.field_70714_bg.func_75776_a(4, (Goal)new IllagerFortReinforcementGoal((AbstractRaiderEntity)entity, 0.9, 64));
                this.world.func_217376_c((Entity)entity);
            }
        }
    }

    private void markDirty() {
        FortRaidManager.forWorld(this.world).func_76185_a();
    }

    public int getId() {
        return this.id;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74768_a("Id", this.id);
        nbt.func_74757_a("Started", this.started);
        nbt.func_74757_a("Active", this.active);
        nbt.func_74778_a("Status", this.status.getName());
        nbt.func_74768_a("CX", this.center.func_177958_n());
        nbt.func_74768_a("CY", this.center.func_177956_o());
        nbt.func_74768_a("CZ", this.center.func_177952_p());
        nbt.func_74772_a("TicksActive", this.ticksActive);
        nbt.func_74768_a("CurrentWave", this.currentWave);
        nbt.func_74768_a("MaxWaves", this.maxWaves);
        return nbt;
    }

    private Predicate<ServerPlayerEntity> getParticipantsPredicate() {
        return p_221302_1_ -> {
            BlockPos blockpos = p_221302_1_.func_233580_cy_();
            FortRaidManager manager = FortRaidManager.forWorld(this.world);
            return p_221302_1_.func_70089_S() && manager.findRaid(blockpos, 18432) == this;
        };
    }

    private void updateBossInfoVisibility() {
        HashSet set = Sets.newHashSet((Iterable)this.bossInfo.func_186757_c());
        List list = this.world.func_217490_a(this.getParticipantsPredicate());
        for (ServerPlayerEntity serverplayerentity : list) {
            if (set.contains(serverplayerentity)) continue;
            this.bossInfo.func_186760_a(serverplayerentity);
        }
        for (ServerPlayerEntity serverplayerentity1 : set) {
            if (list.contains(serverplayerentity1)) continue;
            this.bossInfo.func_186761_b(serverplayerentity1);
        }
    }

    public void stop() {
        this.active = false;
        this.bossInfo.func_201360_b();
        this.status = Status.STOPPED;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void setCenter(BlockPos p_223024_1_) {
        this.center = p_223024_1_;
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public int getMaxWaves() {
        return this.maxWaves;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    static enum Status {
        ONGOING,
        STOPPED;

        private static final Status[] VALUES;

        private static Status getByName(String name) {
            for (Status raid$status : VALUES) {
                if (!name.equalsIgnoreCase(raid$status.name())) continue;
                return raid$status;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = Status.values();
        }
    }
}

