/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.utils;

import com.google.common.collect.Maps;
import com.litewolf101.illagers_plus.utils.FortRaid;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class FortRaidManager
extends WorldSavedData
implements Supplier {
    private final Map<Integer, FortRaid> byId = Maps.newHashMap();
    private final ServerWorld world;
    private int tick;
    private int nextAvailableId = 1;

    public FortRaidManager(ServerWorld world) {
        super("fort_raids");
        this.world = world;
        this.func_76185_a();
    }

    public static FortRaidManager forWorld(ServerWorld world) {
        FortRaidManager sup;
        DimensionSavedDataManager storage = world.func_217481_x();
        FortRaidManager saver = (FortRaidManager)storage.func_215752_a((Supplier)(sup = new FortRaidManager(world)), "fort_raids");
        if (saver == null) {
            saver = new FortRaidManager(world);
            storage.func_215757_a((WorldSavedData)saver);
        }
        return saver;
    }

    public FortRaid get(int id) {
        return this.byId.get(id);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.nextAvailableId = nbt.func_74762_e("NextAvailableID");
        this.tick = nbt.func_74762_e("Tick");
        ListNBT listnbt = nbt.func_150295_c("Raids", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            FortRaid raid = new FortRaid(this.world, compoundnbt);
            this.byId.put(raid.getId(), raid);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        nbt.func_74768_a("NextAvailableID", this.nextAvailableId);
        nbt.func_74768_a("Tick", this.tick);
        ListNBT listnbt = new ListNBT();
        for (FortRaid raid : this.byId.values()) {
            CompoundNBT compoundnbt = new CompoundNBT();
            raid.write(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        nbt.func_218657_a("Raids", (INBT)listnbt);
        return nbt;
    }

    public Object get() {
        return this;
    }

    public void tick() {
        ++this.tick;
        Iterator<FortRaid> iterator = this.byId.values().iterator();
        while (iterator.hasNext()) {
            FortRaid raid = iterator.next();
            if (this.world.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                raid.stop();
            }
            if (raid.isStopped()) {
                iterator.remove();
                this.func_76185_a();
            } else {
                raid.tick();
            }
            raid.tick();
        }
        if (this.tick % 200 == 0) {
            this.func_76185_a();
        }
    }

    private int incrementNextId() {
        return ++this.nextAvailableId;
    }

    @Nullable
    public FortRaid generalDeathTick(ServerPlayerEntity player) {
        if (player.func_175149_v()) {
            return null;
        }
        if (this.world.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
            return null;
        }
        DimensionType dimensiontype = player.field_70170_p.func_230315_m_();
        if (!dimensiontype.func_241512_l_()) {
            return null;
        }
        FortRaid raid = this.findOrCreateRaid(player.func_71121_q(), player.func_233580_cy_());
        boolean flag = false;
        if (!raid.isStarted()) {
            if (!this.byId.containsKey(raid.getId())) {
                this.byId.put(raid.getId(), raid);
            }
            flag = true;
        }
        if (flag) {
            // empty if block
        }
        this.func_76185_a();
        return raid;
    }

    private FortRaid findOrCreateRaid(ServerWorld world, BlockPos pos) {
        FortRaidManager saver = FortRaidManager.forWorld(world);
        FortRaid raid = saver.findRaid(pos, 18432);
        return raid != null ? raid : new FortRaid(this.incrementNextId(), world, pos, 5 + world.field_73012_v.nextInt(world.func_175649_E(pos).func_203095_a().func_151525_a()) * 2);
    }

    @Nullable
    public FortRaid findRaid(BlockPos pos, int distance) {
        FortRaid raid = null;
        double d0 = distance;
        for (FortRaid raid1 : this.byId.values()) {
            double d1 = raid1.getCenter().func_177951_i((Vector3i)pos);
            if (!raid1.isActive() || !(d1 < d0)) continue;
            raid = raid1;
            d0 = d1;
        }
        return raid;
    }
}

