/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.utils;

import com.litewolf101.illagers_plus.init.EntityInit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.DungeonHooks;

public class FortRaidMobs {
    private static final ArrayList<RaidMob> raidMobs = new ArrayList();

    public static float addRaidMob(EntityType<?> type, int rarity) {
        if (rarity <= 0) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        Iterator<RaidMob> itr = raidMobs.iterator();
        while (itr.hasNext()) {
            RaidMob mob = itr.next();
            if (type != mob.type) continue;
            itr.remove();
            rarity = mob.field_76292_a + rarity;
            break;
        }
        raidMobs.add(new RaidMob(rarity, type));
        return rarity;
    }

    public static int removeRaidMob(EntityType<?> name) {
        for (RaidMob mob : raidMobs) {
            if (name != mob.type) continue;
            raidMobs.remove((Object)mob);
            return mob.field_76292_a;
        }
        return 0;
    }

    public static EntityType<?> getRandomRaidMob(Random rand) {
        RaidMob mob = (RaidMob)WeightedRandom.func_76271_a((Random)rand, raidMobs);
        return mob.type;
    }

    static {
        FortRaidMobs.addRaidMob(EntityType.field_220350_aJ, 100);
        FortRaidMobs.addRaidMob(EntityType.field_200758_ax, 50);
        FortRaidMobs.addRaidMob(EntityType.field_220352_aU, 10);
        FortRaidMobs.addRaidMob(EntityType.field_200806_t, 5);
        FortRaidMobs.addRaidMob(EntityType.field_200764_D, 5);
        FortRaidMobs.addRaidMob(EntityInit.NECROMANCER, 5);
        FortRaidMobs.addRaidMob(EntityInit.FROSTMANCER, 5);
        FortRaidMobs.addRaidMob(EntityInit.FURANTUR, 25);
        FortRaidMobs.addRaidMob(EntityInit.ARCHER, 25);
        FortRaidMobs.addRaidMob(EntityInit.ENCHANTER, 10);
    }

    public static class RaidMob
    extends WeightedRandom.Item {
        public final EntityType<?> type;

        public RaidMob(int weight, EntityType<?> type) {
            super(weight);
            this.type = type;
        }

        public boolean equals(Object target) {
            return target instanceof DungeonHooks.DungeonMob && this.type.equals((Object)((DungeonHooks.DungeonMob)target).type);
        }
    }
}

