/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.utils;

import com.google.common.collect.Lists;
import com.litewolf101.illagers_plus.utils.FortRaid;
import com.litewolf101.illagers_plus.utils.FortRaidManager;
import com.litewolf101.illagers_plus.world.ModStructures;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;

public class IllagerFortReinforcementGoal
extends Goal {
    private final AbstractRaiderEntity raiderEntity;
    private final double speed;
    private final List<BlockPos> cachedPointOfInterest = Lists.newArrayList();
    private final int distance;
    private BlockPos blockPos;
    private boolean idling;

    public IllagerFortReinforcementGoal(AbstractRaiderEntity raiderEntity, double speed, int distance) {
        this.raiderEntity = raiderEntity;
        this.speed = speed;
        this.distance = distance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        this.clearLastCachedPoint();
        return this.isActive() && this.findValidHome() != null && this.raiderEntity.func_70638_az() == null;
    }

    private boolean isActive() {
        FortRaidManager saver = FortRaidManager.forWorld((ServerWorld)this.raiderEntity.field_70170_p);
        FortRaid raid = saver.findRaid(this.raiderEntity.func_233580_cy_(), 18432);
        return raid != null;
    }

    private BlockPos findValidHome() {
        ServerWorld serverworld = (ServerWorld)this.raiderEntity.field_70170_p;
        BlockPos blockpos = this.raiderEntity.func_233580_cy_();
        if (!serverworld.func_241827_a(SectionPos.func_218167_a((BlockPos)blockpos), (Structure)ModStructures.ILLAGER_FORT.get()).findAny().isPresent()) {
            return null;
        }
        Optional fort = serverworld.func_241827_a(SectionPos.func_218167_a((BlockPos)blockpos), (Structure)ModStructures.ILLAGER_FORT.get()).findAny();
        this.blockPos = new BlockPos(((StructureStart)fort.get()).func_204294_a().func_177958_n(), serverworld.func_201676_a(Heightmap.Type.WORLD_SURFACE, ((StructureStart)fort.get()).func_204294_a().func_177958_n(), ((StructureStart)fort.get()).func_204294_a().func_177952_p()), ((StructureStart)fort.get()).func_204294_a().func_177952_p());
        return this.blockPos;
    }

    public boolean func_75253_b() {
        if (this.raiderEntity.func_70661_as().func_75500_f()) {
            return false;
        }
        return this.raiderEntity.func_70638_az() == null && !this.blockPos.func_218137_a((IPosition)this.raiderEntity.func_213303_ch(), (double)(this.raiderEntity.func_213311_cf() + (float)this.distance)) && !this.idling;
    }

    public void func_75251_c() {
        if (this.blockPos.func_218137_a((IPosition)this.raiderEntity.func_213303_ch(), (double)this.distance)) {
            this.cachedPointOfInterest.add(this.blockPos);
        }
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.raiderEntity.func_213332_m(0);
        this.raiderEntity.func_70661_as().func_75492_a((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p(), this.speed);
        this.idling = false;
    }

    public void func_75246_d() {
        if (this.raiderEntity.func_70661_as().func_75500_f()) {
            Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)this.blockPos);
            Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)this.raiderEntity, (int)16, (int)7, (Vector3d)vector3d, (double)0.3141592741012573);
            if (vector3d1 == null) {
                vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.raiderEntity, (int)8, (int)7, (Vector3d)vector3d);
            }
            if (vector3d1 == null) {
                this.idling = true;
                return;
            }
            this.raiderEntity.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.speed);
        }
    }

    private boolean isValidDoorPosition(BlockPos pos) {
        for (BlockPos blockpos : this.cachedPointOfInterest) {
            if (!Objects.equals(pos, blockpos)) continue;
            return false;
        }
        return true;
    }

    private void clearLastCachedPoint() {
        if (this.cachedPointOfInterest.size() > 2) {
            this.cachedPointOfInterest.remove(0);
        }
    }
}

