/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.utils;

import com.litewolf101.illagers_plus.config.ModConfig;
import com.litewolf101.illagers_plus.world.ModStructures;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.gen.feature.structure.Structure;

public class StructureInfo {
    private static final Map<ResourceLocation, Integer> MIN_DIST = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Integer> MAX_DIST = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, List<? extends String>> BLACKLIST = new HashMap<ResourceLocation, List<? extends String>>();

    public static StringTextComponent setInfoAsChatMessage(ResourceLocation structure) {
        return new StringTextComponent(TextFormatting.BOLD + "" + TextFormatting.RED + "[" + structure.toString() + "] " + TextFormatting.RESET + "" + TextFormatting.GRAY + "Structure Config Values:\n" + TextFormatting.DARK_AQUA + "Blacklisted Spawnable Biomes: \n" + TextFormatting.GREEN + ModConfig.getSpawnBlacklistedDimensions() + "\n" + TextFormatting.GRAY + "Name: " + TextFormatting.DARK_GRAY + structure.toString() + "\n" + TextFormatting.GRAY + "Min: " + TextFormatting.AQUA + StructureInfo.getMinStrucDist(structure) + TextFormatting.GRAY + " Max: " + TextFormatting.AQUA + StructureInfo.getMaxStrucDist(structure) + "\n" + TextFormatting.GRAY + "Blacklisted Spawnable Biomes: \n" + TextFormatting.GREEN + StructureInfo.getStrucBlacklistBiomes(structure));
    }

    private static int getMinStrucDist(ResourceLocation structure) {
        return MIN_DIST.get(structure);
    }

    private static int getMaxStrucDist(ResourceLocation structure) {
        return MAX_DIST.get(structure);
    }

    private static List<? extends String> getStrucBlacklistBiomes(ResourceLocation structure) {
        return BLACKLIST.get(structure);
    }

    static {
        MIN_DIST.put(((Structure)ModStructures.ILLAGER_ARCHER_TOWER.get()).getRegistryName(), ModConfig.getArcherTowerMinDist());
        MAX_DIST.put(((Structure)ModStructures.ILLAGER_ARCHER_TOWER.get()).getRegistryName(), ModConfig.getArcherTowerMaxDist());
        BLACKLIST.put(((Structure)ModStructures.ILLAGER_ARCHER_TOWER.get()).getRegistryName(), ModConfig.getArcherTowerBlacklistedBiomes());
        MIN_DIST.put(((Structure)ModStructures.ILLAGER_CENTRE.get()).getRegistryName(), ModConfig.getCentreMinDist());
        MAX_DIST.put(((Structure)ModStructures.ILLAGER_CENTRE.get()).getRegistryName(), ModConfig.getCentreMaxDist());
        BLACKLIST.put(((Structure)ModStructures.ILLAGER_CENTRE.get()).getRegistryName(), ModConfig.getCentreBlacklistedBiomes());
        MIN_DIST.put(((Structure)ModStructures.ILLAGER_FORT.get()).getRegistryName(), ModConfig.getFortMinDist());
        MAX_DIST.put(((Structure)ModStructures.ILLAGER_FORT.get()).getRegistryName(), ModConfig.getFortMaxDist());
        BLACKLIST.put(((Structure)ModStructures.ILLAGER_FORT.get()).getRegistryName(), ModConfig.getFortBlacklistedBiomes());
        MIN_DIST.put(((Structure)ModStructures.ILLAGER_MINE.get()).getRegistryName(), ModConfig.getMineMinDist());
        MAX_DIST.put(((Structure)ModStructures.ILLAGER_MINE.get()).getRegistryName(), ModConfig.getMineMaxDist());
        BLACKLIST.put(((Structure)ModStructures.ILLAGER_MINE.get()).getRegistryName(), ModConfig.getMineBlacklistedBiomes());
        MIN_DIST.put(((Structure)ModStructures.ILLAGER_TOWER.get()).getRegistryName(), ModConfig.getTowerMinDist());
        MAX_DIST.put(((Structure)ModStructures.ILLAGER_TOWER.get()).getRegistryName(), ModConfig.getTowerMaxDist());
        BLACKLIST.put(((Structure)ModStructures.ILLAGER_TOWER.get()).getRegistryName(), ModConfig.getTowerBlacklistedBiomes());
    }
}

