/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.litewolf101.illagers_plus.config.ModConfig;
import com.litewolf101.illagers_plus.world.structures.IceCastleStructure;
import com.litewolf101.illagers_plus.world.structures.IllagerArcherTowerStructure;
import com.litewolf101.illagers_plus.world.structures.IllagerCentreStructure;
import com.litewolf101.illagers_plus.world.structures.IllagerFortStructure;
import com.litewolf101.illagers_plus.world.structures.IllagerMineStructure;
import com.litewolf101.illagers_plus.world.structures.IllagerTowerStructure;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"illagers_plus");
    public static final Map<Supplier<?>, ResourceLocation> DEF = new HashMap();
    public static final RegistryObject<Structure<NoFeatureConfig>> ILLAGER_ARCHER_TOWER = ModStructures.registerStructure("illager_archer_tower", () -> new IllagerArcherTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ILLAGER_CENTRE = ModStructures.registerStructure("illager_centre", () -> new IllagerCentreStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ILLAGER_MINE = ModStructures.registerStructure("illager_mine", () -> new IllagerMineStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ILLAGER_TOWER = ModStructures.registerStructure("illager_tower", () -> new IllagerTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ILLAGER_FORT = ModStructures.registerStructure("illager_fort", () -> new IllagerFortStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ICE_CASTLE = ModStructures.registerStructure("ice_castle", () -> new IceCastleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <T extends Structure<?>> RegistryObject<T> registerStructure(String name, Supplier<T> structure) {
        DEF.put(structure, new ResourceLocation("illagers_plus", name));
        return DEFERRED_REGISTRY_STRUCTURE.register(name, structure);
    }

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand((Structure)ILLAGER_ARCHER_TOWER.get(), new StructureSeparationSettings(ModConfig.getArcherTowerMaxDist(), ModConfig.getArcherTowerMinDist(), 1762889308), true);
        ModStructures.setupMapSpacingAndLand((Structure)ILLAGER_CENTRE.get(), new StructureSeparationSettings(ModConfig.getCentreMaxDist(), ModConfig.getCentreMinDist(), 546436166), true);
        ModStructures.setupMapSpacingAndLand((Structure)ILLAGER_MINE.get(), new StructureSeparationSettings(ModConfig.getMineMaxDist(), ModConfig.getMineMinDist(), 944409974), false);
        ModStructures.setupMapSpacingAndLand((Structure)ILLAGER_TOWER.get(), new StructureSeparationSettings(ModConfig.getTowerMaxDist(), ModConfig.getTowerMinDist(), 454365571), false);
        ModStructures.setupMapSpacingAndLand((Structure)ILLAGER_FORT.get(), new StructureSeparationSettings(ModConfig.getFortMaxDist(), ModConfig.getFortMinDist(), 1880888196), true);
        ModStructures.setupMapSpacingAndLand((Structure)ICE_CASTLE.get(), new StructureSeparationSettings(ModConfig.getIceCastleMaxDist(), ModConfig.getIceCastleMinDist(), 599428053), false);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

