/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures;

import com.litewolf101.illagers_plus.config.ModConfig;
import com.litewolf101.illagers_plus.utils.StructureUtils;
import com.litewolf101.illagers_plus.world.structures.pieces.IllagerFortPieces;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class IllagerFortStructure
extends Structure<NoFeatureConfig> {
    public IllagerFortStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    @Nullable
    public BlockPos func_236388_a_(IWorldReader world, StructureManager manager, BlockPos p_236388_3_, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings separationSettings) {
        World world1 = (World)world;
        if (!world1.func_201670_d()) {
            for (String string : ModConfig.getSpawnBlacklistedDimensions()) {
                if (!string.equals(world1.func_234923_W_().func_240901_a_().toString())) continue;
                return StructureUtils.isStructureTooCloseToOthers(this, (ServerWorld)world1, p_236388_3_);
            }
        }
        return super.func_236388_a_(world, manager, p_236388_3_, radius, skipExistingChunks, seed, separationSettings);
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long p_230363_3_, SharedSeedRandom seed, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        int i = x >> 4;
        int j = z >> 4;
        seed.setSeed((long)(i ^ j << 4) ^ p_230363_3_);
        seed.nextInt();
        for (Biome biome1 : provider.func_225530_a_(x * 16 + 9, generator.func_230356_f_(), z * 16 + 9, 16)) {
            if (ModConfig.getFortBlacklistedBiomes().contains(biome1.getRegistryName().toString()) || ModConfig.getFortBlacklistedBiomes().contains(biome1.func_201856_r().func_222352_a())) {
                return false;
            }
            for (BiomeDictionary.Type types : BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()))) {
                if (!ModConfig.getFortBlacklistedBiomes().contains(types.getName())) continue;
                return false;
            }
        }
        return provider.func_205004_a((Structure)this);
    }

    public String func_143025_a() {
        return "illagers_plus:illager_fort";
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public BlockPos structureEntrance;

        public Start(Structure<NoFeatureConfig> p_i225823_1_, int p_i225823_2_, int p_i225823_3_, MutableBoundingBox p_i225823_4_, int p_i225823_5_, long p_i225823_6_) {
            super(p_i225823_1_, p_i225823_2_, p_i225823_3_, p_i225823_4_, p_i225823_5_, p_i225823_6_);
        }

        public BlockPos getStructureEntrance() {
            for (StructurePiece structurePiece : this.field_75075_a) {
                if (!(structurePiece instanceof IllagerFortPieces.Entrance)) continue;
                return new BlockPos(((IllagerFortPieces.Entrance)structurePiece).func_74874_b().func_215126_f());
            }
            return this.func_204294_a().func_177963_a(this.field_214631_d.nextDouble(), 1.0, this.field_214631_d.nextDouble());
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistries, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            int dy = generator.func_222529_a(i, j, Heightmap.Type.WORLD_SURFACE_WG);
            for (int x = chunkX - 8; x <= chunkX + 8; ++x) {
                for (int z = chunkZ - 8; z <= chunkZ + 8; ++z) {
                    if (generator.func_222529_a(x * 16, z * 16, Heightmap.Type.WORLD_SURFACE_WG) >= dy) continue;
                    dy = generator.func_222529_a(x * 16, z * 16, Heightmap.Type.WORLD_SURFACE_WG);
                }
            }
            BlockPos blockpos = new BlockPos(i, dy, j);
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            IllagerFortPieces.generateFort(templateManagerIn, blockpos, Rotation.NONE, this.field_75075_a, this.field_214631_d, this);
            this.func_202500_a();
        }

        public void func_230366_a_(ISeedReader reader, StructureManager manager, ChunkGenerator generator, Random random, MutableBoundingBox bb, ChunkPos chunkpos) {
            super.func_230366_a_(reader, manager, generator, random, bb, chunkpos);
            int i = this.field_75074_b.field_78895_b;
            for (int j = bb.field_78897_a; j <= bb.field_78893_d; ++j) {
                for (int k = bb.field_78896_c; k <= bb.field_78892_f; ++k) {
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (reader.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vector3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vector3i)blockpos)) continue;
                        for (int ix = structurepiece.func_74874_b().field_78894_e; ix <= reader.func_201672_e().func_217301_I(); ++ix) {
                            reader.func_180501_a(new BlockPos(blockpos.func_177958_n(), ix + 1, blockpos.func_177952_p()), Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                }
            }
        }
    }
}

