/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures;

import com.google.common.collect.ImmutableList;
import com.litewolf101.illagers_plus.config.ModConfig;
import com.litewolf101.illagers_plus.utils.StructureUtils;
import com.litewolf101.illagers_plus.world.structures.pieces.IllagerTowerPieces;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class IllagerTowerStructure
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> SPAWNS = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_220350_aJ, 1, 1, 1));

    public IllagerTowerStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    @Nullable
    public BlockPos func_236388_a_(IWorldReader world, StructureManager manager, BlockPos p_236388_3_, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings separationSettings) {
        World world1 = (World)world;
        if (!world1.func_201670_d()) {
            for (String string : ModConfig.getSpawnBlacklistedDimensions()) {
                if (!string.equals(world1.func_234923_W_().func_240901_a_().toString())) continue;
                return StructureUtils.isStructureTooCloseToOthers(this, (ServerWorld)world1, p_236388_3_);
            }
        }
        return super.func_236388_a_(world, manager, p_236388_3_, radius, skipExistingChunks, seed, separationSettings);
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long p_230363_3_, SharedSeedRandom seed, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        int i = x >> 4;
        int j = z >> 4;
        seed.setSeed((long)(i ^ j << 4) ^ p_230363_3_);
        seed.nextInt();
        for (Biome biome1 : provider.func_225530_a_(x * 16 + 9, generator.func_230356_f_(), z * 16 + 9, 16)) {
            if (ModConfig.getTowerBlacklistedBiomes().contains(biome1.getRegistryName().toString()) || ModConfig.getTowerBlacklistedBiomes().contains(biome1.func_201856_r().func_222352_a())) {
                return false;
            }
            for (BiomeDictionary.Type types : BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()))) {
                if (!ModConfig.getTowerBlacklistedBiomes().contains(types.getName())) continue;
                return false;
            }
        }
        return provider.func_205004_a((Structure)this);
    }

    public String func_143025_a() {
        return "illagers_plus:illager_tower";
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return SPAWNS;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return SPAWNS;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> p_i225823_1_, int p_i225823_2_, int p_i225823_3_, MutableBoundingBox p_i225823_4_, int p_i225823_5_, long p_i225823_6_) {
            super(p_i225823_1_, p_i225823_2_, p_i225823_3_, p_i225823_4_, p_i225823_5_, p_i225823_6_);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistries, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            int k1 = generator.func_222529_a(i, j, Heightmap.Type.WORLD_SURFACE_WG);
            int k2 = generator.func_222529_a(i + 16, j, Heightmap.Type.WORLD_SURFACE_WG);
            int k3 = generator.func_222529_a(i + 16, j + 16, Heightmap.Type.WORLD_SURFACE_WG);
            int k4 = generator.func_222529_a(i, j + 16, Heightmap.Type.WORLD_SURFACE_WG);
            int kl1 = Math.min(Math.min(k1, k2), Math.min(k3, k4));
            BlockPos blockpos = new BlockPos(i, kl1, j);
            IllagerTowerPieces.createTower(templateManagerIn, blockpos, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }

        public void func_230366_a_(ISeedReader world, StructureManager p_230366_2_, ChunkGenerator p_230366_3_, Random p_230366_4_, MutableBoundingBox structurebb, ChunkPos p_230366_6_) {
            super.func_230366_a_(world, p_230366_2_, p_230366_3_, p_230366_4_, structurebb, p_230366_6_);
            int i = this.field_75074_b.field_78895_b;
            for (int j = structurebb.field_78897_a; j <= structurebb.field_78893_d; ++j) {
                for (int k = structurebb.field_78896_c; k <= structurebb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (world.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vector3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vector3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (world.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || world.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        world.func_180501_a(blockpos1, Blocks.field_196696_di.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

