/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures.pieces;

import com.litewolf101.illagers_plus.init.EntityInit;
import com.litewolf101.illagers_plus.objects.entity.EntityAbstractIPSpellcaster;
import com.litewolf101.illagers_plus.objects.entity.EntityFrostmancer;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import com.litewolf101.illagers_plus.world.ModProcessorList;
import com.litewolf101.illagers_plus.world.ModStructurePieceTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class IceCastlePieces {
    private static final ResourceLocation castle = new ResourceLocation("illagers_plus", "ice_castle/castle");
    private static final ResourceLocation stairs = new ResourceLocation("illagers_plus", "ice_castle/ice_castle_stairs");
    private static final ResourceLocation cross = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_cross");
    private static final ResourceLocation cross2 = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_cross_2");
    private static final ResourceLocation down = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_down");
    private static final ResourceLocation straight = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_straight");
    private static final ResourceLocation tee = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_tee");
    private static final ResourceLocation turn = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_turn");
    private static final ResourceLocation cap = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_cap");
    private static final ResourceLocation secret_loot = new ResourceLocation("illagers_plus", "ice_castle/ice_corridor_loot");

    public static void startCastle(TemplateManager templateManagerIn, BlockPos blockpos, List<StructurePiece> components, SharedSeedRandom rand) {
        Castle c = new Castle(templateManagerIn, blockpos, Rotation.NONE);
        components.add((StructurePiece)c);
        c.func_74861_a((StructurePiece)c, components, (Random)rand);
    }

    private static void generateAllPieces(IceCastleInfo info, TemplateManager templateManagerIn, BlockPos blockpos, List<StructurePiece> components, SharedSeedRandom rand) {
        for (Map<Integer, Integer> map : info.getARRAY_MAP().keySet()) {
            for (Integer integer : map.keySet()) {
                components.add(info.getARRAY_MAP().get(map));
                info.getARRAY_MAP().get(map).func_74861_a(info.getARRAY_MAP().get(map), components, (Random)rand);
            }
        }
    }

    public static class BaseIceCastlePiece
    extends TemplateStructurePiece {
        public final ResourceLocation template_name;
        public final TemplateManager template_manager;
        public final Rotation field_186169_c;

        public BaseIceCastlePiece(TemplateManager manager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(ModStructurePieceTypes.ICE_CASTLE, 0);
            this.template_name = location;
            this.field_186178_c = pos;
            this.template_manager = manager;
            this.field_186169_c = rotation;
            this.setup(manager);
        }

        public BaseIceCastlePiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.ICE_CASTLE, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.template_manager = templateManager;
            this.field_186169_c = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a).func_215222_a((StructureProcessor)ModProcessorList.packed_blue_snow_ice.func_242919_a().get(0));
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.field_186169_c.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("frostmancer")) {
                if (rand.nextInt(10) < 3) {
                    EntityFrostmancer frostmancer = new EntityFrostmancer((EntityType<? extends EntityAbstractIPSpellcaster>)EntityInit.FROSTMANCER, (World)worldIn.func_201672_e());
                    frostmancer.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                    frostmancer.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    frostmancer.func_110163_bv();
                    worldIn.func_217376_c((Entity)frostmancer);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            if (function.equals("loot")) {
                if (rand.nextBoolean()) {
                    worldIn.func_180501_a(pos, StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150486_ae.func_176223_P()), 3);
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos, (ResourceLocation)IllagerPlusLootTable.ICE_CASTLE_COMMON);
                } else {
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
            if (function.equals("special_loot")) {
                ArrayList d = new ArrayList(HorizontalBlock.field_185512_D.func_177700_c());
                worldIn.func_180501_a(pos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)d.get(rand.nextInt(d.size()))), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos, (ResourceLocation)IllagerPlusLootTable.ICE_CASTLE_RARE);
            }
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
        }
    }

    public static class SecretLootRoom
    extends BaseIceCastlePiece {
        public SecretLootRoom(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, secret_loot, pos, rotation);
        }
    }

    public static class PathCap
    extends BaseIceCastlePiece {
        public PathCap(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, cap, pos, rotation);
        }
    }

    public static class PathTee
    extends BaseIceCastlePiece {
        public PathTee(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, tee, pos, rotation);
        }
    }

    public static class PathTurn
    extends BaseIceCastlePiece {
        public PathTurn(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, turn, pos, rotation);
        }
    }

    public static class NextLevelEntrance
    extends BaseIceCastlePiece {
        public NextLevelEntrance(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, down, pos, rotation);
        }
    }

    public static class Straight
    extends BaseIceCastlePiece {
        public Straight(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, straight, pos, rotation);
        }
    }

    public static class EntranceCross
    extends BaseIceCastlePiece {
        public EntranceCross(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, cross, pos, rotation);
        }
    }

    public static class EmptyCross
    extends BaseIceCastlePiece {
        public EmptyCross(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, cross2, pos, rotation);
        }
    }

    public static class Stairs
    extends BaseIceCastlePiece {
        private boolean generateGrids;

        public Stairs(TemplateManager manager, BlockPos pos, Rotation rotation, boolean shouldGenerateGrid) {
            super(manager, stairs, pos, rotation);
            this.generateGrids = shouldGenerateGrid;
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            if (this.generateGrids) {
                Grid grid = new Grid(rand, 16, 7, 7, 1);
                Grid grid2 = new Grid(rand, 16, grid.stairsX, grid.stairsY, 2);
                Grid grid3 = new Grid(rand, 16, grid2.stairsX, grid2.stairsY, 3);
                IceCastleInfo info = new IceCastleInfo(grid, this.template_manager, this.field_186178_c.func_177982_a(12 + -(grid.getBaseGrid().getSize() * 16) / 2, -10, 12 + -(grid.getBaseGrid().getSize() * 16) / 2), (SharedSeedRandom)rand);
                IceCastlePieces.generateAllPieces(info, this.template_manager, this.field_186178_c.func_177982_a(12 + -(grid.getBaseGrid().getSize() * 16) / 2, -10, 12 + -(grid.getBaseGrid().getSize() * 16) / 2), listIn, (SharedSeedRandom)rand);
                IceCastleInfo info2 = new IceCastleInfo(grid2, this.template_manager, this.field_186178_c.func_177982_a(12 + -(grid2.getBaseGrid().getSize() * 16) / 2, -20, 12 + -(grid2.getBaseGrid().getSize() * 16) / 2), (SharedSeedRandom)rand);
                IceCastlePieces.generateAllPieces(info2, this.template_manager, this.field_186178_c.func_177982_a(12 + -(grid2.getBaseGrid().getSize() * 16) / 2, -20, 12 + -(grid2.getBaseGrid().getSize() * 16) / 2), listIn, (SharedSeedRandom)rand);
                IceCastleInfo info3 = new IceCastleInfo(grid3, this.template_manager, this.field_186178_c.func_177982_a(12 + -(grid3.getBaseGrid().getSize() * 16) / 2, -30, 12 + -(grid3.getBaseGrid().getSize() * 16) / 2), (SharedSeedRandom)rand);
                IceCastlePieces.generateAllPieces(info3, this.template_manager, this.field_186178_c.func_177982_a(12 + -(grid3.getBaseGrid().getSize() * 16) / 2, -30, 12 + -(grid3.getBaseGrid().getSize() * 16) / 2), listIn, (SharedSeedRandom)rand);
            }
        }
    }

    public static class Castle
    extends BaseIceCastlePiece {
        public Castle(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, castle, pos, rotation);
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int d = 0;
            int y = 1;
            while (this.field_186178_c.func_177956_o() - y * 4 >= 55) {
                Stairs s = new Stairs(this.template_manager, this.field_186178_c.func_177982_a(12, -y * 4, 22), Rotation.NONE, false);
                listIn.add((StructurePiece)s);
                s.func_74861_a((StructurePiece)s, listIn, rand);
                ++d;
                ++y;
            }
            Stairs s = new Stairs(this.template_manager, this.field_186178_c.func_177982_a(12, -d * 4, 22), Rotation.NONE, true);
            listIn.add((StructurePiece)s);
            s.func_74861_a((StructurePiece)s, listIn, rand);
        }
    }

    public static class BaseGrid {
        private final int[][] grid;
        private final int size;

        public BaseGrid(int size) {
            this.size = size;
            this.grid = new int[size][size];
        }

        public void set(int x, int y, int numb) {
            if (x >= 0 && x < this.size && y >= 0 && y < this.size) {
                this.grid[x][y] = numb;
            }
        }

        public int get(int x, int y) {
            if (x >= 0 && x < this.size && y >= 0 && y < this.size) {
                return this.grid[x][y];
            }
            throw new IllegalArgumentException("Values [" + x + "," + y + "] Are outside of grid range!");
        }

        public int getSize() {
            return this.size;
        }
    }

    static class Grid {
        private final BaseGrid baseGrid;
        private int entranceX;
        private int entranceY;
        private int stairsX;
        private int stairsY;
        private boolean hasGeneratedStairs;
        private int floor;

        public Grid(Random random, int size, int entranceX, int entranceY, int floor) {
            int x;
            int y;
            this.entranceX = entranceX;
            this.entranceY = entranceY;
            this.baseGrid = new BaseGrid(Math.min(16, size));
            this.floor = floor;
            for (y = 0; y < this.baseGrid.getSize(); ++y) {
                for (x = 0; x < this.baseGrid.getSize(); ++x) {
                    if (y == 0 || y == this.baseGrid.getSize() - 1) {
                        this.baseGrid.set(x, y, 1);
                    }
                    if (x == 0 || x == this.baseGrid.getSize() - 1) {
                        this.baseGrid.set(x, y, 1);
                    }
                    this.baseGrid.set(entranceX, entranceY, 2);
                    this.generateRecursivePathPiece(this.baseGrid, random, entranceX, entranceY - 1, Direction.NORTH);
                    this.generateRecursivePathPiece(this.baseGrid, random, entranceX + 1, entranceY, Direction.EAST);
                    this.generateRecursivePathPiece(this.baseGrid, random, entranceX, entranceY + 1, Direction.SOUTH);
                    this.generateRecursivePathPiece(this.baseGrid, random, entranceX - 1, entranceY, Direction.WEST);
                    if (this.baseGrid.get(x, y) != 3 || !random.nextBoolean()) continue;
                    this.generateCrossPathPiece(this.baseGrid, random, x, y);
                }
            }
            if (!this.hasGeneratedStairs) {
                for (y = 0; y < this.baseGrid.getSize(); ++y) {
                    for (x = 0; x < this.baseGrid.getSize(); ++x) {
                        int g = 0;
                        if (this.baseGrid.get(x, y) == 3) {
                            if (this.baseGrid.get(x - 1, y) == 3) {
                                ++g;
                            }
                            if (this.baseGrid.get(x + 1, y) == 3) {
                                ++g;
                            }
                            if (this.baseGrid.get(x, y - 1) == 3) {
                                ++g;
                            }
                            if (this.baseGrid.get(x, y + 1) == 3) {
                                ++g;
                            }
                        }
                        if (g != true) continue;
                        this.baseGrid.set(x, y, this.floor != 3 ? 5 : 6);
                        this.stairsX = x;
                        this.stairsY = y;
                    }
                }
            }
        }

        public BaseGrid getBaseGrid() {
            return this.baseGrid;
        }

        public boolean hasGeneratedStairs() {
            return this.hasGeneratedStairs;
        }

        public void generateRecursivePathPiece(BaseGrid grid, Random random, int x, int y, Direction direction) {
            if (random.nextInt(10) != 0 && grid.get(x, y) == 0 && !this.isAtEdges(grid, x, y)) {
                grid.set(x, y, 3);
                if (random.nextInt(5) == 0 && !this.hasGeneratedStairs()) {
                    grid.set(x, y, this.floor != 3 ? 5 : 6);
                    this.stairsX = x;
                    this.stairsY = y;
                    this.hasGeneratedStairs = true;
                } else if (this.getValueFromDirection(grid, x, y, direction) == 0) {
                    if (direction == Direction.NORTH) {
                        this.generateRecursivePathPiece(grid, random, x, y - 1, direction);
                    }
                    if (direction == Direction.SOUTH) {
                        this.generateRecursivePathPiece(grid, random, x, y + 1, direction);
                    }
                    if (direction == Direction.EAST) {
                        this.generateRecursivePathPiece(grid, random, x + 1, y, direction);
                    }
                    if (direction == Direction.WEST) {
                        this.generateRecursivePathPiece(grid, random, x - 1, y, direction);
                    }
                }
            }
        }

        public void generateCrossPathPiece(BaseGrid grid, Random random, int x, int y) {
            if (grid.get(x, y) == 3 && !this.isAtEdges(grid, x, y) && x % 2 == 1 && y % 2 == 1) {
                grid.set(x, y, 4);
                this.generateRecursivePathPiece(grid, random, x, y - 1, Direction.NORTH);
                this.generateRecursivePathPiece(grid, random, x, y + 1, Direction.SOUTH);
                this.generateRecursivePathPiece(grid, random, x + 1, y, Direction.EAST);
                this.generateRecursivePathPiece(grid, random, x - 1, y, Direction.WEST);
            }
        }

        public boolean isAtEdges(BaseGrid grid, int x, int y) {
            return x == 0 || y == 0 || x == grid.getSize() - 1 || y == grid.getSize() - 1;
        }

        public int getValueFromDirection(BaseGrid grid, int x, int y, Direction direction) {
            if (direction == Direction.NORTH) {
                return grid.get(x, y - 1);
            }
            if (direction == Direction.EAST) {
                return grid.get(x + 1, y);
            }
            if (direction == Direction.WEST) {
                return grid.get(x - 1, y);
            }
            if (direction == Direction.SOUTH) {
                return grid.get(x, y + 1);
            }
            return 1;
        }
    }

    static class IceCastleInfo {
        private final Map<Map<Integer, Integer>, StructurePiece> ARRAY_MAP = new HashMap<Map<Integer, Integer>, StructurePiece>();
        private final Grid grid;

        public IceCastleInfo(Grid grid, TemplateManager templateManagerIn, BlockPos blockpos, SharedSeedRandom rand) {
            this.grid = grid;
            for (int x = 0; x < this.grid.getBaseGrid().getSize(); ++x) {
                for (int y = 0; y < this.grid.getBaseGrid().getSize(); ++y) {
                    this.translateIntToPiece(this.grid.getBaseGrid(), x, y, templateManagerIn, blockpos, rand);
                }
            }
        }

        private void translateIntToPiece(BaseGrid grid, int x, int y, TemplateManager templateManagerIn, BlockPos blockPos, SharedSeedRandom random) {
            boolean conEast;
            boolean conSouth;
            boolean conWest;
            boolean conNorth;
            HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
            temp.put(x, y);
            if (grid.get(x, y) == 2) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new EntranceCross(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            }
            if (grid.get(x, y) == 3) {
                conNorth = grid.get(x, y - 1) >= 2 && grid.get(x, y - 1) <= 6;
                conWest = grid.get(x - 1, y) >= 2 && grid.get(x - 1, y) <= 6;
                conSouth = grid.get(x, y + 1) >= 2 && grid.get(x, y + 1) <= 6;
                conEast = grid.get(x + 1, y) >= 2 && grid.get(x + 1, y) <= 6;
                this.ARRAY_MAP.put(temp, (StructurePiece)this.generatePathPieceFromConnections(conSouth, conNorth, conEast, conWest, templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16)));
            }
            if (grid.get(x, y) == 4) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new EmptyCross(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            }
            if (grid.get(x, y) == 5) {
                conNorth = grid.get(x, y - 1) >= 2 && grid.get(x, y - 1) <= 6;
                conWest = grid.get(x - 1, y) >= 2 && grid.get(x - 1, y) <= 6;
                conSouth = grid.get(x, y + 1) >= 2 && grid.get(x, y + 1) <= 6;
                conEast = grid.get(x + 1, y) >= 2 && grid.get(x + 1, y) <= 6;
                this.ARRAY_MAP.put(temp, (StructurePiece)this.generateNextLevelEdgeFromConnections(conSouth, conNorth, conEast, conWest, templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16)));
            }
            if (grid.get(x, y) == 6) {
                conNorth = grid.get(x, y - 1) >= 2 && grid.get(x, y - 1) <= 6;
                conWest = grid.get(x - 1, y) >= 2 && grid.get(x - 1, y) <= 6;
                conSouth = grid.get(x, y + 1) >= 2 && grid.get(x, y + 1) <= 6;
                conEast = grid.get(x + 1, y) >= 2 && grid.get(x + 1, y) <= 6;
                this.ARRAY_MAP.put(temp, (StructurePiece)this.generateSecretRoomFromConnections(conSouth, conNorth, conEast, conWest, templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16)));
            }
        }

        public BaseIceCastlePiece generatePathPieceFromConnections(boolean south, boolean north, boolean east, boolean west, TemplateManager manager, BlockPos pos) {
            if (south && north && east && west) {
                return new EmptyCross(manager, pos, Rotation.NONE);
            }
            if (south && north && !east && !west) {
                return new Straight(manager, pos, Rotation.NONE);
            }
            if (!south && !north && east && west) {
                return new Straight(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (!south && north && east && !west) {
                return new PathTurn(manager, pos, Rotation.NONE);
            }
            if (south && !north && east && !west) {
                return new PathTurn(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (south && !north && !east && west) {
                return new PathTurn(manager, pos.func_177982_a(15, 0, 15), Rotation.CLOCKWISE_180);
            }
            if (!south && north && !east && west) {
                return new PathTurn(manager, pos.func_177982_a(0, 0, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            if (south && north && east && !west) {
                return new PathTee(manager, pos.func_177982_a(0, 0, 0), Rotation.NONE);
            }
            if (south && !north && east && west) {
                return new PathTee(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (south && north && !east && west) {
                return new PathTee(manager, pos.func_177982_a(15, 0, 15), Rotation.CLOCKWISE_180);
            }
            if (!south && north && east && west) {
                return new PathTee(manager, pos.func_177982_a(0, 0, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            if (!south && north && !east && !west) {
                return new PathCap(manager, pos.func_177982_a(0, 0, 0), Rotation.NONE);
            }
            if (!south && !north && east && !west) {
                return new PathCap(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (south && !north && !east && !west) {
                return new PathCap(manager, pos.func_177982_a(15, 0, 15), Rotation.CLOCKWISE_180);
            }
            if (!south && !north && !east && west) {
                return new PathCap(manager, pos.func_177982_a(0, 0, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            return new NextLevelEntrance(manager, pos, Rotation.NONE);
        }

        public BaseIceCastlePiece generateNextLevelEdgeFromConnections(boolean south, boolean north, boolean east, boolean west, TemplateManager manager, BlockPos pos) {
            if (north) {
                return new NextLevelEntrance(manager, pos.func_177982_a(0, 0, 0), Rotation.NONE);
            }
            if (east) {
                return new NextLevelEntrance(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (south) {
                return new NextLevelEntrance(manager, pos.func_177982_a(15, 0, 15), Rotation.CLOCKWISE_180);
            }
            if (west) {
                return new NextLevelEntrance(manager, pos.func_177982_a(0, 0, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            return new NextLevelEntrance(manager, pos, Rotation.NONE);
        }

        public BaseIceCastlePiece generateSecretRoomFromConnections(boolean south, boolean north, boolean east, boolean west, TemplateManager manager, BlockPos pos) {
            if (north) {
                return new SecretLootRoom(manager, pos.func_177982_a(0, -6, 0), Rotation.NONE);
            }
            if (east) {
                return new SecretLootRoom(manager, pos.func_177982_a(15, -6, 0), Rotation.CLOCKWISE_90);
            }
            if (south) {
                return new SecretLootRoom(manager, pos.func_177982_a(15, -6, 15), Rotation.CLOCKWISE_180);
            }
            if (west) {
                return new SecretLootRoom(manager, pos.func_177982_a(0, -6, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            return new SecretLootRoom(manager, pos, Rotation.NONE);
        }

        public Map<Map<Integer, Integer>, StructurePiece> getARRAY_MAP() {
            return this.ARRAY_MAP;
        }
    }
}

