/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures.pieces;

import com.litewolf101.illagers_plus.init.EntityInit;
import com.litewolf101.illagers_plus.objects.entity.EntityArcher;
import com.litewolf101.illagers_plus.objects.entity.EntityEnchanter;
import com.litewolf101.illagers_plus.objects.entity.EntityFurantur;
import com.litewolf101.illagers_plus.objects.entity.EntityIllagerGeneral;
import com.litewolf101.illagers_plus.objects.entity.EntityNecromancer;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import com.litewolf101.illagers_plus.world.ModProcessorList;
import com.litewolf101.illagers_plus.world.ModStructurePieceTypes;
import com.litewolf101.illagers_plus.world.structures.IllagerFortStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class IllagerFortPieces {
    private static final ResourceLocation empty = new ResourceLocation("illagers_plus", "illager_fort/plots/empty");
    private static final ResourceLocation wall = new ResourceLocation("illagers_plus", "illager_fort/walls/fort_wall");
    private static final ResourceLocation corner = new ResourceLocation("illagers_plus", "illager_fort/walls/fort_wall_corner");
    private static final ResourceLocation entrance = new ResourceLocation("illagers_plus", "illager_fort/walls/fort_wall_entrance");
    private static final ResourceLocation center1 = new ResourceLocation("illagers_plus", "illager_fort/center/fort_center_1");
    private static final ResourceLocation center2 = new ResourceLocation("illagers_plus", "illager_fort/center/fort_center_2");
    private static final ResourceLocation center3 = new ResourceLocation("illagers_plus", "illager_fort/center/fort_center_3");
    private static final ResourceLocation center4 = new ResourceLocation("illagers_plus", "illager_fort/center/fort_center_4");
    private static final ResourceLocation path_cross = new ResourceLocation("illagers_plus", "illager_fort/path/path_cross");
    private static final ResourceLocation path_turn = new ResourceLocation("illagers_plus", "illager_fort/path/path_turn");
    private static final ResourceLocation path_straight = new ResourceLocation("illagers_plus", "illager_fort/path/path_straight");
    private static final ResourceLocation path_tee = new ResourceLocation("illagers_plus", "illager_fort/path/path_tee");
    private static final ResourceLocation path_dot = new ResourceLocation("illagers_plus", "illager_fort/path/path_dot");
    private static final ResourceLocation path_cap = new ResourceLocation("illagers_plus", "illager_fort/path/path_cap");
    private static final ResourceLocation sf_bow_range = new ResourceLocation("illagers_plus", "illager_fort/major_feature/bow_range");
    private static final ResourceLocation sf_fireworks_display = new ResourceLocation("illagers_plus", "illager_fort/major_feature/fireworks_display");
    private static final ResourceLocation sf_stockpile = new ResourceLocation("illagers_plus", "illager_fort/major_feature/stockpile");
    private static final ResourceLocation sf_undying_totem = new ResourceLocation("illagers_plus", "illager_fort/major_feature/undying_totem");
    private static final ResourceLocation sf_camp = new ResourceLocation("illagers_plus", "illager_fort/minor_feature/camp");
    private static final ResourceLocation sf_farm = new ResourceLocation("illagers_plus", "illager_fort/minor_feature/farm");
    private static final ResourceLocation sf_lumber = new ResourceLocation("illagers_plus", "illager_fort/minor_feature/lumber");
    private static final ResourceLocation sf_well = new ResourceLocation("illagers_plus", "illager_fort/minor_feature/well");
    public static IllagerFortInfo strucinfo;
    public static BlockPos entrancePosition;

    public static void generateFort(TemplateManager templateManagerIn, BlockPos blockpos, Rotation rotation, List<StructurePiece> components, SharedSeedRandom rand, IllagerFortStructure.Start structure) {
        IllagerFortInfo info;
        Grid grid = new Grid((Random)rand, 10 + rand.nextInt(3) * 2);
        strucinfo = info = new IllagerFortInfo(grid, templateManagerIn, blockpos.func_177982_a(-(grid.getBaseGrid().getSize() * 16) / 2, 0, -(grid.getBaseGrid().getSize() * 16) / 2), rand);
        IllagerFortPieces.generateAllPieces(info, templateManagerIn, blockpos.func_177982_a(-(grid.getBaseGrid().getSize() * 16) / 2, 0, -(grid.getBaseGrid().getSize() * 16) / 2), components, rand);
    }

    private static void generateAllPieces(IllagerFortInfo info, TemplateManager templateManagerIn, BlockPos blockpos, List<StructurePiece> components, SharedSeedRandom rand) {
        for (Map<Integer, Integer> map : info.getARRAY_MAP().keySet()) {
            for (Integer integer : map.keySet()) {
                components.add(info.getARRAY_MAP().get(map));
                info.getARRAY_MAP().get(map).func_74861_a(info.getARRAY_MAP().get(map), components, (Random)rand);
            }
        }
    }

    public static BlockPos getEntrancePosition() {
        return entrancePosition;
    }

    public static class BaseFortPiece
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final TemplateManager template_manager;
        private final Rotation rotation;

        public BaseFortPiece(TemplateManager manager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(ModStructurePieceTypes.IF_PIECE, 0);
            this.template_name = location;
            this.field_186178_c = pos;
            this.template_manager = manager;
            this.rotation = rotation;
            this.setup(manager);
        }

        public BaseFortPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IF_PIECE, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.template_manager = templateManager;
            this.rotation = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.setup(templateManager);
        }

        public void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rotation.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("loot")) {
                worldIn.func_180501_a(pos, StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos, (ResourceLocation)IllagerPlusLootTable.IT_RARE);
            }
            if (function.equals("loot_wood")) {
                worldIn.func_180501_a(pos, StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos, (ResourceLocation)IllagerPlusLootTable.IT_DENDROLOGY);
            }
            if (function.equals("loot_barrel")) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        for (int y = 0; y < rand.nextInt(5); ++y) {
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((Property)BarrelBlock.field_220092_a, (Comparable)Direction.func_239631_a_((Random)rand)), 2);
                            if (!rand.nextBoolean()) continue;
                            LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177982_a(x, y, z), (ResourceLocation)IllagerPlusLootTable.IT_RARE);
                        }
                    }
                }
            }
            if (function.equals("crop")) {
                worldIn.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 2);
                worldIn.func_180501_a(pos.func_177984_a(), (BlockState)Blocks.field_150464_aj.func_176223_P().func_206870_a((Property)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(rand.nextInt(7))), 2);
            }
            if (function.equals("general")) {
                EntityIllagerGeneral general = new EntityIllagerGeneral((EntityType<? extends EntityIllagerGeneral>)EntityInit.ILLAGER_GENERAL, (World)worldIn.func_201672_e());
                general.setSupportCooldown(200);
                general.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                general.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                general.func_110163_bv();
                worldIn.func_217376_c((Entity)general);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("archer")) {
                EntityArcher archer = new EntityArcher((EntityType<? extends EntityArcher>)EntityInit.ARCHER, (World)worldIn.func_201672_e());
                archer.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                archer.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                archer.func_110163_bv();
                worldIn.func_217376_c((Entity)archer);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("pillager")) {
                PillagerEntity pillager = new PillagerEntity(EntityType.field_220350_aJ, (World)worldIn.func_201672_e());
                pillager.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                pillager.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                pillager.func_110163_bv();
                worldIn.func_217376_c((Entity)pillager);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("beast")) {
                RavagerEntity ravager = new RavagerEntity(EntityType.field_220352_aU, (World)worldIn.func_201672_e());
                ravager.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                ravager.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                ravager.func_110163_bv();
                worldIn.func_217376_c((Entity)ravager);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("furantur")) {
                EntityFurantur furantur = new EntityFurantur((EntityType<? extends EntityFurantur>)EntityInit.FURANTUR, (World)worldIn.func_201672_e());
                furantur.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                furantur.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                furantur.func_110163_bv();
                worldIn.func_217376_c((Entity)furantur);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("vindicator")) {
                VindicatorEntity vindicator = new VindicatorEntity(EntityType.field_200758_ax, (World)worldIn.func_201672_e());
                vindicator.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                vindicator.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                vindicator.func_110163_bv();
                worldIn.func_217376_c((Entity)vindicator);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("enchanter")) {
                EntityEnchanter enchanter = new EntityEnchanter((EntityType<? extends EntityEnchanter>)EntityInit.ENCHANTER, (World)worldIn.func_201672_e());
                enchanter.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                enchanter.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                enchanter.func_110163_bv();
                worldIn.func_217376_c((Entity)enchanter);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("necromancer")) {
                EntityNecromancer necromancer = new EntityNecromancer((EntityType<? extends EntityNecromancer>)EntityInit.NECROMANCER, (World)worldIn.func_201672_e());
                necromancer.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                necromancer.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                necromancer.func_110163_bv();
                worldIn.func_217376_c((Entity)necromancer);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("evoker")) {
                EvokerEntity evoker = new EvokerEntity(EntityType.field_200806_t, (World)worldIn.func_201672_e());
                evoker.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                evoker.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                evoker.func_110163_bv();
                worldIn.func_217376_c((Entity)evoker);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }

        public BlockPos getPosition() {
            return this.field_186178_c;
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
        }
    }

    public static class BasePathPiece
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final TemplateManager template_manager;
        private final Rotation rotation;

        public BasePathPiece(TemplateManager manager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(ModStructurePieceTypes.IF_PP, 0);
            this.template_name = location;
            this.field_186178_c = pos;
            this.template_manager = manager;
            this.rotation = rotation;
            this.setup(manager);
        }

        public BasePathPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IF_PP, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.template_manager = templateManager;
            this.rotation = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.setup(templateManager);
        }

        public void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a).func_215222_a((StructureProcessor)ModProcessorList.normal_paths.func_242919_a().get(0));
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rotation.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("loot")) {
                worldIn.func_180501_a(pos, StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos, (ResourceLocation)IllagerPlusLootTable.IT_RARE);
            }
            if (function.equals("general")) {
                EntityIllagerGeneral general = new EntityIllagerGeneral((EntityType<? extends EntityIllagerGeneral>)EntityInit.ILLAGER_GENERAL, (World)worldIn.func_201672_e());
                general.setSupportCooldown(200);
                general.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                general.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                general.func_110163_bv();
                worldIn.func_217376_c((Entity)general);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("archer")) {
                EntityArcher archer = new EntityArcher((EntityType<? extends EntityArcher>)EntityInit.ARCHER, (World)worldIn.func_201672_e());
                archer.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                archer.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                archer.func_110163_bv();
                worldIn.func_217376_c((Entity)archer);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("pillager")) {
                PillagerEntity pillager = new PillagerEntity(EntityType.field_220350_aJ, (World)worldIn.func_201672_e());
                pillager.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                pillager.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                pillager.func_110163_bv();
                worldIn.func_217376_c((Entity)pillager);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("beast")) {
                RavagerEntity ravager = new RavagerEntity(EntityType.field_220352_aU, (World)worldIn.func_201672_e());
                ravager.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                ravager.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                ravager.func_110163_bv();
                worldIn.func_217376_c((Entity)ravager);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("furantur")) {
                EntityFurantur furantur = new EntityFurantur((EntityType<? extends EntityFurantur>)EntityInit.FURANTUR, (World)worldIn.func_201672_e());
                furantur.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                furantur.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                furantur.func_110163_bv();
                worldIn.func_217376_c((Entity)furantur);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("vindicator")) {
                VindicatorEntity vindicator = new VindicatorEntity(EntityType.field_200758_ax, (World)worldIn.func_201672_e());
                vindicator.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                vindicator.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                vindicator.func_110163_bv();
                worldIn.func_217376_c((Entity)vindicator);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("enchanter")) {
                EntityEnchanter enchanter = new EntityEnchanter((EntityType<? extends EntityEnchanter>)EntityInit.ENCHANTER, (World)worldIn.func_201672_e());
                enchanter.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                enchanter.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                enchanter.func_110163_bv();
                worldIn.func_217376_c((Entity)enchanter);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
        }
    }

    public static class EmptyLot
    extends BasePathPiece {
        public EmptyLot(TemplateManager manager, BlockPos pos) {
            super(manager, empty, pos, Rotation.NONE);
        }
    }

    public static class Wall
    extends BaseFortPiece {
        public Wall(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, wall, pos, rotation);
        }
    }

    public static class WallCorner
    extends BaseFortPiece {
        public WallCorner(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, corner, pos, rotation);
        }
    }

    public static class Entrance
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final TemplateManager template_manager;
        private final Rotation rotation;

        public Entrance(TemplateManager manager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(ModStructurePieceTypes.IF_ENTRANCE, 0);
            this.template_name = location;
            this.field_186178_c = pos;
            this.template_manager = manager;
            this.rotation = rotation;
            this.setup(manager);
        }

        public Entrance(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IF_ENTRANCE, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.template_manager = templateManager;
            this.rotation = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.setup(templateManager);
        }

        public void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rotation.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("loot")) {
                worldIn.func_180501_a(pos, StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos, (ResourceLocation)IllagerPlusLootTable.IT_RARE);
            }
            if (function.equals("loot_wood")) {
                worldIn.func_180501_a(pos, StructurePiece.func_197528_a((IBlockReader)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos, (ResourceLocation)IllagerPlusLootTable.IT_DENDROLOGY);
            }
            if (function.equals("loot_barrel")) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        for (int y = 0; y < rand.nextInt(5); ++y) {
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((Property)BarrelBlock.field_220092_a, (Comparable)Direction.func_239631_a_((Random)rand)), 2);
                            if (!rand.nextBoolean()) continue;
                            LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177982_a(x, y, z), (ResourceLocation)IllagerPlusLootTable.IT_RARE);
                        }
                    }
                }
            }
            if (function.equals("crop")) {
                worldIn.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 2);
                worldIn.func_180501_a(pos.func_177984_a(), (BlockState)Blocks.field_150464_aj.func_176223_P().func_206870_a((Property)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(rand.nextInt(7))), 2);
            }
            if (function.equals("general")) {
                EntityIllagerGeneral general = new EntityIllagerGeneral((EntityType<? extends EntityIllagerGeneral>)EntityInit.ILLAGER_GENERAL, (World)worldIn.func_201672_e());
                general.setSupportCooldown(200);
                general.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                general.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                general.func_110163_bv();
                worldIn.func_217376_c((Entity)general);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("archer")) {
                EntityArcher archer = new EntityArcher((EntityType<? extends EntityArcher>)EntityInit.ARCHER, (World)worldIn.func_201672_e());
                archer.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                archer.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                archer.func_110163_bv();
                worldIn.func_217376_c((Entity)archer);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("pillager")) {
                PillagerEntity pillager = new PillagerEntity(EntityType.field_220350_aJ, (World)worldIn.func_201672_e());
                pillager.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                pillager.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                pillager.func_110163_bv();
                worldIn.func_217376_c((Entity)pillager);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("beast")) {
                RavagerEntity ravager = new RavagerEntity(EntityType.field_220352_aU, (World)worldIn.func_201672_e());
                ravager.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                ravager.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                ravager.func_110163_bv();
                worldIn.func_217376_c((Entity)ravager);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("furantur")) {
                EntityFurantur furantur = new EntityFurantur((EntityType<? extends EntityFurantur>)EntityInit.FURANTUR, (World)worldIn.func_201672_e());
                furantur.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                furantur.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                furantur.func_110163_bv();
                worldIn.func_217376_c((Entity)furantur);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("vindicator")) {
                VindicatorEntity vindicator = new VindicatorEntity(EntityType.field_200758_ax, (World)worldIn.func_201672_e());
                vindicator.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                vindicator.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                vindicator.func_110163_bv();
                worldIn.func_217376_c((Entity)vindicator);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("enchanter")) {
                EntityEnchanter enchanter = new EntityEnchanter((EntityType<? extends EntityEnchanter>)EntityInit.ENCHANTER, (World)worldIn.func_201672_e());
                enchanter.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                enchanter.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                enchanter.func_110163_bv();
                worldIn.func_217376_c((Entity)enchanter);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("necromancer")) {
                EntityNecromancer necromancer = new EntityNecromancer((EntityType<? extends EntityNecromancer>)EntityInit.NECROMANCER, (World)worldIn.func_201672_e());
                necromancer.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                necromancer.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                necromancer.func_110163_bv();
                worldIn.func_217376_c((Entity)necromancer);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (function.equals("evoker")) {
                EvokerEntity evoker = new EvokerEntity(EntityType.field_200806_t, (World)worldIn.func_201672_e());
                evoker.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                evoker.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                evoker.func_110163_bv();
                worldIn.func_217376_c((Entity)evoker);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }

        public BlockPos getPosition() {
            return this.field_186178_c;
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
        }
    }

    public static class FortCenterBottomRight
    extends BaseFortPiece {
        public FortCenterBottomRight(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, center1, pos, rotation);
        }
    }

    public static class FortCenterTopRight
    extends BaseFortPiece {
        public FortCenterTopRight(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, center2, pos, rotation);
        }
    }

    public static class FortCenterTopLeft
    extends BaseFortPiece {
        public FortCenterTopLeft(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, center3, pos, rotation);
        }
    }

    public static class FortCenterBottomLeft
    extends BaseFortPiece {
        public FortCenterBottomLeft(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, center4, pos, rotation);
        }
    }

    public static class PathCross
    extends BasePathPiece {
        public PathCross(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, path_cross, pos, rotation);
        }
    }

    public static class PathDot
    extends BasePathPiece {
        public PathDot(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, path_dot, pos, rotation);
        }
    }

    public static class PathStraight
    extends BasePathPiece {
        public PathStraight(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, path_straight, pos, rotation);
        }
    }

    public static class PathTee
    extends BasePathPiece {
        public PathTee(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, path_tee, pos, rotation);
        }
    }

    public static class PathTurn
    extends BasePathPiece {
        public PathTurn(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, path_turn, pos, rotation);
        }
    }

    public static class PathCap
    extends BasePathPiece {
        public PathCap(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, path_cap, pos, rotation);
        }
    }

    public static class SpecialFeatureBowRange
    extends BaseFortPiece {
        public SpecialFeatureBowRange(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_bow_range, pos, rotation);
        }
    }

    public static class SpecialFeatureFireworksDisplay
    extends BaseFortPiece {
        public SpecialFeatureFireworksDisplay(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_fireworks_display, pos, rotation);
        }
    }

    public static class SpecialFeatureStockpile
    extends BaseFortPiece {
        public SpecialFeatureStockpile(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_stockpile, pos, rotation);
        }
    }

    public static class SpecialFeatureUndyingTotem
    extends BaseFortPiece {
        public SpecialFeatureUndyingTotem(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_undying_totem, pos, rotation);
        }
    }

    public static class BoringFeatureCamp
    extends BaseFortPiece {
        public BoringFeatureCamp(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_camp, pos, rotation);
        }
    }

    public static class BoringFeatureFarm
    extends BaseFortPiece {
        public BoringFeatureFarm(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_farm, pos, rotation);
        }
    }

    public static class BoringFeatureLumber
    extends BaseFortPiece {
        public BoringFeatureLumber(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_lumber, pos, rotation);
        }
    }

    public static class BoringFeatureWell
    extends BaseFortPiece {
        public BoringFeatureWell(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(manager, sf_well, pos, rotation);
        }
    }

    public static class BaseGrid {
        private final int[][] grid;
        private final int size;

        public BaseGrid(int size) {
            this.size = size;
            this.grid = new int[size][size];
        }

        public void set(int x, int y, int numb) {
            if (x >= 0 && x < this.size && y >= 0 && y < this.size) {
                this.grid[x][y] = numb;
            }
        }

        public int get(int x, int y) {
            if (x >= 0 && x < this.size && y >= 0 && y < this.size) {
                return this.grid[x][y];
            }
            throw new IllegalArgumentException("Values [" + x + "," + y + "] Are outside of grid range!");
        }

        public int getSize() {
            return this.size;
        }
    }

    static class Grid {
        private final BaseGrid baseGrid;
        private boolean hasPlacedEntrance;
        private int entranceX;
        private int entranceY;

        public Grid(Random random, int size) {
            int j;
            int i;
            int x;
            int y;
            this.baseGrid = new BaseGrid(Math.min(16, size));
            for (y = 0; y < this.baseGrid.getSize(); ++y) {
                for (x = 0; x < this.baseGrid.getSize(); ++x) {
                    if (y == 0 || y == this.baseGrid.getSize() - 1) {
                        this.baseGrid.set(x, y, 1);
                    }
                    if (x == 0 || x == this.baseGrid.getSize() - 1) {
                        this.baseGrid.set(x, y, 1);
                    }
                    if (!(x != 0 && x != this.baseGrid.getSize() - 1 || y != 0 && y != this.baseGrid.getSize() - 1)) {
                        this.baseGrid.set(x, y, 2);
                    }
                    if (this.baseGrid.get(x, y) == 1 && random.nextInt(30) == 1 && !this.hasPlacedEntrance) {
                        this.baseGrid.set(x, y, 3);
                        this.entranceX = x;
                        this.entranceY = y;
                        this.hasPlacedEntrance = true;
                    }
                    if (x != this.baseGrid.getSize() / 2 - 1 && x != this.baseGrid.getSize() / 2 || y != this.baseGrid.getSize() / 2 - 1 && y != this.baseGrid.getSize() / 2) continue;
                    this.baseGrid.set(x, y, 4);
                }
            }
            if (!this.hasPlacedEntrance) {
                this.baseGrid.set(this.baseGrid.getSize() / 2, this.baseGrid.getSize() - 1, 3);
                this.entranceX = this.baseGrid.getSize() / 2;
                this.entranceY = this.baseGrid.getSize() - 1;
                this.hasPlacedEntrance = true;
            }
            this.generatePath(this.baseGrid, random);
            this.generatePath(this.baseGrid, this.baseGrid.getSize() / 2 - 1, this.baseGrid.getSize() / 2 - 2, Rotation.NONE, random);
            this.generatePath(this.baseGrid, this.baseGrid.getSize() / 2 + 1, this.baseGrid.getSize() / 2 - 1, Rotation.CLOCKWISE_90, random);
            this.generatePath(this.baseGrid, this.baseGrid.getSize() / 2 - 1, this.baseGrid.getSize() / 2 + 1, Rotation.CLOCKWISE_180, random);
            this.generatePath(this.baseGrid, this.baseGrid.getSize() / 2 - 2, this.baseGrid.getSize() / 2 - 1, Rotation.COUNTERCLOCKWISE_90, random);
            if (this.entranceX == 0) {
                for (i = 0; i <= this.baseGrid.getSize() / 2; ++i) {
                    if (this.baseGrid.get(i, this.entranceY) != 0) continue;
                    this.baseGrid.set(i, this.entranceY, 5);
                    if (i != this.baseGrid.getSize() / 2) continue;
                    if (this.entranceY > this.baseGrid.getSize() / 2) {
                        for (j = this.entranceY; j >= this.baseGrid.getSize() / 2; --j) {
                            if (this.baseGrid.get(i, j) != 0) continue;
                            this.baseGrid.set(i, j, 5);
                        }
                        continue;
                    }
                    for (j = this.entranceY; j <= this.baseGrid.getSize() / 2; ++j) {
                        if (this.baseGrid.get(i, j) != 0) continue;
                        this.baseGrid.set(i, j, 5);
                    }
                }
            } else if (this.entranceX == this.baseGrid.getSize() - 1) {
                for (i = this.baseGrid.getSize() - 1; i >= this.baseGrid.getSize() / 2; --i) {
                    if (this.baseGrid.get(i, this.entranceY) == 0) {
                        this.baseGrid.set(i, this.entranceY, 5);
                    }
                    if (i != this.baseGrid.getSize() / 2) continue;
                    if (this.entranceY > this.baseGrid.getSize() / 2) {
                        for (j = this.entranceY; j >= this.baseGrid.getSize() / 2; --j) {
                            if (this.baseGrid.get(i, j) != 0) continue;
                            this.baseGrid.set(i, j, 5);
                        }
                        continue;
                    }
                    for (j = this.entranceY; j <= this.baseGrid.getSize() / 2; ++j) {
                        if (this.baseGrid.get(i, j) != 0) continue;
                        this.baseGrid.set(i, j, 5);
                    }
                }
            } else if (this.entranceY == 0) {
                for (i = 0; i <= this.baseGrid.getSize() / 2; ++i) {
                    if (this.baseGrid.get(this.entranceX, i) == 0) {
                        this.baseGrid.set(this.entranceX, i, 5);
                    }
                    if (i != this.baseGrid.getSize() / 2) continue;
                    if (this.entranceX > this.baseGrid.getSize() / 2) {
                        for (j = this.entranceX; j >= this.baseGrid.getSize() / 2; --j) {
                            if (this.baseGrid.get(j, i) != 0) continue;
                            this.baseGrid.set(j, i, 5);
                        }
                        continue;
                    }
                    for (j = this.entranceX; j <= this.baseGrid.getSize() / 2; ++j) {
                        if (this.baseGrid.get(j, i) != 0) continue;
                        this.baseGrid.set(j, i, 5);
                    }
                }
            } else if (this.entranceY == this.baseGrid.getSize() - 1) {
                for (i = this.baseGrid.getSize() - 1; i >= this.baseGrid.getSize() / 2; --i) {
                    if (this.baseGrid.get(this.entranceX, i) == 0) {
                        this.baseGrid.set(this.entranceX, i, 5);
                    }
                    if (i != this.baseGrid.getSize() / 2) continue;
                    if (this.entranceX > this.baseGrid.getSize() / 2) {
                        for (j = this.entranceX; j >= this.baseGrid.getSize() / 2; --j) {
                            if (this.baseGrid.get(j, i) != 0) continue;
                            this.baseGrid.set(j, i, 5);
                        }
                        continue;
                    }
                    for (j = this.entranceX; j <= this.baseGrid.getSize() / 2; ++j) {
                        if (this.baseGrid.get(j, i) != 0) continue;
                        this.baseGrid.set(j, i, 5);
                    }
                }
            }
            for (y = 0; y < this.baseGrid.getSize(); ++y) {
                for (x = 0; x < this.baseGrid.getSize(); ++x) {
                    if (this.baseGrid.get(x, y) != 0 || this.baseGrid.get(x - 1, y) != 5 && this.baseGrid.get(x + 1, y) != 5 && this.baseGrid.get(x, y - 1) != 5 && this.baseGrid.get(x, y + 1) != 5 || random.nextInt(10) >= 4) continue;
                    this.baseGrid.set(x, y, 6);
                }
            }
            for (y = 0; y < this.baseGrid.getSize(); ++y) {
                for (x = 0; x < this.baseGrid.getSize(); ++x) {
                    if (this.baseGrid.get(x, y) != 0 || random.nextInt(10) != 1) continue;
                    this.baseGrid.set(x, y, 7);
                }
            }
            for (y = 0; y < this.baseGrid.getSize(); ++y) {
                for (x = 0; x < this.baseGrid.getSize(); ++x) {
                    if (!(y != 0 && y != this.baseGrid.getSize() - 1 || this.baseGrid.get(x, y) == 1 && this.baseGrid.get(x, y) == 2 && this.baseGrid.get(x, y) == 3)) {
                        this.baseGrid.set(x, y, 1);
                    }
                    if (!(x != 0 && x != this.baseGrid.getSize() - 1 || this.baseGrid.get(x, y) == 1 && this.baseGrid.get(x, y) == 2 && this.baseGrid.get(x, y) == 3)) {
                        this.baseGrid.set(x, y, 1);
                    }
                    if (!(x != 0 && x != this.baseGrid.getSize() - 1 || y != 0 && y != this.baseGrid.getSize() - 1 || this.baseGrid.get(x, y) == 1 && this.baseGrid.get(x, y) == 2 && this.baseGrid.get(x, y) == 3)) {
                        this.baseGrid.set(x, y, 2);
                    }
                    if (x != this.entranceX || y != this.entranceY || this.baseGrid.get(x, y) == 3) continue;
                    this.baseGrid.set(x, y, 3);
                }
            }
        }

        public BaseGrid getBaseGrid() {
            return this.baseGrid;
        }

        public void generatePath(BaseGrid grid, Random random) {
            if (this.entranceX == 0 && grid.get(this.entranceX + 1, this.entranceY) == 0) {
                this.generateRecursivePathPart(grid, this.entranceX + 1, this.entranceY, Rotation.CLOCKWISE_90, random);
            } else if (this.entranceX == grid.getSize() - 1 && grid.get(this.entranceX - 1, this.entranceY) == 0) {
                this.generateRecursivePathPart(grid, this.entranceX - 1, this.entranceY, Rotation.COUNTERCLOCKWISE_90, random);
            } else if (this.entranceY == 0 && grid.get(this.entranceX, this.entranceY + 1) == 0) {
                this.generateRecursivePathPart(grid, this.entranceX, this.entranceY + 1, Rotation.CLOCKWISE_180, random);
            } else if (this.entranceY == grid.getSize() - 1 && grid.get(this.entranceX, this.entranceY - 1) == 0) {
                this.generateRecursivePathPart(grid, this.entranceX, this.entranceY - 1, Rotation.NONE, random);
            }
        }

        public void generatePath(BaseGrid grid, int x, int y, Random random) {
            int fy;
            int fx = Math.max(1, Math.min(x, grid.getSize() - 1));
            if (grid.get(fx, fy = Math.max(1, Math.min(y, grid.getSize() - 1))) == 0) {
                this.generateRecursivePathPart(grid, fx, fy, Rotation.func_222466_a((Random)random), random);
            }
        }

        public void generatePath(BaseGrid grid, int x, int y, Rotation rotation, Random random) {
            int fy;
            int fx = Math.max(1, Math.min(x, grid.getSize() - 1));
            if (grid.get(fx, fy = Math.max(1, Math.min(y, grid.getSize() - 1))) == 0) {
                this.generateRecursivePathPart(grid, fx, fy, rotation, random);
            }
        }

        public void generateRecursivePathPart(BaseGrid grid, int x, int y, Rotation rotation, Random random) {
            int fx = Math.max(1, Math.min(x, grid.getSize() - 1));
            int fy = Math.max(1, Math.min(y, grid.getSize() - 1));
            grid.set(fx, fy, 5);
            int r = random.nextInt(30);
            if (r < 10) {
                this.generatePath(grid, fx + random.nextInt(2) - 1, fy + random.nextInt(2) - 1, random);
            }
            if (rotation == Rotation.NONE) {
                if (r < 3) {
                    if (grid.get(fx - 1, fy) == 0) {
                        this.generateRecursivePathPart(grid, fx - 1, fy, Rotation.CLOCKWISE_90, random);
                    }
                } else if (r > 27) {
                    if (grid.get(fx + 1, fy) == 0) {
                        this.generateRecursivePathPart(grid, fx + 1, fy, Rotation.COUNTERCLOCKWISE_90, random);
                    }
                } else if (grid.get(fx, fy - 1) == 0) {
                    this.generateRecursivePathPart(grid, fx - 1, fy, rotation, random);
                }
            }
            if (rotation == Rotation.CLOCKWISE_90) {
                if (r < 3) {
                    if (grid.get(fx, fy - 1) == 0) {
                        this.generateRecursivePathPart(grid, fx, fy - 1, Rotation.NONE, random);
                    }
                } else if (r > 27) {
                    if (grid.get(fx, fy + 1) == 0) {
                        this.generateRecursivePathPart(grid, fx, fy + 1, Rotation.CLOCKWISE_180, random);
                    }
                } else if (grid.get(fx + 1, fy) == 0) {
                    this.generateRecursivePathPart(grid, fx + 1, fy, rotation, random);
                }
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                if (r < 3) {
                    if (grid.get(fx + 1, fy) == 0) {
                        this.generateRecursivePathPart(grid, fx + 1, fy, Rotation.COUNTERCLOCKWISE_90, random);
                    }
                } else if (r > 27) {
                    if (grid.get(fx - 1, fy) == 0) {
                        this.generateRecursivePathPart(grid, fx - 1, fy, Rotation.CLOCKWISE_90, random);
                    }
                } else if (grid.get(fx, fy + 1) == 0) {
                    this.generateRecursivePathPart(grid, fx, fy + 1, rotation, random);
                }
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                if (r < 3) {
                    if (grid.get(fx, fy + 1) == 0) {
                        this.generateRecursivePathPart(grid, fx, fy + 1, Rotation.NONE, random);
                    }
                } else if (r > 27) {
                    if (grid.get(fx, fy - 1) == 0) {
                        this.generateRecursivePathPart(grid, fx, fy - 1, Rotation.CLOCKWISE_180, random);
                    }
                } else if (grid.get(fx - 1, fy) == 0) {
                    this.generateRecursivePathPart(grid, fx - 1, fy, rotation, random);
                }
            }
        }
    }

    static class IllagerFortInfo {
        private final Map<Map<Integer, Integer>, StructurePiece> ARRAY_MAP = new HashMap<Map<Integer, Integer>, StructurePiece>();
        private final Grid grid;

        public IllagerFortInfo(Grid grid, TemplateManager templateManagerIn, BlockPos blockpos, SharedSeedRandom rand) {
            this.grid = grid;
            for (int x = 0; x < this.grid.getBaseGrid().getSize(); ++x) {
                for (int y = 0; y < this.grid.getBaseGrid().getSize(); ++y) {
                    this.translateIntToPiece(this.grid.getBaseGrid(), x, y, templateManagerIn, blockpos, rand);
                }
            }
        }

        private void translateIntToPiece(BaseGrid grid, int x, int y, TemplateManager templateManagerIn, BlockPos blockPos, SharedSeedRandom random) {
            boolean conEast;
            boolean conSouth;
            boolean conWest;
            boolean conNorth;
            HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
            temp.put(x, y);
            if (grid.get(x, y) == 0) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new EmptyLot(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16)));
            }
            if (x == 0 && grid.get(x, y) == 1) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new Wall(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16 + 15), Rotation.COUNTERCLOCKWISE_90));
            } else if (x == grid.getSize() - 1 && grid.get(x, y) == 1) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new Wall(templateManagerIn, blockPos.func_177982_a(x * 16 + 15, 0, y * 16), Rotation.CLOCKWISE_90));
            } else if (y == 0 && grid.get(x, y) == 1) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new Wall(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            } else if (y == grid.getSize() - 1 && grid.get(x, y) == 1) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new Wall(templateManagerIn, blockPos.func_177982_a(x * 16 + 15, 0, y * 16 + 15), Rotation.CLOCKWISE_180));
            }
            if (x == 0 && y == 0 && grid.get(x, y) == 2) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new WallCorner(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            } else if (x == grid.getSize() - 1 && y == 0 && grid.get(x, y) == 2) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new WallCorner(templateManagerIn, blockPos.func_177982_a(x * 16 + 15, 0, y * 16), Rotation.CLOCKWISE_90));
            } else if (x == 0 && y == grid.getSize() - 1 && grid.get(x, y) == 2) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new WallCorner(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16 + 15), Rotation.COUNTERCLOCKWISE_90));
            } else if (x == grid.getSize() - 1 && y == grid.getSize() - 1 && grid.get(x, y) == 2) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new WallCorner(templateManagerIn, blockPos.func_177982_a(x * 16 + 15, 0, y * 16 + 15), Rotation.CLOCKWISE_180));
            }
            if (grid.get(x, y) == 3) {
                entrancePosition = blockPos.func_177982_a(x * 16, 0, y * 16);
                if (x == 0) {
                    this.ARRAY_MAP.put(temp, (StructurePiece)new Entrance(templateManagerIn, entrance, blockPos.func_177982_a(x * 16, 0, y * 16 + 15), Rotation.COUNTERCLOCKWISE_90));
                } else if (x == grid.getSize() - 1) {
                    this.ARRAY_MAP.put(temp, (StructurePiece)new Entrance(templateManagerIn, entrance, blockPos.func_177982_a(x * 16 + 15, 0, y * 16), Rotation.CLOCKWISE_90));
                } else if (y == 0) {
                    this.ARRAY_MAP.put(temp, (StructurePiece)new Entrance(templateManagerIn, entrance, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
                } else if (y == grid.getSize() - 1) {
                    this.ARRAY_MAP.put(temp, (StructurePiece)new Entrance(templateManagerIn, entrance, blockPos.func_177982_a(x * 16 + 15, 0, y * 16 + 15), Rotation.CLOCKWISE_180));
                }
            }
            if (grid.get(x, y) == 4 && grid.get(x - 1, y) == 4 && grid.get(x, y - 1) == 4) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new FortCenterTopLeft(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            }
            if (grid.get(x, y) == 4 && grid.get(x - 1, y) == 4 && grid.get(x, y + 1) == 4) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new FortCenterBottomLeft(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            }
            if (grid.get(x, y) == 4 && grid.get(x + 1, y) == 4 && grid.get(x, y + 1) == 4) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new FortCenterBottomRight(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            }
            if (grid.get(x, y) == 4 && grid.get(x + 1, y) == 4 && grid.get(x, y - 1) == 4) {
                this.ARRAY_MAP.put(temp, (StructurePiece)new FortCenterTopRight(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), Rotation.NONE));
            }
            if (grid.get(x, y) == 5) {
                conNorth = grid.get(x, y - 1) == 3 || grid.get(x, y - 1) == 5;
                conWest = grid.get(x - 1, y) == 3 || grid.get(x - 1, y) == 5;
                conSouth = grid.get(x, y + 1) == 3 || grid.get(x, y + 1) == 5;
                conEast = grid.get(x + 1, y) == 3 || grid.get(x + 1, y) == 5;
                this.ARRAY_MAP.put(temp, (StructurePiece)this.generatePathPieceFromConnections(conSouth, conNorth, conEast, conWest, templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16)));
            }
            if (grid.get(x, y) == 6) {
                conNorth = grid.get(x, y - 1) == 5;
                conWest = grid.get(x - 1, y) == 5;
                conSouth = grid.get(x, y + 1) == 5;
                conEast = grid.get(x + 1, y) == 5;
                this.ARRAY_MAP.put(temp, (StructurePiece)this.generateSpecialFeaturePiece(conSouth, conNorth, conEast, conWest, templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), (Random)random));
            }
            if (grid.get(x, y) == 7) {
                this.ARRAY_MAP.put(temp, (StructurePiece)this.generateBoringFeaturePiece(templateManagerIn, blockPos.func_177982_a(x * 16, 0, y * 16), (Random)random));
            }
        }

        public BaseFortPiece generateBoringFeaturePiece(TemplateManager manager, BlockPos pos, Random random) {
            ArrayList<Direction> allowedDirections = new ArrayList<Direction>();
            ArrayList<BaseFortPiece> pieces = new ArrayList<BaseFortPiece>();
            allowedDirections.add(Direction.NORTH);
            allowedDirections.add(Direction.SOUTH);
            allowedDirections.add(Direction.WEST);
            allowedDirections.add(Direction.EAST);
            Direction d = (Direction)allowedDirections.get(random.nextInt(allowedDirections.size()));
            BlockPos newPos = pos;
            Rotation rotation = Rotation.NONE;
            if (d == Direction.SOUTH) {
                newPos = pos;
                rotation = Rotation.NONE;
            } else if (d == Direction.NORTH) {
                newPos = pos.func_177982_a(15, 0, 15);
                rotation = Rotation.CLOCKWISE_180;
            } else if (d == Direction.WEST) {
                newPos = pos.func_177982_a(15, 0, 0);
                rotation = Rotation.CLOCKWISE_90;
            } else if (d == Direction.EAST) {
                newPos = pos.func_177982_a(0, 0, 15);
                rotation = Rotation.COUNTERCLOCKWISE_90;
            }
            pieces.add(new BoringFeatureCamp(manager, newPos, rotation));
            pieces.add(new BoringFeatureFarm(manager, newPos, rotation));
            pieces.add(new BoringFeatureLumber(manager, newPos, rotation));
            pieces.add(new BoringFeatureWell(manager, newPos, rotation));
            return (BaseFortPiece)((Object)pieces.get(random.nextInt(pieces.size())));
        }

        public BaseFortPiece generateSpecialFeaturePiece(boolean south, boolean north, boolean east, boolean west, TemplateManager manager, BlockPos pos, Random random) {
            ArrayList<Direction> allowedDirections = new ArrayList<Direction>();
            ArrayList<BaseFortPiece> pieces = new ArrayList<BaseFortPiece>();
            if (north) {
                allowedDirections.add(Direction.NORTH);
            }
            if (south) {
                allowedDirections.add(Direction.SOUTH);
            }
            if (west) {
                allowedDirections.add(Direction.WEST);
            }
            if (east) {
                allowedDirections.add(Direction.EAST);
            }
            Direction d = (Direction)allowedDirections.get(random.nextInt(allowedDirections.size()));
            BlockPos newPos = pos;
            Rotation rotation = Rotation.NONE;
            if (d == Direction.SOUTH) {
                newPos = pos;
                rotation = Rotation.NONE;
            } else if (d == Direction.NORTH) {
                newPos = pos.func_177982_a(15, 0, 15);
                rotation = Rotation.CLOCKWISE_180;
            } else if (d == Direction.WEST) {
                newPos = pos.func_177982_a(15, 0, 0);
                rotation = Rotation.CLOCKWISE_90;
            } else if (d == Direction.EAST) {
                newPos = pos.func_177982_a(0, 0, 15);
                rotation = Rotation.COUNTERCLOCKWISE_90;
            }
            pieces.add(new SpecialFeatureBowRange(manager, newPos, rotation));
            pieces.add(new SpecialFeatureFireworksDisplay(manager, newPos, rotation));
            pieces.add(new SpecialFeatureStockpile(manager, newPos, rotation));
            pieces.add(new SpecialFeatureUndyingTotem(manager, newPos, rotation));
            return (BaseFortPiece)((Object)pieces.get(random.nextInt(pieces.size())));
        }

        public BasePathPiece generatePathPieceFromConnections(boolean south, boolean north, boolean east, boolean west, TemplateManager manager, BlockPos pos) {
            if (!(south || north || east || west)) {
                return new PathDot(manager, pos, Rotation.NONE);
            }
            if (south && north && east && west) {
                return new PathCross(manager, pos, Rotation.NONE);
            }
            if (south && north && !east && !west) {
                return new PathStraight(manager, pos, Rotation.NONE);
            }
            if (!south && !north && east && west) {
                return new PathStraight(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (!south && north && east && !west) {
                return new PathTurn(manager, pos, Rotation.NONE);
            }
            if (south && !north && east && !west) {
                return new PathTurn(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (south && !north && !east && west) {
                return new PathTurn(manager, pos.func_177982_a(15, 0, 15), Rotation.CLOCKWISE_180);
            }
            if (!south && north && !east && west) {
                return new PathTurn(manager, pos.func_177982_a(0, 0, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            if (south && north && east && !west) {
                return new PathTee(manager, pos.func_177982_a(0, 0, 0), Rotation.NONE);
            }
            if (south && !north && east && west) {
                return new PathTee(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (south && north && !east && west) {
                return new PathTee(manager, pos.func_177982_a(15, 0, 15), Rotation.CLOCKWISE_180);
            }
            if (!south && north && east && west) {
                return new PathTee(manager, pos.func_177982_a(0, 0, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            if (!south && north && !east && !west) {
                return new PathCap(manager, pos.func_177982_a(0, 0, 0), Rotation.NONE);
            }
            if (!south && !north && east && !west) {
                return new PathCap(manager, pos.func_177982_a(15, 0, 0), Rotation.CLOCKWISE_90);
            }
            if (south && !north && !east && !west) {
                return new PathCap(manager, pos.func_177982_a(15, 0, 15), Rotation.CLOCKWISE_180);
            }
            if (!south && !north && !east && west) {
                return new PathCap(manager, pos.func_177982_a(0, 0, 15), Rotation.COUNTERCLOCKWISE_90);
            }
            return new PathDot(manager, pos, Rotation.NONE);
        }

        public Map<Map<Integer, Integer>, StructurePiece> getARRAY_MAP() {
            return this.ARRAY_MAP;
        }
    }
}

