/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures.pieces;

import com.litewolf101.illagers_plus.init.EntityInit;
import com.litewolf101.illagers_plus.objects.entity.EntityFurantur;
import com.litewolf101.illagers_plus.objects.entity.EntityMiner;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import com.litewolf101.illagers_plus.world.ModStructurePieceTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class IllagerMinePieces {
    private static final ResourceLocation mineTop = new ResourceLocation("illagers_plus", "illager_mine/mine_top");
    private static final ResourceLocation mineMiddle = new ResourceLocation("illagers_plus", "illager_mine/mine_middle");
    private static final ResourceLocation mineSplit = new ResourceLocation("illagers_plus", "illager_mine/mine_split");
    private static final ResourceLocation mineBottom = new ResourceLocation("illagers_plus", "illager_mine/mine_bottom");
    private static final ResourceLocation corridorNormal = new ResourceLocation("illagers_plus", "illager_mine/mine_piece_corridor");
    private static final ResourceLocation corridorDetect = new ResourceLocation("illagers_plus", "illager_mine/mine_piece_corridor_detect");
    private static final ResourceLocation corridorGravel = new ResourceLocation("illagers_plus", "illager_mine/mine_piece_corridor_gravel");
    private static final ResourceLocation corridorWater = new ResourceLocation("illagers_plus", "illager_mine/mine_piece_corridor_water");
    private static final ResourceLocation corridorEnd = new ResourceLocation("illagers_plus", "illager_mine/mine_piece_corridor_end");
    private static final ResourceLocation capLoot = new ResourceLocation("illagers_plus", "illager_mine/mine_loot_cap");
    private static final ResourceLocation capCart = new ResourceLocation("illagers_plus", "illager_mine/mine_cap_carts");

    public static TemplateStructurePiece createRandomCorridorPiece(Random rand, BlockPos pos, TemplateManager manager, int offset, Rotation rotation) {
        TemplateStructurePiece piece = null;
        int rando = rand.nextInt(100);
        if (rando < 10) {
            piece = new CorridorNormal(manager, corridorNormal, pos, offset, rotation);
        } else if (rando < 90) {
            int subRand = rand.nextInt(4);
            if (subRand == 0) {
                piece = new CorridorDetect(manager, corridorDetect, pos, offset, rotation);
            }
            if (subRand == 1) {
                piece = new CorridorGravel(manager, corridorGravel, pos, offset, rotation);
            }
            if (subRand == 2) {
                piece = new CorridorWater(manager, corridorWater, pos, offset, rotation);
            }
            if (subRand == 3) {
                piece = new CapLoot(manager, capLoot, pos, offset, rotation);
            }
            if (subRand == 4) {
                piece = new CapCart(manager, capCart, pos, offset, rotation);
            }
        } else {
            piece = new CorridorEnd(manager, corridorEnd, pos, offset, rotation);
        }
        return piece;
    }

    public static void createMine(TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> components, Random rand) {
        Top top = new Top(manager, mineTop, pos, 0, rot);
        components.add((StructurePiece)top);
        int iterations = 2;
        for (int i = 0; i <= iterations; ++i) {
            Middle middle = new Middle(manager, mineMiddle, pos, -(i * 14 + 7), rot);
            components.add((StructurePiece)middle);
            if (rand.nextInt(10) < 5 || i == iterations) {
                Bottom bottom = new Bottom(manager, mineBottom, pos, -(i * 14 + 14), rot);
                components.add((StructurePiece)bottom);
                break;
            }
            Split split = new Split(manager, mineSplit, pos, -(i * 14 + 14), rot);
            components.add((StructurePiece)split);
            split.func_74861_a((StructurePiece)split, components, rand);
        }
    }

    public static class Top
    extends TemplateStructurePiece {
        private final TemplateManager manager;
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;

        public Top(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMTOP, 0);
            this.template_name = location;
            this.rot = rotation;
            this.manager = manager;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.setup(manager);
        }

        public Top(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMTOP, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.manager = templateManager;
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("spawnMiner".equals(function)) {
                EntityMiner miner = (EntityMiner)EntityInit.MINER.func_200721_a((World)worldIn.func_201672_e());
                miner.func_110163_bv();
                miner.func_174828_a(pos, 0.0f, 0.0f);
                miner.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)miner.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)miner);
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }

    public static class Middle
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;

        public Middle(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMMIDDLE, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.setup(manager);
        }

        public Middle(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMMIDDLE, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.setup(templateManager);
            this.offset = compoundNBT.func_74762_e("Offset");
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }

    public static class Split
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;
        private final TemplateManager manager;

        public Split(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMSPLIT, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.manager = manager;
            this.setup(manager);
        }

        public Split(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMSPLIT, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.manager = templateManager;
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            TileEntity tileentity;
            if ("spawnMiner".equals(function)) {
                EntityMiner miner = (EntityMiner)EntityInit.MINER.func_200721_a((World)worldIn.func_201672_e());
                miner.func_110163_bv();
                miner.func_174828_a(pos, 0.0f, 0.0f);
                miner.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)miner.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)miner);
            }
            if ("barrel".equals(function) && (tileentity = worldIn.func_175625_s(pos.func_177977_b())) instanceof BarrelTileEntity) {
                ((BarrelTileEntity)tileentity).func_189404_a(IllagerPlusLootTable.ILLAGER_MINE, rand.nextLong());
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            TemplateStructurePiece piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(2, 0, 9), this.manager, 0, Rotation.NONE);
            listIn.add((StructurePiece)piece);
            piece.func_74861_a(componentIn, listIn, rand);
            TemplateStructurePiece piece2 = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(-1, 0, 2), this.manager, 0, Rotation.CLOCKWISE_90);
            listIn.add((StructurePiece)piece2);
            piece2.func_74861_a(componentIn, listIn, rand);
            TemplateStructurePiece piece3 = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(6, 0, -1), this.manager, 0, Rotation.CLOCKWISE_180);
            listIn.add((StructurePiece)piece3);
            piece3.func_74861_a(componentIn, listIn, rand);
            TemplateStructurePiece piece4 = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(9, 0, 6), this.manager, 0, Rotation.COUNTERCLOCKWISE_90);
            listIn.add((StructurePiece)piece4);
            piece4.func_74861_a(componentIn, listIn, rand);
        }
    }

    public static class Bottom
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;

        public Bottom(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMBOTTOM, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.setup(manager);
        }

        public Bottom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMBOTTOM, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            TileEntity tileentity;
            if ("spawnFurantur".equals(function)) {
                EntityFurantur f = (EntityFurantur)EntityInit.FURANTUR.func_200721_a((World)worldIn.func_201672_e());
                f.func_110163_bv();
                f.func_174828_a(pos, 0.0f, 0.0f);
                f.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)f.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)f);
            }
            if ("spawnPillager".equals(function)) {
                PillagerEntity p = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a((World)worldIn.func_201672_e());
                p.func_110163_bv();
                p.func_174828_a(pos, 0.0f, 0.0f);
                p.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)p.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)p);
            }
            if ("spawnMiner".equals(function)) {
                EntityMiner miner = (EntityMiner)EntityInit.MINER.func_200721_a((World)worldIn.func_201672_e());
                miner.func_110163_bv();
                miner.func_174828_a(pos, 0.0f, 0.0f);
                miner.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)miner.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)miner);
            }
            if ("barrel".equals(function) && (tileentity = worldIn.func_175625_s(pos.func_177977_b())) instanceof BarrelTileEntity) {
                ((BarrelTileEntity)tileentity).func_189404_a(IllagerPlusLootTable.ILLAGER_MINE, rand.nextLong());
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }

    public static class CorridorNormal
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;
        private final TemplateManager manager;

        public CorridorNormal(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMCN, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.manager = manager;
            this.setup(manager);
        }

        public CorridorNormal(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMCN, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.manager = templateManager;
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("lantern_chance".equals(function)) {
                if (rand.nextInt(10) < 5) {
                    worldIn.func_180501_a(pos, (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            TemplateStructurePiece piece;
            if (this.rot == Rotation.NONE) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, 5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(-5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_180) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, -5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.COUNTERCLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
        }
    }

    public static class CorridorDetect
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;
        private final TemplateManager manager;

        public CorridorDetect(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMCD, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.manager = manager;
            this.setup(manager);
        }

        public CorridorDetect(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMCD, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.manager = templateManager;
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            BlockPos pos1 = this.field_186178_c;
            if (this.rot == Rotation.NONE) {
                this.field_186178_c = pos1.func_177976_e();
            }
            if (this.rot == Rotation.CLOCKWISE_90) {
                this.field_186178_c = pos1.func_177978_c();
            }
            if (this.rot == Rotation.CLOCKWISE_180) {
                this.field_186178_c = pos1.func_177974_f();
            }
            if (this.rot == Rotation.COUNTERCLOCKWISE_90) {
                this.field_186178_c = pos1.func_177968_d();
            }
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            TemplateStructurePiece piece;
            if (this.rot == Rotation.NONE) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, 5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(-5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_180) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, -5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.COUNTERCLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
        }
    }

    public static class CorridorGravel
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;
        private final TemplateManager manager;

        public CorridorGravel(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMCG, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.manager = manager;
            this.setup(manager);
        }

        public CorridorGravel(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMCG, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.manager = templateManager;
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("gravel")) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int y = 0; y <= 3; ++y) {
                            if (worldIn.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c() == Blocks.field_185779_df) continue;
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), Blocks.field_150351_n.func_176223_P(), 2);
                        }
                    }
                }
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            TemplateStructurePiece piece;
            if (this.rot == Rotation.NONE) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, 5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(-5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_180) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, -5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.COUNTERCLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
        }
    }

    public static class CorridorWater
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;
        private final TemplateManager manager;

        public CorridorWater(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMCW, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.manager = manager;
            this.setup(manager);
        }

        public CorridorWater(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMCW, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.manager = templateManager;
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            TemplateStructurePiece piece;
            if (this.rot == Rotation.NONE) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, 5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(-5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.CLOCKWISE_180) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(0, 0, -5), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
            if (this.rot == Rotation.COUNTERCLOCKWISE_90) {
                piece = IllagerMinePieces.createRandomCorridorPiece(rand, this.field_186178_c.func_177982_a(5, 0, 0), this.manager, 0, this.rot);
                listIn.add((StructurePiece)piece);
                piece.func_74861_a(componentIn, listIn, rand);
            }
        }
    }

    public static class CorridorEnd
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;

        public CorridorEnd(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMCE, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.setup(manager);
        }

        public CorridorEnd(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMCE, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("lantern_chance".equals(function)) {
                if (rand.nextInt(10) < 5) {
                    worldIn.func_180501_a(pos, (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
            if ("spawnMinecart".equals(function)) {
                MinecartEntity m = (MinecartEntity)EntityType.field_200772_L.func_200721_a((World)worldIn.func_201672_e());
                m.func_174828_a(pos, 0.0f, 0.0f);
                worldIn.func_217376_c((Entity)m);
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }

    public static class CapLoot
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;

        public CapLoot(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMCLOOT, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.setup(manager);
        }

        public CapLoot(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMCLOOT, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            TileEntity tileentity;
            if ("spawnMinecart".equals(function)) {
                MinecartEntity m = (MinecartEntity)EntityType.field_200772_L.func_200721_a((World)worldIn.func_201672_e());
                m.func_174828_a(pos, 0.0f, 0.0f);
                worldIn.func_217376_c((Entity)m);
            }
            if ("spawnPillager".equals(function)) {
                PillagerEntity p = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a((World)worldIn.func_201672_e());
                p.func_110163_bv();
                p.func_174828_a(pos, 0.0f, 0.0f);
                p.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)p.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)p);
            }
            if ("barrel".equals(function) && (tileentity = worldIn.func_175625_s(pos.func_177977_b())) instanceof BarrelTileEntity) {
                ((BarrelTileEntity)tileentity).func_189404_a(IllagerPlusLootTable.ILLAGER_MINE, rand.nextLong());
            }
            if ("chest".equals(function) && (tileentity = worldIn.func_175625_s(pos.func_177977_b())) instanceof ChestTileEntity) {
                ((ChestTileEntity)tileentity).func_189404_a(IllagerPlusLootTable.ILLAGER_MINE, rand.nextLong());
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }

    public static class CapCart
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;
        private final int offset;

        public CapCart(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IMCCART, 0);
            this.template_name = location;
            this.rot = rotation;
            this.offset = offset;
            this.field_186178_c = pos.func_177981_b(this.offset);
            this.setup(manager);
        }

        public CapCart(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IMCCART, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.offset = compoundNBT.func_74762_e("Offset");
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
            tagCompound.func_74768_a("Offset", this.offset);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            TileEntity tileentity;
            if ("spawnMinecart".equals(function)) {
                MinecartEntity m = (MinecartEntity)EntityType.field_200772_L.func_200721_a((World)worldIn.func_201672_e());
                m.func_174828_a(pos, 0.0f, 0.0f);
                worldIn.func_217376_c((Entity)m);
            }
            if ("spawnMiner".equals(function)) {
                EntityMiner miner = (EntityMiner)EntityInit.MINER.func_200721_a((World)worldIn.func_201672_e());
                miner.func_110163_bv();
                miner.func_174828_a(pos, 0.0f, 0.0f);
                miner.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)miner.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)miner);
            }
            if ("barrel".equals(function) && (tileentity = worldIn.func_175625_s(pos.func_177977_b())) instanceof BarrelTileEntity) {
                ((BarrelTileEntity)tileentity).func_189404_a(IllagerPlusLootTable.ILLAGER_MINE, rand.nextLong());
            }
            if ("chest".equals(function) && (tileentity = worldIn.func_175625_s(pos.func_177977_b())) instanceof ChestTileEntity) {
                ((ChestTileEntity)tileentity).func_189404_a(IllagerPlusLootTable.ILLAGER_MINE, rand.nextLong());
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            BlockPos pos1 = this.field_186178_c;
            if (this.rot == Rotation.NONE) {
                this.field_186178_c = pos1.func_177976_e();
            }
            if (this.rot == Rotation.CLOCKWISE_90) {
                this.field_186178_c = pos1.func_177978_c();
            }
            if (this.rot == Rotation.CLOCKWISE_180) {
                this.field_186178_c = pos1.func_177974_f();
            }
            if (this.rot == Rotation.COUNTERCLOCKWISE_90) {
                this.field_186178_c = pos1.func_177968_d();
            }
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }
}

