/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.commands;

import com.dorian2712.jobs.data.PlayerData;
import com.dorian2712.jobs.network.PacketUpdateClientJob;
import com.dorian2712.jobs.util.Constants;
import com.dorian2712.jobs.util.handlers.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandSet
extends CommandBase {
    public String func_71517_b() {
        return "jobs-set";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/jobs-set [player] [job] [level] [xp]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP target = null;
        if (args.length == 3) {
            target = server.func_184103_al().func_152612_a(args[0]);
            Constants.Job job = Constants.Job.valueOf(args[1]);
            long total = Long.parseLong(args[2]);
            if (target == null) {
                this.sendError(sender);
                return;
            }
            this.setJob(target, job, total);
        } else if (args.length == 4) {
            target = server.func_184103_al().func_152612_a(args[0]);
            Constants.Job job = Constants.Job.valueOf(args[1]);
            int lvl = Integer.parseInt(args[2]);
            long xp = Long.parseLong(args[3]);
            long total = Constants.TOTAL_XP_BY_LEVEL[lvl] + xp;
            if (target == null) {
                this.sendError(sender);
                return;
            }
            this.setJob(target, job, total);
        } else {
            this.sendError(sender);
            return;
        }
    }

    private void sendError(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + this.func_71518_a(sender)));
    }

    private void setJob(EntityPlayerMP target, Constants.Job j, long xp) {
        PlayerData.getPlayerJobs((EntityPlayer)target).set(j, xp);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketUpdateClientJob((EntityPlayer)target), target);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> completions;
        block3: {
            block2: {
                completions = new ArrayList<String>();
                if (args.length != 1) break block2;
                for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                    completions.add(p.func_70005_c_());
                }
                break block3;
            }
            if (args.length != 2) break block3;
            for (Constants.Job j : Constants.Job.values()) {
                if (j == Constants.Job.NONE) continue;
                completions.add(j.name());
            }
        }
        return completions;
    }
}

