/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.data;

import com.dorian2712.jobs.data.GainXPUtil;
import com.dorian2712.jobs.network.PacketAddXP;
import com.dorian2712.jobs.network.PacketLevelUp;
import com.dorian2712.jobs.network.PacketSendRewardsClient;
import com.dorian2712.jobs.network.PacketUpdateClientJob;
import com.dorian2712.jobs.util.Constants;
import com.dorian2712.jobs.util.JobsMath;
import com.dorian2712.jobs.util.handlers.PacketHandler;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.server.FMLServerHandler;

public class JobsInfo {
    private int[] levels = new int[]{0, 0, 0, 0};
    private long[] XPs = new long[]{0L, 0L, 0L, 0L};

    public void set(Constants.Job j, int lvl, long xp) {
        long total = Constants.TOTAL_XP_BY_LEVEL[lvl] + xp;
        this.set(j, total);
    }

    public void set(Constants.Job j, long value) {
        long total = JobsMath.clamp(value, 0L, Constants.TOTAL_XP_BY_LEVEL[25]);
        int lvl = 0;
        long xp = 0L;
        for (int i = 25; i >= 0; --i) {
            if (Constants.TOTAL_XP_BY_LEVEL[i] > total) continue;
            lvl = i;
            xp = total - Constants.TOTAL_XP_BY_LEVEL[i];
            break;
        }
        this.levels[j.index] = lvl;
        this.XPs[j.index] = xp;
    }

    public int getLevelByJob(Constants.Job j) {
        return this.levels[j.index];
    }

    public long getXPByJob(Constants.Job j) {
        return this.XPs[j.index];
    }

    public long getMissingXPForJob(Constants.Job j) {
        if (this.levels[j.index] >= 25) {
            return 0L;
        }
        return Constants.XP_BY_LEVEL[j.index + 1] - this.XPs[j.index];
    }

    public JobsInfo fromTotalXPs(long[] total) {
        if (total.length != 4) {
            return new JobsInfo();
        }
        for (int i = 0; i < 4; ++i) {
            long l = total[i];
            Constants.Job j = Constants.Job.byIndex(i);
            this.set(j, l);
        }
        return this;
    }

    public long[] toTotalXPs() {
        long[] total = new long[]{0L, 0L, 0L, 0L};
        for (int i = 0; i < 4; ++i) {
            long l;
            total[i] = l = Constants.TOTAL_XP_BY_LEVEL[this.levels[i]] + this.XPs[i];
        }
        return total;
    }

    public void addXP(Constants.Job j, long xp) {
        long total = Constants.TOTAL_XP_BY_LEVEL[this.levels[j.index]] + this.XPs[j.index] + xp;
        this.set(j, total);
    }

    public boolean isMax(Constants.Job j) {
        return this.levels[j.index] >= 25;
    }

    public void gainXP(Constants.Job j, long xp, EntityPlayerMP p) {
        if (xp <= 0L) {
            return;
        }
        int previousLVL = this.levels[j.index];
        this.addXP(j, xp);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketUpdateClientJob((EntityPlayer)p), p);
        int LVL = this.levels[j.index];
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketAddXP(j, xp), p);
        if (LVL > previousLVL) {
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketLevelUp(j), p);
            this.giveReward(p, j, LVL);
        }
        if (LVL == 25) {
            for (EntityPlayerMP mp : FMLServerHandler.instance().getServer().func_184103_al().func_181057_v()) {
                mp.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + p.func_70005_c_() + TextFormatting.BLUE + " has reached level 25 for the job " + I18n.func_74838_a((String)("jobs." + j.name)) + " !"));
                FMLServerHandler.instance().getServer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + p.func_70005_c_() + TextFormatting.BLUE + " has reached level 25 for the job " + I18n.func_74838_a((String)("jobs." + j.name)) + " !"));
            }
        }
    }

    private void giveReward(EntityPlayerMP p, Constants.Job j, int lvl) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        System.out.println((Object)((Object)j) + " : " + lvl);
        switch (j) {
            case HUNTER: {
                for (ItemStack s : GainXPUtil.REWARDS_WARRIOR.get(lvl)) {
                    list.add(s.func_77946_l());
                }
                break;
            }
            case MAGICIAN: {
                for (ItemStack s : GainXPUtil.REWARDS_WIZARD.get(lvl)) {
                    list.add(s.func_77946_l());
                }
                break;
            }
            case FARMER: {
                for (ItemStack s : GainXPUtil.REWARDS_HERBALIST.get(lvl)) {
                    list.add(s.func_77946_l());
                }
                break;
            }
            case MINER: {
                for (ItemStack s : GainXPUtil.REWARDS_MINER.get(lvl)) {
                    list.add(s.func_77946_l());
                }
                break;
            }
        }
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSendRewardsClient(list), p);
        for (ItemStack s : list) {
            p.func_191521_c(s.func_77946_l());
        }
        p.field_71069_bz.func_75142_b();
    }

    public void fromNBT(NBTTagCompound nbt) {
        this.fromTotalXPs(new long[]{nbt.func_74763_f("hunter"), nbt.func_74763_f("magician"), nbt.func_74763_f("farmer"), nbt.func_74763_f("miner")});
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        long[] xps = this.toTotalXPs();
        nbt.func_74772_a("hunter", xps[0]);
        nbt.func_74772_a("magician", xps[1]);
        nbt.func_74772_a("farmer", xps[2]);
        nbt.func_74772_a("miner", xps[3]);
        return nbt;
    }

    public void copy(JobsInfo other) {
        this.fromTotalXPs(other.toTotalXPs());
    }
}

