/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.gui.buttons;

import com.dorian2712.jobs.data.ClientInfos;
import com.dorian2712.jobs.util.Constants;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class ButtonJob
extends GuiButton {
    private final ResourceLocation texture = new ResourceLocation("jobs:textures/gui/jobs_icons.png");
    private final int xTexStart;
    private final int yTexStart;
    private final String title;
    private final Constants.Job job;

    public ButtonJob(int index, int posX, int posY, Constants.Job j) {
        super(index, posX, posY, 200, 30, "");
        this.xTexStart = 40 * j.index;
        this.yTexStart = 0;
        this.title = I18n.func_74838_a((String)("jobs." + j.name));
        this.job = j;
    }

    public void setPosition(int x, int y) {
        this.field_146128_h = x;
        this.field_146129_i = y;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(this.texture);
            this.drawIcon();
            this.drawGradient();
            this.drawName();
        }
    }

    private void drawIcon() {
        int i = this.xTexStart;
        int j = this.yTexStart;
        ButtonJob.func_152125_a((int)this.field_146128_h, (int)this.field_146129_i, (float)i, (float)j, (int)40, (int)40, (int)30, (int)30, (float)256.0f, (float)256.0f);
        ButtonJob.func_152125_a((int)this.field_146128_h, (int)this.field_146129_i, (float)0.0f, (float)40.0f, (int)40, (int)40, (int)30, (int)30, (float)256.0f, (float)256.0f);
    }

    private void drawGradient() {
        long xp = ClientInfos.job.getXPByJob(this.job);
        int lvl = ClientInfos.job.getLevelByJob(this.job);
        if (lvl < 25) {
            long total = Constants.XP_BY_LEVEL[lvl + 1];
            int size = (int)(150.0 * ((double)xp / (double)total));
            this.func_73729_b(this.field_146128_h + 45, this.field_146129_i + 15, 0, 80, 150, 12);
            this.func_73729_b(this.field_146128_h + 45, this.field_146129_i + 15, 0, 92, size, 12);
            String info = xp + "/" + total;
            int widthInfo = Minecraft.func_71410_x().field_71466_p.func_78256_a(info);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(info, this.field_146128_h + 120 - widthInfo / 2, this.field_146129_i + 18, Color.white.getRGB());
        } else {
            int size = 150;
            this.func_73729_b(this.field_146128_h + 45, this.field_146129_i + 15, 0, 80, 150, 12);
            this.func_73729_b(this.field_146128_h + 45, this.field_146129_i + 15, 0, 104, size, 12);
            String info = I18n.func_74838_a((String)"text.level.max");
            int widthInfo = Minecraft.func_71410_x().field_71466_p.func_78256_a(info);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(info, this.field_146128_h + 120 - widthInfo / 2, this.field_146129_i + 18, Color.white.getRGB());
        }
    }

    private void drawName() {
        int lvl = ClientInfos.job.getLevelByJob(this.job);
        String name = this.title + " (" + I18n.func_74838_a((String)"text.level") + " " + lvl + ")";
        int x = 120 - Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2;
        int y = 2;
        Minecraft.func_71410_x().field_71466_p.func_78276_b(name, this.field_146128_h + x, this.field_146129_i + y, Color.black.getRGB());
    }
}

