/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.gui.screens;

import com.dorian2712.jobs.data.ClientInfos;
import com.dorian2712.jobs.gui.buttons.ButtonBack;
import com.dorian2712.jobs.gui.buttons.SlideBarXP;
import com.dorian2712.jobs.gui.screens.GuiJobInfos;
import com.dorian2712.jobs.util.Constants;
import com.dorian2712.jobs.util.JobsMath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.input.Mouse;

public class GuiHowXP
extends GuiScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jobs", "textures/gui/gui_how_xp.png");
    public int left;
    public int top;
    private Constants.Job job;
    public int page = 0;
    public int pageNumber = 0;
    private List<Constants.XPCategories> categories = new ArrayList<Constants.XPCategories>();
    private Map<Integer, List<ItemStack>> itemLists = new HashMap<Integer, List<ItemStack>>();
    private List<String> tooltip = new ArrayList<String>();

    public GuiHowXP(Constants.Job j) {
        this.job = j;
        this.page = 0;
        for (Constants.XPCategories c : Constants.XPCategories.getXPValues()) {
            if (ClientInfos.getStacksFromCategories(c, this.job).isEmpty()) continue;
            this.categories.add(c);
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            List<ItemStack> stacks = ClientInfos.getStacksFromCategories(this.categories.get(i), this.job);
            this.itemLists.put(i, stacks);
        }
        for (Map.Entry<Integer, List<ItemStack>> entry : this.itemLists.entrySet()) {
            if (entry.getValue().size() - 4 <= this.pageNumber) continue;
            this.pageNumber = entry.getValue().size() - 4;
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.func_189646_b(new ButtonBack(0, this.field_146294_l / 2 - 83, this.field_146295_m / 2 - 70));
        this.func_189646_b(new SlideBarXP(1, this.field_146294_l / 2 + 65, this.field_146295_m / 2 - 46, this));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.tooltip.clear();
        this.left = this.field_146294_l / 2 - 88;
        this.top = this.field_146295_m / 2 - 75;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.left, this.top, 0, 0, 176, 150);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawCategories(mouseX, mouseY);
        this.drawCategoriesStacks(mouseX, mouseY);
        if (!this.tooltip.isEmpty()) {
            this.func_146283_a(this.tooltip, mouseX, mouseY);
        }
    }

    private void drawCategories(int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        int size = this.categories.size() * 30 + this.categories.size() - 1;
        int x = this.left + 3 + 74 - size / 2;
        int renderIndex = -1;
        for (int i = 0; i < this.categories.size(); ++i) {
            this.func_73729_b(x + i * 31 + 7, this.top + 10, this.categories.get((int)i).index * 16, 150, 16, 16);
            if (mouseX >= x + i * 31 + 7 && mouseX < x + i * 31 + 23 && mouseY >= this.top + 10 && mouseY < this.top + 26) {
                renderIndex = i;
            }
            if (i >= this.categories.size() - 1) continue;
            this.func_73729_b(x + i * 31 + 30, this.top + 10, 176, 0, 1, 126);
        }
        if (renderIndex != -1) {
            this.tooltip.add(I18n.func_74838_a((String)("category." + this.categories.get(renderIndex).name())));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJobInfos(this.job));
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.getEventDWheel() != 0) {
            int x = -1 * Integer.signum(Mouse.getEventDWheel());
            this.page = JobsMath.clamp(this.page + x, 0, this.pageNumber - 1);
            ((GuiButton)this.field_146292_n.get((int)1)).field_146129_i = this.top + 29 + (int)((double)this.page / (double)(this.pageNumber - 1) * 91.0);
        }
    }

    private void drawCategoriesStacks(int mouseX, int mouseY) {
        int size = this.categories.size() * 30 + this.categories.size() - 1;
        for (int i = 0; i < this.categories.size(); ++i) {
            int x = this.left + 3 + 74 - size / 2 + 7 + i * 31;
            List<ItemStack> stacks = this.itemLists.get(i);
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            int hoveredIndex = -1;
            for (int j = this.page; j < stacks.size() && j < this.page + 5 && j >= 0; ++j) {
                int y = this.top + 39 + (j - this.page) * 18;
                ItemStack stack = stacks.get(j);
                if (stack.func_77973_b() == Items.field_151048_u && stack.func_77942_o()) {
                    int scale = Constants.getClassScaleByName().get(stack.func_77978_p().func_74779_i("class"));
                    GuiJobInfos.drawEntityOnScreen(x + 8, y + 16, scale / 2, 200.0f, 100.0f, Constants.getEntityByName(stack.func_77978_p().func_74779_i("class"), Minecraft.func_71410_x().field_71439_g.field_70170_p));
                } else {
                    this.field_146296_j.func_180450_b(stack, x, y);
                }
                if (mouseX < x || mouseX >= x + 16 || mouseY < y || mouseY >= y + 16) continue;
                hoveredIndex = j;
            }
            if (hoveredIndex != -1) {
                ItemStack s = stacks.get(hoveredIndex);
                if (s.func_77973_b() == Items.field_151048_u && s.func_77942_o()) {
                    this.tooltip.add(s.func_77978_p().func_74779_i("class"));
                } else {
                    this.tooltip.add(s.func_82833_r());
                }
                long xp = 0L;
                int lvl = ClientInfos.job.getLevelByJob(this.job);
                if (lvl < 25) {
                    if (ClientInfos.CRAFT_ITEM_JOB.containsKey(s.func_77973_b())) {
                        xp = ClientInfos.CRAFT_ITEM_XP.get(s.func_77973_b())[lvl];
                    } else if (ClientInfos.SMELT_ITEM_JOB.containsKey(s.func_77973_b())) {
                        xp = ClientInfos.SMELT_ITEM_XP.get(s.func_77973_b())[lvl];
                    } else if (ClientInfos.BREAK_BLOCK_JOB.containsKey(Block.func_149634_a((Item)s.func_77973_b()))) {
                        xp = ClientInfos.BREAK_BLOCK_XP.get(Block.func_149634_a((Item)s.func_77973_b()))[lvl];
                    } else if (ClientInfos.HARVEST_CROP_JOB.containsKey(s.func_77973_b())) {
                        xp = ClientInfos.HARVEST_CROP_XP.get(s.func_77973_b())[lvl];
                    } else if (s.func_77942_o() && s.func_77973_b() == Items.field_151048_u && ClientInfos.KILL_ENTITY_JOB.containsKey(s.func_77978_p().func_74779_i("class"))) {
                        xp = ClientInfos.KILL_ENTITY_XP.get(s.func_77978_p().func_74779_i("class"))[lvl];
                    }
                    if (xp != 0L) {
                        this.tooltip.add(TextFormatting.GREEN + "" + xp + " xp");
                    } else {
                        boolean toUnlock = false;
                        for (int j = lvl + 1; j < 25; ++j) {
                            if (ClientInfos.CRAFT_ITEM_XP.containsKey(s.func_77973_b()) && ClientInfos.CRAFT_ITEM_XP.get(s.func_77973_b())[j] > 0L) {
                                toUnlock = true;
                                this.tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"text.unlock_lvl") + " " + j);
                                break;
                            }
                            if (ClientInfos.SMELT_ITEM_XP.containsKey(s.func_77973_b()) && ClientInfos.SMELT_ITEM_XP.get(s.func_77973_b())[j] > 0L) {
                                toUnlock = true;
                                this.tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"text.unlock_lvl") + " " + j);
                                break;
                            }
                            if (ClientInfos.BREAK_BLOCK_XP.containsKey(Block.func_149634_a((Item)s.func_77973_b())) && ClientInfos.BREAK_BLOCK_XP.get(Block.func_149634_a((Item)s.func_77973_b()))[j] > 0L) {
                                toUnlock = true;
                                this.tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"text.unlock_lvl") + " " + j);
                                break;
                            }
                            if (ClientInfos.HARVEST_CROP_XP.containsKey(s.func_77973_b()) && ClientInfos.HARVEST_CROP_XP.get(s.func_77973_b())[j] > 0L) {
                                toUnlock = true;
                                this.tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"text.unlock_lvl") + " " + j);
                                break;
                            }
                            if (s.func_77973_b() != Items.field_151048_u || !s.func_77942_o() || !ClientInfos.KILL_ENTITY_XP.containsKey(s.func_77978_p().func_74779_i("class")) || ClientInfos.KILL_ENTITY_XP.get(s.func_77978_p().func_74779_i("class"))[j] <= 0L) continue;
                            toUnlock = true;
                            this.tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"text.unlock_lvl") + " " + j);
                            break;
                        }
                        if (!toUnlock) {
                            this.tooltip.add(TextFormatting.RED + "0 xp");
                        }
                    }
                } else {
                    this.tooltip.add(TextFormatting.DARK_PURPLE + "0 xp");
                }
            }
            RenderHelper.func_74519_b();
        }
    }
}

