/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.gui.screens;

import com.dorian2712.jobs.data.ClientInfos;
import com.dorian2712.jobs.gui.buttons.ButtonBack;
import com.dorian2712.jobs.gui.buttons.ButtonXPCategory;
import com.dorian2712.jobs.gui.buttons.SlideBarUnlock;
import com.dorian2712.jobs.gui.screens.GuiHowXP;
import com.dorian2712.jobs.gui.screens.MainJobsMenu;
import com.dorian2712.jobs.util.Constants;
import com.dorian2712.jobs.util.JobsMath;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.input.Mouse;

public class GuiJobInfos
extends GuiScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jobs", "textures/gui/gui_job_infos.png");
    private static final ResourceLocation ICONES = new ResourceLocation("jobs", "textures/gui/jobs_icons.png");
    private static final ResourceLocation UNLOCK_BACKGROUND = new ResourceLocation("jobs", "textures/gui/gui_unlocked_items.png");
    private final Constants.Job job;
    public int left;
    public int top;
    private int offsetUnlock;
    private RenderItem renderItem;
    public int page;
    public final int pageNumber;
    private List<Item> unlocked_items = new ArrayList<Item>();

    public GuiJobInfos(Constants.Job job) {
        this.left = this.field_146294_l / 2 - 110;
        this.top = this.field_146295_m / 2 - 90;
        this.job = job;
        this.offsetUnlock = 0;
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
        this.page = 0;
        this.unlocked_items = ClientInfos.getClassedUnlockedItems(this.job);
        this.pageNumber = this.unlocked_items.size() <= 7 ? 1 : this.unlocked_items.size() - 6;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.func_189646_b(new ButtonBack(0, this.field_146294_l / 2 - 105 + this.offsetUnlock, this.field_146295_m / 2 - 85));
        this.func_189646_b(new ButtonXPCategory(1, this.field_146294_l / 2 - 84 + this.offsetUnlock, this.field_146295_m / 2 + 40, Constants.XPCategories.XP));
        this.func_189646_b(new ButtonXPCategory(2, this.field_146294_l / 2 + 4 + this.offsetUnlock, this.field_146295_m / 2 + 40, Constants.XPCategories.UNLOCK));
        if (this.offsetUnlock == -70) {
            this.func_189646_b(new SlideBarUnlock(3, this.field_146294_l / 2 + this.offsetUnlock + 115 + 48, this.top + 14 + 16, this));
        }
        super.func_73866_w_();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.left = this.field_146294_l / 2 - 110 + this.offsetUnlock;
        this.top = this.field_146295_m / 2 - 90;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.left, this.top, 0, 0, 220, 180);
        this.drawGradients();
        if (this.offsetUnlock != 0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(UNLOCK_BACKGROUND);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.left + 225, this.top + 14, 0, 0, 70, 152);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.offsetUnlock != 0) {
            this.drawUnlockedItems(mouseX, mouseY);
        }
    }

    private void drawUnlockedItems(int mouseX, int mouseY) {
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        int renderIndex = -1;
        for (int i = 0; i < (this.unlocked_items.size() >= 7 ? 7 : this.unlocked_items.size() - this.page); ++i) {
            this.renderItem.func_180450_b(new ItemStack(this.unlocked_items.get(i + this.page)), this.left + 242, this.top + 27 + i * 18);
            if (mouseX < this.left + 242 || mouseX >= this.left + 258 || mouseY < this.top + 27 + i * 18 || mouseY >= this.top + 27 + 16 + i * 18) continue;
            renderIndex = i;
        }
        if (renderIndex != -1) {
            this.func_146285_a(new ItemStack(this.unlocked_items.get(renderIndex + this.page)), mouseX, mouseY);
        }
        RenderHelper.func_74519_b();
    }

    private void drawGradients() {
        int lvl = ClientInfos.job.getLevelByJob(this.job);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ICONES);
        this.func_73729_b(this.field_146294_l / 2 - 20 + this.offsetUnlock, this.top + 7, 40 * this.job.index, 0, 40, 40);
        this.func_73729_b(this.field_146294_l / 2 - 20 + this.offsetUnlock, this.top + 7, 0, 40, 40, 40);
        this.func_73729_b(this.field_146294_l / 2 - 75 + this.offsetUnlock, this.top + 65, 0, 80, 150, 12);
        if (lvl < 25) {
            this.func_73729_b(this.field_146294_l / 2 - 75 + this.offsetUnlock, this.top + 90, 0, 80, 150, 12);
        }
        int y = lvl < 25 ? 92 : 104;
        int size1 = lvl < 25 ? (int)((double)ClientInfos.job.getXPByJob(this.job) / (double)Constants.XP_BY_LEVEL[lvl + 1] * 150.0) : 150;
        int size2 = lvl < 25 ? (int)((double)ClientInfos.job.toTotalXPs()[this.job.index] / (double)Constants.TOTAL_XP_BY_LEVEL[25] * 150.0) : 0;
        String text1 = lvl < 25 ? ClientInfos.job.getXPByJob(this.job) + "/" + Constants.XP_BY_LEVEL[lvl + 1] : I18n.func_74838_a((String)"text.level.max");
        String text2 = lvl < 25 ? ClientInfos.job.toTotalXPs()[this.job.index] + "/" + Constants.TOTAL_XP_BY_LEVEL[25] : "";
        String title1 = I18n.func_74838_a((String)"text.level") + " " + lvl;
        String title2 = lvl < 25 ? I18n.func_74838_a((String)"text.total_progression") : "";
        this.func_73729_b(this.field_146294_l / 2 - 75 + this.offsetUnlock, this.top + 65, 0, y, size1, 12);
        this.func_73729_b(this.field_146294_l / 2 - 75 + this.offsetUnlock, this.top + 90, 0, y, size2, 12);
        this.field_146289_q.func_78276_b(text1, this.field_146294_l / 2 + this.offsetUnlock - this.field_146289_q.func_78256_a(text1) / 2, this.top + 67, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b(text2, this.field_146294_l / 2 + this.offsetUnlock - this.field_146289_q.func_78256_a(text2) / 2, this.top + 92, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b(title1, this.field_146294_l / 2 + this.offsetUnlock - this.field_146289_q.func_78256_a(title1) / 2, this.top + 56, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(title2, this.field_146294_l / 2 + this.offsetUnlock - this.field_146289_q.func_78256_a(title2) / 2, this.top + 81, Color.BLACK.getRGB());
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new MainJobsMenu());
                break;
            }
            case 1: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiHowXP(this.job));
                break;
            }
            case 2: {
                if (this.offsetUnlock == 0) {
                    this.offsetUnlock = -70;
                } else if (this.offsetUnlock == -70) {
                    this.offsetUnlock = 0;
                }
                this.func_73866_w_();
                break;
            }
        }
        super.func_146284_a(button);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public List<String> func_191927_a(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(stack.func_82833_r());
        if (ClientInfos.CRAFT_UNLOCK_LVL.get(stack.func_77973_b()) > ClientInfos.job.getLevelByJob(this.job)) {
            tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"text.unlock_lvl") + " " + ClientInfos.CRAFT_UNLOCK_LVL.get(stack.func_77973_b()));
        } else {
            tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"text.unlock_craft"));
        }
        return tooltip;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.getEventDWheel() != 0 && this.offsetUnlock == -70) {
            int x = -1 * Integer.signum(Mouse.getEventDWheel());
            this.page = JobsMath.clamp(this.page + x, 0, this.pageNumber - 1);
            ((GuiButton)this.field_146292_n.get((int)3)).field_146129_i = this.top + 30 + (int)((double)this.page / (double)(this.pageNumber - 1) * 105.0);
        }
    }
}

