/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.gui.screens;

import com.dorian2712.jobs.data.ClientInfos;
import com.dorian2712.jobs.util.Constants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLevelUp
extends GuiScreen {
    public static final ResourceLocation TEXTURES = new ResourceLocation("jobs", "textures/gui/gui_level_up.png");
    public static final ResourceLocation ICONS = new ResourceLocation("jobs", "textures/gui/jobs_icons.png");
    private final Constants.Job job;
    private final RenderItem renderer;

    public GuiLevelUp(Constants.Job job) {
        this.job = job;
        this.renderer = Minecraft.func_71410_x().func_175599_af();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146289_q == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_146294_l / 2 - 88, this.field_146295_m / 2 - 75, 0, 0, 176, 150);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ICONS);
        int textY = ClientInfos.job.getLevelByJob(this.job) >= 25 ? 12 : 0;
        this.func_73729_b(this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 30, 0, 92 + textY, 150, 12);
        GuiLevelUp.func_152125_a((int)(this.field_146294_l / 2 - 15), (int)(this.field_146295_m / 2 - 66), (float)(this.job.index * 40), (float)0.0f, (int)40, (int)40, (int)30, (int)30, (float)256.0f, (float)256.0f);
        GuiLevelUp.func_152125_a((int)(this.field_146294_l / 2 - 15), (int)(this.field_146295_m / 2 - 66), (float)0.0f, (float)40.0f, (int)40, (int)40, (int)30, (int)30, (float)256.0f, (float)256.0f);
        String lvl = I18n.func_74838_a((String)"text.level") + " " + ClientInfos.job.getLevelByJob(this.job);
        this.field_146289_q.func_78276_b(lvl, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(lvl) / 2, this.field_146295_m / 2 - 27, Color.white.getRGB());
        String unlock = I18n.func_74838_a((String)"text.unlocked");
        this.field_146289_q.func_78276_b(unlock, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(unlock) / 2, this.field_146295_m / 2, Color.black.getRGB());
        this.drawUnlockedStacks(mouseX, mouseY, partialTicks);
        String reward = I18n.func_74838_a((String)"text.rewards");
        this.field_146289_q.func_78276_b(reward, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(unlock) / 2, this.field_146295_m / 2 + 34, Color.black.getRGB());
        this.drawRewardStacks(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawUnlockedStacks(int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int hovered = -1;
        for (Item i : ClientInfos.CRAFT_UNLOCK_LVL.keySet()) {
            if (ClientInfos.CRAFT_UNLOCK_JOB.get(i) != this.job || ClientInfos.CRAFT_UNLOCK_LVL.get(i).intValue() != ClientInfos.job.getLevelByJob(this.job)) continue;
            ItemStack s = new ItemStack(i);
            stacks.add(s);
        }
        int y = this.field_146295_m / 2 + 11;
        int sizeX = stacks.size() * 16 + (stacks.size() - 1) * 6;
        int x = this.field_146294_l / 2 - sizeX / 2;
        for (int i = 0; i < stacks.size(); ++i) {
            this.renderer.func_180450_b((ItemStack)stacks.get(i), x + i * 22, y);
            if (mouseX < x + i * 22 || mouseX >= x + i * 22 + 16 || mouseY < y || mouseY >= y + 16) continue;
            hovered = i;
        }
        if (hovered != -1) {
            this.func_146285_a((ItemStack)stacks.get(hovered), mouseX, mouseY);
        }
        RenderHelper.func_74519_b();
    }

    private void drawRewardStacks(int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        List<ItemStack> stacks = ClientInfos.CURRENT_REWARDS;
        int hovered = -1;
        int y = this.field_146295_m / 2 + 48;
        int sizeX = stacks.size() * 16 + (stacks.size() - 1) * 6;
        int x = this.field_146294_l / 2 - sizeX / 2;
        for (int i = 0; i < stacks.size(); ++i) {
            this.renderer.func_180450_b(stacks.get(i).func_77946_l(), x + i * 22, y);
            if (mouseX < x + i * 22 || mouseX >= x + i * 22 + 16 || mouseY < y || mouseY >= y + 16) continue;
            hovered = i;
        }
        if (hovered != -1) {
            this.renderToolTipAndCount(stacks.get(hovered), mouseX, mouseY);
        }
        RenderHelper.func_74519_b();
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        ArrayList<String> tooltips = new ArrayList<String>();
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        tooltips.add(stack.func_82833_r());
        if (ClientInfos.CRAFT_UNLOCK_JOB.containsKey(stack.func_77973_b())) {
            tooltips.add(TextFormatting.GREEN + I18n.func_74838_a((String)"text.unlock_craft"));
        }
        this.drawHoveringText(tooltips, x, y, font == null ? this.field_146289_q : font);
    }

    protected void renderToolTipAndCount(ItemStack stack, int x, int y) {
        ArrayList<String> tooltips = new ArrayList<String>();
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        tooltips.add(stack.func_82833_r());
        tooltips.add(TextFormatting.GREEN + "" + stack.func_190916_E());
        this.drawHoveringText(tooltips, x, y, font == null ? this.field_146289_q : font);
    }
}

