/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Constants {
    public static String SaveFolder = "";
    public static String DataFolder = "";
    public static final long[] XP_BY_LEVEL = new long[]{0L, 100L, 150L, 250L, 500L, 800L, 1150L, 1550L, 2000L, 2500L, 3100L, 3750L, 4500L, 5500L, 7000L, 9000L, 11500L, 15000L, 19000L, 24000L, 30000L, 39250L, 49500L, 63100L, 80000L, 100000L};
    public static final long[] TOTAL_XP_BY_LEVEL = new long[]{0L, 100L, 250L, 500L, 1000L, 1800L, 2950L, 4500L, 6500L, 9000L, 12100L, 15850L, 20350L, 25850L, 32850L, 41850L, 53350L, 68350L, 87350L, 111350L, 141350L, 180600L, 230100L, 293200L, 373200L, 473200L};
    public static final String[] ENTITIES = new String[]{"Cow", "Chicken", "Zombie", "Sheep", "Rabbit", "Blaze", "Creeper", "Enderman", "Ghast", "Magma Cube", "Pig", "Skeleton", "Slime", "Spider", "Witch", "Wither Skeleton", "Zombie Pigman", "Player"};
    public static final int[] IDS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};

    public static Map<String, Integer> getEntitiesID() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < ENTITIES.length; ++i) {
            map.put(ENTITIES[i], IDS[i]);
        }
        return map;
    }

    public static Map<Integer, String> getIDEntities() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < ENTITIES.length; ++i) {
            map.put(IDS[i], ENTITIES[i]);
        }
        return map;
    }

    public static Map<String, Class> getClassesByName() {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("Cow", EntityCow.class);
        map.put("Chicken", EntityChicken.class);
        map.put("Zombie", EntityZombie.class);
        map.put("Sheep", EntitySheep.class);
        map.put("Rabbit", EntityRabbit.class);
        map.put("Blaze", EntityBlaze.class);
        map.put("Creeper", EntityCreeper.class);
        map.put("Enderman", EntityEnderman.class);
        map.put("Ghast", EntityGhast.class);
        map.put("Magma Cube", EntityMagmaCube.class);
        map.put("Pig", EntityPig.class);
        map.put("Skeleton", EntitySkeleton.class);
        map.put("Slime", EntitySlime.class);
        map.put("Spider", EntitySpider.class);
        map.put("Witch", EntityWitch.class);
        map.put("Wither Skeleton", EntityWitherSkeleton.class);
        map.put("Zombie Pigman", EntityPigZombie.class);
        map.put("Player", EntityPlayerSP.class);
        return map;
    }

    public static Map<String, Integer> getClassScaleByName() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Cow", 17);
        map.put("Chicken", 30);
        map.put("Zombie", 15);
        map.put("Sheep", 17);
        map.put("Rabbit", 30);
        map.put("Blaze", 16);
        map.put("Creeper", 16);
        map.put("Enderman", 12);
        map.put("Ghast", 5);
        map.put("Magma Cube", 30);
        map.put("Pig", 18);
        map.put("Skeleton", 15);
        map.put("Slime", 30);
        map.put("Spider", 20);
        map.put("Witch", 15);
        map.put("Wither Skeleton", 12);
        map.put("Zombie Pigman", 15);
        map.put("Player", 15);
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityLivingBase getEntityByName(String name, World world) {
        EntityPlayerSP e = null;
        Constructor<?> constructor = null;
        if (world == null) {
            return null;
        }
        for (Constructor<?> c : Constants.getClassesByName().get(name).getConstructors()) {
            if (c.getGenericParameterTypes().length != 1) continue;
            constructor = c;
            break;
        }
        try {
            if (constructor != null) {
                e = (EntityLivingBase)constructor.newInstance(world);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        if (e == null) {
            e = Minecraft.func_71410_x().field_71439_g;
        }
        return e;
    }

    public static enum XPCategories {
        CRAFTING(false, 0),
        SMELTING(false, 1),
        BREAKING(false, 2),
        KILLING(false, 3),
        HARVESTING(false, 4),
        XP(true, 0),
        UNLOCK(true, 1);

        public final boolean isCategory;
        public final int index;

        private XPCategories(boolean isCategory, int in) {
            this.isCategory = isCategory;
            this.index = in;
        }

        public static XPCategories[] getXPValues() {
            return new XPCategories[]{CRAFTING, SMELTING, BREAKING, KILLING, HARVESTING};
        }
    }

    public static enum Job {
        HUNTER(0, "hunter"),
        MAGICIAN(1, "magician"),
        FARMER(2, "farmer"),
        MINER(3, "miner"),
        NONE(-1, "none");

        public int index;
        public String name;

        private Job(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public static Job byIndex(int index) {
            switch (index) {
                case 0: {
                    return HUNTER;
                }
                case 1: {
                    return MAGICIAN;
                }
                case 2: {
                    return FARMER;
                }
                case 3: {
                    return MINER;
                }
            }
            return NONE;
        }
    }
}

