/*
 * Decompiled with CFR 0.152.
 */
package com.dorian2712.jobs.util.save;

import com.dorian2712.jobs.data.GainXPUtil;
import com.dorian2712.jobs.util.Constants;
import com.dorian2712.jobs.util.save.LoadXPValues;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class LoadUtil {
    public static void loadData() {
        LoadXPValues.loadBreakBlockXP();
        LoadXPValues.loadKillEntityXP();
        LoadXPValues.loadCraftItemXP();
        LoadXPValues.loadSmeltItemXP();
        LoadXPValues.loadHarvestCropXP();
        LoadUtil.loadBlockedCrafts();
        LoadUtil.loadRewards();
    }

    public static String getDataFolder() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71264_H()) {
            return server.func_71238_n().getAbsolutePath() + "/saves/" + server.func_71270_I() + "/jobs/data";
        }
        return server.func_71238_n().getAbsolutePath() + "/jobs/data";
    }

    public static void createEmptyJSON(File folder, String name) throws IOException {
        folder.mkdirs();
        JsonObject json = new JsonObject();
        JsonObject property = new JsonObject();
        property.addProperty("job", "HUNTER");
        JsonArray array = new JsonArray();
        for (int i = 0; i < 25; ++i) {
            array.add((Number)i);
        }
        property.add("xp", (JsonElement)array);
        json.add("minecraft-coal_ore", (JsonElement)property);
        FileWriter writer = new FileWriter(new File(folder.getAbsolutePath() + "/" + name));
        new Gson().toJson((JsonElement)json, (Appendable)writer);
        writer.close();
        System.out.println(TextFormatting.BLUE + "[Jobs]" + TextFormatting.YELLOW + " Warning : File <" + name + "> not found. An empty file was created");
    }

    public static void createEmptyRewardJSON(File folder, String name) throws IOException {
        folder.mkdirs();
        JsonObject json = new JsonObject();
        for (int i = 0; i < 4; ++i) {
            String property = Constants.Job.byIndex(i).name();
            JsonObject job = new JsonObject();
            for (int j = 1; j <= 25; ++j) {
                JsonArray array = new JsonArray();
                JsonObject stack = new JsonObject();
                stack.addProperty("item", "minecraft-coal");
                stack.addProperty("count", (Number)1);
                array.add((JsonElement)stack);
                job.add(String.valueOf(j), (JsonElement)array);
            }
            json.add(property, (JsonElement)job);
        }
        FileWriter writer = new FileWriter(new File(folder.getAbsolutePath() + "/" + name));
        new Gson().toJson((JsonElement)json, (Appendable)writer);
        writer.close();
        System.out.println(TextFormatting.BLUE + "[Jobs]" + TextFormatting.YELLOW + " Warning : File <" + name + "> not found. An empty file was created");
    }

    public static void createEmptyBlockedCraftJSON(File folder, String name) throws IOException {
        folder.mkdirs();
        JsonObject json = new JsonObject();
        JsonObject property = new JsonObject();
        property.addProperty("job", "HUNTER");
        property.addProperty("lvl", (Number)1);
        json.add("minecraft-diamond_pickaxe", (JsonElement)property);
        FileWriter writer = new FileWriter(new File(folder.getAbsolutePath() + "/" + name));
        new Gson().toJson((JsonElement)json, (Appendable)writer);
        writer.close();
        System.out.println(TextFormatting.BLUE + "[Jobs]" + TextFormatting.YELLOW + " Warning : File <" + name + "> not found. An empty file was created");
    }

    public static void loadBlockedCrafts() {
        try {
            File file = new File(LoadUtil.getDataFolder() + "/blockedcraft.json");
            if (!file.exists()) {
                LoadUtil.createEmptyBlockedCraftJSON(new File(LoadUtil.getDataFolder()), "blockedcraft.json");
                return;
            }
            JsonObject json = (JsonObject)new JsonParser().parse((Reader)new FileReader(file));
            for (Map.Entry entry : json.entrySet()) {
                String name = ((String)entry.getKey()).replace('-', ':');
                JsonObject property = ((JsonElement)entry.getValue()).getAsJsonObject();
                int level = property.get("lvl").getAsInt();
                GainXPUtil.CRAFT_UNLOCK_JOB.put(Item.func_111206_d((String)name), Constants.Job.valueOf(property.get("job").getAsString()));
                GainXPUtil.CRAFT_UNLOCK_LVL.put(Item.func_111206_d((String)name), level);
            }
        }
        catch (IOException e) {
            System.out.println(TextFormatting.RED + "[Jobs] Failed to load Blocked Crafts !");
        }
    }

    public static void loadRewards() {
        try {
            File file = new File(LoadUtil.getDataFolder() + "/rewards.json");
            if (!file.exists()) {
                LoadUtil.createEmptyRewardJSON(new File(LoadUtil.getDataFolder()), "rewards.json");
                return;
            }
            JsonObject json = (JsonObject)new JsonParser().parse((Reader)new FileReader(file));
            for (Map.Entry entry : json.entrySet()) {
                Constants.Job job = Constants.Job.valueOf((String)entry.getKey());
                for (Map.Entry entry2 : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                    int lvl = Integer.parseInt((String)entry2.getKey());
                    JsonArray array = ((JsonElement)entry2.getValue()).getAsJsonArray();
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    for (JsonElement e : array) {
                        ItemStack stack = new ItemStack(Item.func_111206_d((String)e.getAsJsonObject().get("item").getAsString().replace('-', ':')), e.getAsJsonObject().get("count").getAsInt());
                        list.add(stack);
                    }
                    switch (job) {
                        case HUNTER: {
                            GainXPUtil.REWARDS_WARRIOR.put(lvl, list);
                        }
                        case MAGICIAN: {
                            GainXPUtil.REWARDS_WIZARD.put(lvl, list);
                        }
                        case FARMER: {
                            GainXPUtil.REWARDS_HERBALIST.put(lvl, list);
                        }
                        case MINER: {
                            GainXPUtil.REWARDS_MINER.put(lvl, list);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            System.out.println(TextFormatting.RED + "[Jobs] Failed to load Rewards !");
        }
    }
}

