/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import journeymap.client.JourneymapClient;
import journeymap.client.feature.FeatureManager;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.network.data.model.ClientState;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.ServerOption;
import net.minecraft.client.Minecraft;

public class InternalStateHandler {
    private boolean journeyMapServerConnection = false;
    private boolean forgeServerConnection = false;
    private boolean playerTrackingEnabled = false;
    private boolean teleportEnabled = false;
    private boolean serverAdmin = false;
    private boolean useServerFullscreenBiomes = false;
    private boolean allowDeathPoints = true;

    public void setStates(ClientState state) {
        GlobalProperties prop = (GlobalProperties)new GlobalProperties().loadForClient(state.getPayload(), false);
        JourneymapClient.getInstance().getStateHandler().setForgeServerConnection(true);
        JourneymapClient.getInstance().getStateHandler().setJourneyMapServerConnection(true);
        JourneymapClient.getInstance().getStateHandler().setTeleportEnabled(prop.teleportEnabled.get());
        JourneymapClient.getInstance().getStateHandler().setPlayerTrackingEnabled(((ServerOption)prop.worldPlayerRadar.get()).enabled());
        JourneymapClient.getInstance().getStateHandler().setServerAdmin(state.isServerAdmin());
        JourneymapClient.getInstance().getStateHandler().setUseServerFullscreenBiomes(prop.useServerFullscreenBiomes.get());
        JourneymapClient.getInstance().getStateHandler().setAllowDeathPoints(prop.allowDeathPoints.get());
        FeatureManager.getInstance().updateDimensionFeatures(prop);
    }

    public void reset() {
        this.journeyMapServerConnection = false;
        this.forgeServerConnection = false;
        this.playerTrackingEnabled = false;
        this.teleportEnabled = false;
        this.serverAdmin = false;
        this.useServerFullscreenBiomes = false;
        this.allowDeathPoints = true;
        FeatureManager.getInstance().reset();
    }

    public boolean isAllowDeathPoints() {
        return this.allowDeathPoints;
    }

    private void setAllowDeathPoints(boolean allowDeathPoints) {
        this.allowDeathPoints = allowDeathPoints;
        if (!allowDeathPoints) {
            Journeymap.getLogger().debug("Death Points disabled by the server, deleting existing.");
            WaypointStore.INSTANCE.getAll().removeIf(waypoint -> Waypoint.Type.Death.equals((Object)waypoint.getType()));
        }
    }

    public boolean isForgeServerConnection() {
        return this.forgeServerConnection;
    }

    public void setForgeServerConnection(boolean forgeServerConnection) {
        this.forgeServerConnection = forgeServerConnection;
    }

    public boolean isJourneyMapServerConnection() {
        return this.journeyMapServerConnection;
    }

    public void setJourneyMapServerConnection(boolean journeyMapServerConnection) {
        Journeymap.getLogger().debug("Connection initiated with Journeymap Server: " + journeyMapServerConnection);
        this.journeyMapServerConnection = journeyMapServerConnection;
    }

    public boolean isPlayerTrackingEnabled() {
        return this.playerTrackingEnabled;
    }

    private void setPlayerTrackingEnabled(boolean playerTrackingEnabled) {
        if (Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().func_147104_D() != null && Minecraft.func_71410_x().func_147104_D().func_181041_d()) {
            this.playerTrackingEnabled = false;
            return;
        }
        Journeymap.getLogger().debug("Expanded Radar Enabled:" + playerTrackingEnabled);
        this.playerTrackingEnabled = playerTrackingEnabled;
    }

    public boolean isTeleportEnabled() {
        return this.teleportEnabled;
    }

    public void setTeleportEnabled(boolean teleportEnabled) {
        Journeymap.getLogger().debug("Teleport Enabled:" + teleportEnabled);
        this.teleportEnabled = teleportEnabled;
    }

    public boolean isServerAdmin() {
        return this.serverAdmin;
    }

    public boolean canServerAdmin() {
        return this.serverAdmin || Minecraft.func_71410_x().func_71356_B();
    }

    private void setServerAdmin(boolean serverAdmin) {
        Journeymap.getLogger().debug("Server Admin Enabled:" + serverAdmin);
        this.serverAdmin = serverAdmin;
    }

    public boolean useServerFullscreenBiomes() {
        return this.useServerFullscreenBiomes;
    }

    private void setUseServerFullscreenBiomes(boolean useServerFullscreenBiomes) {
        this.useServerFullscreenBiomes = useServerFullscreenBiomes;
    }
}

