/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.ScrollPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DropDownButton
extends Button {
    private static final int MAX_DISPLAY_SIZE = 6;
    private ScrollPane scrollPane;
    private boolean visible = false;
    private DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected Button.IPressable field_230697_t_;
    protected String glyphClosed = "\u25b6";
    protected String glyphDown = "\u25bc";
    protected String glyphUp = "\u25b2";

    public DropDownButton(String label, Button.IPressable onPress) {
        super(label, DropDownButton.emptyPressable());
        this.field_230697_t_ = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.func_230998_h_();
        this.scrollPane = new ScrollPane(null, Minecraft.func_71410_x(), 0, 0, items, items.get(0).func_238483_d_(), 2);
        this.scrollPane.setDrawPartialScrollable(false);
        this.scrollPane.func_230943_a_(false);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.scrollPane.func_231044_a_(mouseX, mouseY, button);
        Button pressed = this.scrollPane.mouseClicked((int)mouseX, (int)mouseX, button);
        this.scrollPane.field_230681_r_ = false;
        boolean mouseOver = this.scrollPane.func_231047_b_(mouseX, mouseY);
        if (mouseOver) {
            this.scrollPane.func_230947_b_(mouseX, mouseY, button);
        }
        if ((this.visible && pressed == null && !mouseOver || !this.isEnabled() && pressed != null) && !this.scrollPane.field_230681_r_) {
            this.visible = false;
            this.setEnabled(true);
            return true;
        }
        if (mouseOver) {
            return true;
        }
        boolean buttonClicked = super.func_231044_a_(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.visible = true;
            this.setEnabled(false);
            return true;
        }
        return buttonClicked;
    }

    public boolean mouseOverPane(double x, double y) {
        return this.scrollPane.func_231047_b_(x, y);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        if (this.scrollPane.func_231047_b_(x, y)) {
            return this.scrollPane.func_231043_a_(x, y, scroll);
        }
        return super.func_231043_a_(x, y, scroll);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.scrollPane.func_231048_c_(mouseX, mouseY, mouseButton);
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean func_230449_g_() {
        return super.func_230449_g_();
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.scrollPane.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.scrollPane.func_212927_b(mouseX, mouseY);
        super.func_212927_b(mouseX, mouseY);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.scrollPane.func_223281_a_(keyCode, scanCode, modifiers);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.scrollPane.setDimensions(this.paneWidth - 6, this.getPaneHeight(), 0, 0, this.field_230690_l_ + 2, this.field_230691_m_ - this.scrollPane.paneHeight - 10);
            this.scrollPane.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
        DrawUtil.drawLabel(mStack, this.visible ? this.glyphUp : this.glyphClosed, this.getX() + 16, this.getMiddleY() - 1, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, this.visible ? this.disabledLabelColor : this.getLabelColor(), this.visible ? 0.25f : 1.0f, 1.5, true);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
    }

    private int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).func_238483_d_() + 4);
    }

    public int func_230998_h_() {
        int width = 0;
        if (this.items != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (DropDownItem item : this.items) {
                int newWidth = fontRenderer.func_78256_a(item.getLabel());
                if (newWidth <= width) continue;
                width = newWidth;
            }
            this.field_230688_j_ = width + 50;
        }
        return this.field_230688_j_;
    }

    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.field_230697_t_.onPress((net.minecraft.client.gui.widget.button.Button)selected);
        this.func_238482_a_((ITextComponent)new StringTextComponent(selected.getLabel()));
    }

    public DropDownItem getSelected() {
        return this.selected;
    }

    public String getSelectedLabel() {
        return this.selected.getLabel();
    }
}

