/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.Overlay;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.UIState;
import journeymap.client.data.DataCache;
import journeymap.client.data.WaypointsData;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.MapSaver;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.map.RegionRenderer;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.task.main.EnsureCurrentColorsTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.task.multi.SaveMapTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.TextBoxButton;
import journeymap.client.ui.dialog.AutoMapConfirmation;
import journeymap.client.ui.dialog.DeleteMapConfirmation;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.fullscreen.MapChat;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Fullscreen
extends JmUI {
    private long lastGridUpdate = 0L;
    private static final MapState state = new MapState();
    private static final GridRenderer gridRenderer = new GridRenderer(Context.UI.Fullscreen);
    private final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    private final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    private final LayerDelegate layerDelegate;
    private FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
    private CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
    private boolean firstLayoutPass = true;
    private Boolean isScrolling = false;
    private int msx;
    private int msy;
    private int mx;
    private int my;
    private Logger logger = Journeymap.getLogger();
    private MapChat chat;
    private ThemeButton buttonFollow;
    private ThemeButton buttonZoomIn;
    private ThemeButton buttonZoomOut;
    private ThemeButton buttonSearch;
    private TextBoxButton searchTextX;
    private TextBoxButton searchTextZ;
    private ThemeButton buttonExecuteSearch;
    private ThemeToolbar searchToolBar;
    private ThemeButton buttonDay;
    private ThemeButton buttonNight;
    private ThemeButton buttonTopo;
    private ThemeButton buttonLayers;
    private ThemeButton buttonCaves;
    private ThemeButton buttonAlert;
    private ThemeButton buttonOptions;
    private ThemeButton buttonClose;
    private ThemeButton buttonTheme;
    private ThemeButton buttonWaypointManager;
    private ThemeButton buttonMobs;
    private ThemeButton buttonAnimals;
    private ThemeButton buttonPets;
    private ThemeButton buttonVillagers;
    private ThemeButton buttonPlayers;
    private ThemeButton buttonGrid;
    private ThemeButton buttonKeys;
    private ThemeButton buttonAutomap;
    private ThemeButton buttonSavemap;
    private ThemeButton buttonDeletemap;
    private ThemeButton buttonDisable;
    private ThemeButton buttonResetPalette;
    private ThemeButton buttonBrowser;
    private ThemeButton buttonAbout;
    ThemeButton overlayRenderButton;
    private ThemeToolbar mapTypeToolbar;
    private ThemeToolbar optionsToolbar;
    private ThemeToolbar menuToolbar;
    private ThemeToolbar zoomToolbar;
    private int bgColor = 0x222222;
    private Theme.LabelSpec statusLabelSpec;
    private StatTimer renderTimer = StatTimer.get("Fullscreen.render");
    private StatTimer drawMapTimer = StatTimer.get("Fullscreen.render.drawMap", 50);
    private StatTimer drawMapTimerWithRefresh = StatTimer.get("Fullscreen.drawMap+refreshState", 5);
    private LocationFormat locationFormat = new LocationFormat();
    private List<Overlay> tempOverlays = new ArrayList<Overlay>();
    private IntSliderButton sliderCaveLayer;
    private List<IReorderingProcessor> autoMapOnTooltip;
    private List<IReorderingProcessor> autoMapOffTooltip;
    private Rectangle2D.Double mapTypeToolbarBounds;
    private Rectangle2D.Double optionsToolbarBounds;
    private Rectangle2D.Double menuToolbarBounds;
    private Minecraft minecraft = Minecraft.func_71410_x();
    private boolean chatOpenedFromEvent = false;

    public Fullscreen() {
        super(null);
        gridRenderer.setGridSize(Fullscreen.getCalculatedGridSize());
        gridRenderer.clear();
        this.layerDelegate = new LayerDelegate(this);
        if (JourneymapClient.getInstance().getFullMapProperties().showCaves.get().booleanValue() && DataCache.getPlayer().underground.booleanValue() && Fullscreen.state.follow.get() && FeatureManager.getInstance().isAllowed(Feature.MapCaves)) {
            state.setMapType(MapType.underground(DataCache.getPlayer()));
        }
    }

    public static synchronized MapState state() {
        return state;
    }

    public static synchronized UIState uiState() {
        return gridRenderer.getUIState();
    }

    public void reset() {
        this.isScrolling = false;
        gridRenderer.setGridSize(Fullscreen.getCalculatedGridSize());
        state.requireRefresh();
        gridRenderer.clear();
        this.field_230710_m_.clear();
    }

    @Override
    public void func_231160_c_() {
        this.fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        state.requireRefresh();
        state.refresh(this.minecraft, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.fullMapProperties);
        MapType mapType = state.getMapType();
        this.minecraft.field_195559_v.func_197967_a(true);
        if (!mapType.dimension.equals((Object)this.minecraft.field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a())) {
            gridRenderer.clear();
        }
        this.initButtons();
        String thisVersion = Journeymap.JM_VERSION.toString();
        String splashViewed = JourneymapClient.getInstance().getCoreProperties().splashViewed.get();
        if (splashViewed == null || !thisVersion.equals(splashViewed)) {
            UIManager.INSTANCE.openSplash(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_230430_a_(MatrixStack mStack, int width, int height, float f) {
        try {
            this.func_238651_a_(mStack, 0);
            this.drawMap(mStack);
            this.drawLogo(mStack);
            this.renderTimer.start();
            this.layoutButtons(mStack);
            List<IReorderingProcessor> tooltip = null;
            if (this.firstLayoutPass) {
                this.layoutButtons(mStack);
                this.updateMapType(state.getMapType());
                this.firstLayoutPass = false;
            } else {
                for (int k = 0; k < this.field_230710_m_.size(); ++k) {
                    Button button;
                    net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.field_230710_m_.get(k);
                    guibutton.func_230430_a_(mStack, width, height, f);
                    if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(this.mx, this.my)) continue;
                    tooltip = button.getTooltip();
                }
            }
            if (this.chat != null) {
                this.chat.func_230430_a_(mStack, width, height, f);
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(mStack, tooltip, this.mx, this.my, this.getFontRenderer());
                RenderHelper.func_74518_a();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "Unexpected exception in jm.fullscreen.render(): " + LogFormatter.toString(e));
            UIManager.INSTANCE.closeAll();
        }
        finally {
            this.renderTimer.stop();
        }
    }

    private static int getCalculatedGridSize() {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        int screenWidth = mainWindow != null ? mainWindow.func_198109_k() : 1920;
        int gridSize = 0;
        while (gridSize * 512 < screenWidth) {
            ++gridSize;
        }
        if (++gridSize % 2 == 0) {
            ++gridSize;
        }
        return gridSize;
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        super.func_231152_a_(minecraft, width, height);
        gridRenderer.setGridSize(Fullscreen.getCalculatedGridSize());
        gridRenderer.clear();
    }

    @Override
    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        state.requireRefresh();
        if (this.chat == null) {
            this.chat = new MapChat("", true);
        }
        if (this.chat != null) {
            this.chat.func_231158_b_(minecraft, width, height);
        }
        this.func_231160_c_();
        this.refreshState();
    }

    void initButtons() {
        if (this.field_230710_m_.isEmpty()) {
            this.firstLayoutPass = true;
            Theme theme = ThemeLoader.getCurrentTheme();
            MapType mapType = state.getMapType();
            this.bgColor = theme.fullscreen.background.getColor();
            this.statusLabelSpec = theme.fullscreen.statusLabel;
            this.buttonDay = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.fullscreen.map_day", "day", button -> {
                if (this.buttonDay.isEnabled()) {
                    this.updateMapType(MapType.day(state.getDimension()));
                }
            }));
            this.buttonDay.setToggled(mapType.isDay(), false);
            this.buttonDay.setStaysOn(true);
            this.buttonNight = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.fullscreen.map_night", "night", button -> {
                if (this.buttonNight.isEnabled()) {
                    this.updateMapType(MapType.night(state.getDimension()));
                }
            }));
            this.buttonNight.setToggled(mapType.isNight(), false);
            this.buttonNight.setStaysOn(true);
            this.buttonTopo = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.fullscreen.map_topo", "topo", button -> {
                if (this.buttonTopo.isEnabled()) {
                    this.updateMapType(MapType.topo(state.getDimension()));
                }
            }));
            this.buttonTopo.setDrawButton(this.coreProperties.mapTopography.get());
            this.buttonTopo.setToggled(mapType.isTopo(), false);
            this.buttonTopo.setStaysOn(true);
            this.buttonLayers = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.fullscreen.map_cave_layers", "layers", button -> {
                EntityDTO player = DataCache.getPlayer();
                this.buttonLayers.toggle();
                this.sliderCaveLayer.setDrawButton(this.buttonLayers.getToggled());
            }));
            this.buttonLayers.setEnabled(FeatureManager.getInstance().isAllowed(Feature.MapCaves));
            FontRenderer fontRenderer = this.getFontRenderer();
            this.sliderCaveLayer = (IntSliderButton)this.func_230480_a_((Widget)new IntSliderButton(state.getLastSlice(), Constants.getString("jm.fullscreen.map_cave_layers.button") + " ", ""));
            this.sliderCaveLayer.func_230991_b_(this.sliderCaveLayer.getFitWidth(fontRenderer) + fontRenderer.func_78256_a("0"));
            this.sliderCaveLayer.setDefaultStyle(false);
            this.sliderCaveLayer.setDrawBackground(true);
            Theme.Control.ButtonSpec buttonSpec = this.buttonLayers.getButtonSpec();
            this.sliderCaveLayer.setBackgroundColors(buttonSpec.buttonDisabled.getColor(), buttonSpec.buttonOff.getColor(), buttonSpec.buttonOff.getColor());
            this.sliderCaveLayer.setLabelColors(buttonSpec.iconHoverOff.getColor(), buttonSpec.iconHoverOn.getColor(), buttonSpec.iconDisabled.getColor());
            this.sliderCaveLayer.setDrawButton(false);
            this.sliderCaveLayer.addClickListener(button -> {
                state.setMapType(MapType.underground(this.sliderCaveLayer.getValue(), state.getDimension()));
                this.refreshState();
                return true;
            });
            this.field_230710_m_.add(this.sliderCaveLayer);
            this.buttonSearch = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.fullscreen.search", "search", button -> {
                this.buttonSearch.toggle();
                this.toggleSearchBar(this.buttonSearch.getToggled());
            }));
            this.searchTextX = (TextBoxButton)this.func_230480_a_((Widget)new TextBoxButton("x:", fontRenderer, 40, 20, true, true));
            this.searchTextZ = (TextBoxButton)this.func_230480_a_((Widget)new TextBoxButton("z:", fontRenderer, 40, 20, true, true));
            this.buttonExecuteSearch = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.fullscreen.search_execute", "follow", button -> this.executeSearch()));
            this.searchTextX.setVisible(false);
            this.searchTextZ.setVisible(false);
            this.buttonExecuteSearch.setVisible(false);
            this.buttonFollow = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.fullscreen.follow", "follow", button -> this.toggleFollow()));
            this.buttonZoomIn = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.fullscreen.zoom_in", "zoomin", button -> this.zoomIn()));
            this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
            this.buttonZoomIn.setDisplayClickToggle(false);
            this.buttonZoomOut = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.fullscreen.zoom_out", "zoomout", button -> this.zoomOut()));
            this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
            this.buttonZoomOut.setDisplayClickToggle(false);
            this.buttonWaypointManager = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.waypoint.waypoints_button", "waypoints", button -> UIManager.INSTANCE.openWaypointManager(null, this)));
            this.buttonWaypointManager.setDrawButton(WaypointsData.isManagerEnabled());
            this.buttonTheme = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.ui_theme", "theme", button -> {
                ThemeLoader.loadNextTheme();
                UIManager.INSTANCE.getMiniMap().reset();
                this.field_230710_m_.clear();
            }));
            Style italic = Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true));
            IReorderingProcessor[] tooltips = new IReorderingProcessor[]{Constants.getFormattedText(Constants.getString("jm.common.ui_theme_name", theme.name), italic, fontRenderer, 200), Constants.getFormattedText(Constants.getString("jm.common.ui_theme_author", theme.author), italic, fontRenderer, 200)};
            this.buttonTheme.setAdditionalTooltips(Arrays.asList(tooltips));
            this.buttonOptions = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.options_button", "options", button -> {
                try {
                    UIManager.INSTANCE.openOptionsManager(this, new Category[0]);
                    this.field_230710_m_.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
            String versionAvailable = Constants.getString("jm.common.new_version_available", VersionCheck.getVersionAvailable());
            this.buttonAlert = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, versionAvailable, versionAvailable, false, "alert", button -> {
                FullscreenActions.launchDownloadWebsite();
                this.buttonAlert.setDrawButton(false);
            }));
            this.buttonAlert.setDrawButton(VersionCheck.getVersionIsChecked() != false && VersionCheck.getVersionIsCurrent() == false);
            this.buttonAlert.setToggled(true);
            this.buttonClose = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.close", "close", button -> UIManager.INSTANCE.closeAll()));
            this.buttonCaves = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_caves", "caves", this.fullMapProperties.showCaves, button -> {
                EntityDTO player = DataCache.getPlayer();
                this.buttonCaves.setToggled(this.buttonCaves.getToggled() == false);
                if (this.buttonCaves.getToggled().booleanValue()) {
                    this.updateMapType(MapType.underground(player));
                } else {
                    this.updateMapType(MapType.day(player));
                }
            }));
            this.buttonCaves.setTooltip(Constants.getString("jm.common.show_caves.tooltip"));
            this.buttonCaves.setDrawButton(state.isCaveMappingAllowed());
            this.buttonMobs = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_mobs", "monsters", this.fullMapProperties.showMobs, button -> this.buttonMobs.toggle()));
            this.buttonMobs.setTooltip(Constants.getString("jm.common.show_mobs.tooltip"));
            this.buttonMobs.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarMobs));
            this.buttonAnimals = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_animals", "animals", this.fullMapProperties.showAnimals, button -> this.buttonAnimals.toggle()));
            this.buttonAnimals.setTooltip(Constants.getString("jm.common.show_animals.tooltip"));
            this.buttonAnimals.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarAnimals));
            this.buttonPets = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_pets", "pets", this.fullMapProperties.showPets, button -> this.buttonPets.toggle()));
            this.buttonPets.setTooltip(Constants.getString("jm.common.show_pets.tooltip"));
            this.buttonPets.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarAnimals));
            this.buttonVillagers = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_villagers", "villagers", this.fullMapProperties.showVillagers, button -> this.buttonVillagers.toggle()));
            this.buttonVillagers.setTooltip(Constants.getString("jm.common.show_villagers.tooltip"));
            this.buttonVillagers.setDrawButton(FeatureManager.getInstance().isAllowed(Feature.RadarVillagers));
            this.buttonPlayers = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_players", "players", this.fullMapProperties.showPlayers, button -> this.buttonPlayers.toggle()));
            this.buttonPlayers.setTooltip(Constants.getString("jm.common.show_players.tooltip"));
            this.buttonPlayers.setDrawButton(!this.minecraft.func_71356_B() && FeatureManager.getInstance().isAllowed(Feature.RadarPlayers));
            this.buttonGrid = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_grid", "grid", this.fullMapProperties.showGrid, button -> {
                boolean shiftDown;
                this.buttonGrid.toggle();
                boolean bl = shiftDown = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
                if (shiftDown) {
                    UIManager.INSTANCE.openGridEditor(this);
                    this.buttonGrid.setValue(true);
                }
            }));
            this.buttonGrid.setTooltip(Constants.getString("jm.common.show_grid_shift.tooltip"));
            this.buttonGrid.setTooltip(Constants.getString("jm.common.show_grid_shift.tooltip"));
            this.buttonKeys = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.show_keys", "keys", this.fullMapProperties.showKeys, button -> this.buttonKeys.toggle()));
            this.buttonKeys.setTooltip(Constants.getString("jm.common.show_keys.tooltip"));
            this.buttonAbout = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.splash_about", "about", button -> UIManager.INSTANCE.openSplash(this)));
            this.overlayRenderButton = new ThemeButton(theme, "region display on", " region display off", false, "server", button -> RegionRenderer.render(!RegionRenderer.TOGGLED));
            this.func_230480_a_((Widget)this.overlayRenderButton);
            this.buttonSavemap = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.save_map", "savemap", button -> {
                this.buttonSavemap.setEnabled(false);
                try {
                    MapSaver mapSaver = new MapSaver(state.getWorldDir(), state.getMapType());
                    if (mapSaver.isValid()) {
                        JourneymapClient.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
                        ChatLog.announceI18N("jm.common.save_filename", mapSaver.getSaveFileName());
                    }
                }
                finally {
                    this.buttonSavemap.setToggled(false);
                    this.buttonSavemap.setEnabled(true);
                }
            }));
            this.buttonBrowser = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.use_browser", "browser", button -> FullscreenActions.launchLocalhost()));
            boolean webMapEnabled = JourneymapClient.getInstance().getWebMapProperties().enabled.get();
            this.buttonBrowser.setEnabled(webMapEnabled);
            this.buttonBrowser.setDrawButton(webMapEnabled);
            boolean automapRunning = JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
            String autoMapOn = Constants.getString("jm.common.automap_stop_title");
            String autoMapOff = Constants.getString("jm.common.automap_title");
            this.autoMapOnTooltip = fontRenderer.func_238425_b_((ITextProperties)Constants.getTranslatedTextComponent("jm.common.automap_stop_text"), 200);
            this.autoMapOffTooltip = fontRenderer.func_238425_b_((ITextProperties)Constants.getTranslatedTextComponent("jm.common.automap_text"), 200);
            this.buttonAutomap = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, autoMapOn, autoMapOff, "automap", button -> {
                if (!this.buttonAutomap.getToggled().booleanValue()) {
                    UIManager.INSTANCE.open(AutoMapConfirmation.class, this);
                } else {
                    JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, false, null);
                    this.buttonAutomap.setToggled(false, false);
                    this.field_230710_m_.clear();
                }
            }));
            this.buttonAutomap.setEnabled(Minecraft.func_71410_x().func_71356_B() && JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get() != false);
            this.buttonAutomap.setToggled(automapRunning, false);
            this.buttonDeletemap = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.deletemap_title", "delete", button -> UIManager.INSTANCE.open(DeleteMapConfirmation.class, this)));
            this.buttonDeletemap.setAdditionalTooltips(fontRenderer.func_238425_b_((ITextProperties)Constants.getTranslatedTextComponent("jm.common.deletemap_text"), 200));
            this.buttonDisable = (ThemeButton)this.func_230480_a_((Widget)new ThemeToggle(theme, "jm.common.enable_mapping_false", "disable", button -> {
                this.buttonDisable.toggle();
                JourneymapClient.getInstance().getCoreProperties().mappingEnabled.set(this.buttonDisable.getToggled() == false);
                if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                    DataCache.INSTANCE.invalidateChunkMDCache();
                    ChatLog.announceI18N("jm.common.enable_mapping_true_text", new Object[0]);
                } else {
                    JourneymapClient.getInstance().stopMapping();
                    BlockMD.reset();
                    ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
                }
            }));
            this.buttonResetPalette = (ThemeButton)this.func_230480_a_((Widget)new ThemeButton(theme, "jm.common.colorreset_title", "reset", button -> JourneymapClient.getInstance().queueMainThreadTask(new EnsureCurrentColorsTask(true, true))));
            this.buttonResetPalette.setAdditionalTooltips(fontRenderer.func_238425_b_((ITextProperties)Constants.getTranslatedTextComponent("jm.common.colorreset_text"), 200));
            this.mapTypeToolbar = new ThemeToolbar(theme, this.buttonLayers, this.buttonTopo, this.buttonNight, this.buttonDay);
            this.mapTypeToolbar.addAllButtons(this);
            this.optionsToolbar = new ThemeToolbar(theme, this.buttonCaves, this.buttonMobs, this.buttonAnimals, this.buttonPets, this.buttonVillagers, this.buttonPlayers, this.buttonGrid, this.buttonKeys);
            this.optionsToolbar.addAllButtons(this);
            this.optionsToolbar.field_230694_p_ = false;
            this.menuToolbar = new ThemeToolbar(theme, this.buttonWaypointManager, this.buttonOptions, this.buttonAbout, this.buttonBrowser, this.buttonTheme, this.buttonResetPalette, this.buttonDeletemap, this.buttonSavemap, this.buttonAutomap, this.buttonDisable, this.overlayRenderButton);
            this.menuToolbar.addAllButtons(this);
            this.menuToolbar.field_230694_p_ = false;
            this.zoomToolbar = new ThemeToolbar(theme, this.buttonSearch, this.buttonFollow, this.buttonZoomIn, this.buttonZoomOut);
            this.zoomToolbar.setLayout(ButtonList.Layout.Vertical, ButtonList.Direction.LeftToRight);
            this.zoomToolbar.addAllButtons(this);
            this.searchToolBar = new ThemeToolbar(theme, this.searchTextX, this.searchTextZ, this.buttonExecuteSearch);
            this.searchToolBar.setLayout(ButtonList.Layout.CenteredHorizontal, ButtonList.Direction.LeftToRight);
            this.searchToolBar.addAllButtons(this);
            this.field_230710_m_.add(this.buttonAlert);
            this.field_230710_m_.add(this.buttonClose);
        }
    }

    @Override
    protected void layoutButtons(MatrixStack mStack) {
        this.mx = (int)(this.minecraft.field_71417_B.func_198024_e() * (double)this.field_230708_k_ / (double)this.minecraft.func_228018_at_().func_198105_m());
        this.my = (int)(this.minecraft.field_71417_B.func_198026_f() * (double)this.field_230709_l_ / (double)this.minecraft.func_228018_at_().func_198083_n() - 1.0);
        if (this.buttonDay != null && !this.buttonDay.hasValidTextures()) {
            this.field_230710_m_.clear();
        }
        if (this.field_230710_m_.isEmpty()) {
            this.initButtons();
        }
        this.menuToolbar.setDrawToolbar(!this.isChatOpen());
        MapType mapType = state.getMapType();
        this.buttonDay.setEnabled(state.isSurfaceMappingAllowed());
        this.buttonDay.setToggled(this.buttonDay.isEnabled() && mapType.isDay());
        this.buttonNight.setEnabled(state.isSurfaceMappingAllowed());
        this.buttonNight.setToggled(this.buttonNight.isEnabled() && mapType.isNight());
        this.buttonTopo.setEnabled(state.isTopoMappingAllowed());
        this.buttonTopo.setToggled(this.buttonTopo.isEnabled() && mapType.isTopo());
        this.buttonCaves.setEnabled(state.isCaveMappingAllowed());
        this.buttonCaves.setToggled(this.buttonCaves.isEnabled() && mapType.isUnderground());
        this.buttonFollow.setEnabled(!Fullscreen.state.follow.get());
        boolean automapRunning = JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
        boolean mappingEnabled = JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get();
        this.buttonDisable.setToggled(!mappingEnabled, false);
        this.buttonAutomap.setToggled(automapRunning, false);
        this.buttonAutomap.setEnabled(mappingEnabled);
        this.buttonAutomap.setAdditionalTooltips(automapRunning ? this.autoMapOnTooltip : this.autoMapOffTooltip);
        boolean webMapEnabled = JourneymapClient.getInstance().getWebMapProperties().enabled.get();
        this.buttonBrowser.setEnabled(webMapEnabled && mappingEnabled);
        this.buttonBrowser.setDrawButton(webMapEnabled);
        boolean mainThreadActive = JourneymapClient.getInstance().isMainThreadTaskActive();
        this.buttonResetPalette.setEnabled(!mainThreadActive && mappingEnabled);
        this.buttonDeletemap.setEnabled(!mainThreadActive);
        this.buttonDisable.setEnabled(!mainThreadActive);
        this.overlayRenderButton.setVisible(System.getProperty("journeymap.map_testing") != null);
        int padding = this.mapTypeToolbar.getToolbarSpec().padding;
        this.zoomToolbar.layoutCenteredVertical(this.zoomToolbar.getHMargin(), this.field_230709_l_ / 2, true, padding);
        this.searchToolBar.layoutHorizontal(this.zoomToolbar.getRightX() + 2, this.zoomToolbar.getY() + 1, true, 7, true);
        this.searchTextX.setX(this.searchTextX.getX() + 3);
        this.searchTextZ.setX(this.searchTextZ.getX() + 2);
        this.buttonExecuteSearch.setDisplayClickToggle(false);
        int topY = this.mapTypeToolbar.getVMargin();
        int margin = this.mapTypeToolbar.getHMargin();
        this.buttonClose.leftOf(this.field_230708_k_ - this.zoomToolbar.getHMargin()).below(this.mapTypeToolbar.getVMargin());
        this.buttonAlert.leftOf(this.field_230708_k_ - this.zoomToolbar.getHMargin()).below(this.buttonClose, padding);
        int toolbarsWidth = this.mapTypeToolbar.func_230998_h_() + this.optionsToolbar.func_230998_h_() + margin + padding;
        int startX = (this.field_230708_k_ - toolbarsWidth) / 2;
        Rectangle2D.Double oldBounds = this.mapTypeToolbar.getBounds();
        this.mapTypeToolbar.layoutHorizontal(startX + this.mapTypeToolbar.func_230998_h_(), topY, false, padding);
        if (!this.mapTypeToolbar.getBounds().equals(oldBounds)) {
            this.mapTypeToolbarBounds = null;
        }
        oldBounds = this.optionsToolbar.getBounds();
        this.optionsToolbar.layoutHorizontal(this.mapTypeToolbar.getRightX() + margin, topY, true, padding);
        this.optionsToolbar.field_230694_p_ = true;
        if (!this.optionsToolbar.getBounds().equals(oldBounds)) {
            this.optionsToolbarBounds = null;
        }
        oldBounds = this.menuToolbar.getBounds();
        this.menuToolbar.layoutCenteredHorizontal(this.field_230708_k_ / 2, this.field_230709_l_ - this.menuToolbar.func_238483_d_() - this.menuToolbar.getVMargin(), true, padding);
        if (!this.menuToolbar.getBounds().equals(oldBounds)) {
            this.menuToolbarBounds = null;
        }
        if (this.sliderCaveLayer.isVisible()) {
            this.sliderCaveLayer.below(this.buttonLayers, 1).centerHorizontalOn(this.buttonLayers.getCenterX());
            int slice = this.sliderCaveLayer.getValue();
            int minY = Math.max(slice << 4, 0);
            int maxY = (slice + 1 << 4) - 1;
            this.sliderCaveLayer.setTooltip(Constants.getString("jm.fullscreen.map_cave_layers.button.tooltip", minY, maxY));
        }
    }

    @Nullable
    public Rectangle2D.Double getOptionsToolbarBounds() {
        if (this.optionsToolbar != null && this.optionsToolbar.isVisible()) {
            Rectangle2D.Double unscaled = this.optionsToolbar.getBounds();
            this.optionsToolbarBounds = new Rectangle2D.Double(unscaled.x * (double)this.scaleFactor, unscaled.y * (double)this.scaleFactor, unscaled.width * (double)this.scaleFactor, unscaled.height * (double)this.scaleFactor);
        }
        return this.optionsToolbarBounds;
    }

    @Nullable
    public Rectangle2D.Double getMenuToolbarBounds() {
        if (this.menuToolbar != null && this.menuToolbar.isVisible()) {
            Rectangle2D.Double unscaled = this.menuToolbar.getBounds();
            this.menuToolbarBounds = new Rectangle2D.Double(unscaled.x * (double)this.scaleFactor, unscaled.y * (double)this.scaleFactor, unscaled.width * (double)this.scaleFactor, unscaled.height * (double)this.scaleFactor);
        }
        return this.menuToolbarBounds;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double wheel) {
        try {
            if (wheel > 0.0) {
                this.zoomIn();
            } else if (wheel < 0.0) {
                this.zoomOut();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            return false;
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        try {
            if (this.chat != null && !this.chat.isHidden()) {
                this.chat.func_231044_a_(mouseX, mouseY, mouseButton);
            }
            Point2D.Double mousePosition = new Point2D.Double(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor);
            this.mx = (int)(this.minecraft.field_71417_B.func_198024_e() * (double)this.field_230708_k_ / (double)this.minecraft.func_228018_at_().func_198105_m());
            this.my = (int)(this.minecraft.field_71417_B.func_198026_f() * (double)this.field_230709_l_ / (double)this.minecraft.func_228018_at_().func_198083_n() - 1.0);
            if (!this.isMouseOverButton(mouseX, mouseY)) {
                this.layerDelegate.onMouseClicked(this.minecraft, gridRenderer, mousePosition, mouseButton, this.getMapFontScale());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        Point2D.Double mousePosition = new Point2D.Double(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor);
        this.layerDelegate.onMouseMove(this.minecraft, gridRenderer, mousePosition, this.getMapFontScale(), this.isScrolling);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        long sysTime;
        boolean updateGrid;
        if (this.sliderCaveLayer.dragging || !(this.minecraft.field_71462_r instanceof Fullscreen)) {
            this.isScrolling = false;
        }
        boolean bl = updateGrid = (sysTime = Util.func_211177_b()) - this.lastGridUpdate > 200L;
        if (button == 0 && this.isScrolling.booleanValue() && updateGrid) {
            this.lastGridUpdate = sysTime;
            this.updateGrid();
        }
        if (button == 0 && !this.isScrolling.booleanValue() && !this.isMouseOverButton(mouseX, mouseY)) {
            this.isScrolling = true;
            this.msx = this.mx;
            this.msy = this.my;
            this.minecraft.field_71417_B.func_198021_g();
            Point2D.Double mousePosition = new Point2D.Double(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor);
            this.layerDelegate.onMouseMove(this.minecraft, gridRenderer, mousePosition, this.getMapFontScale(), this.isScrolling);
        }
        return super.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    private void updateGrid() {
        int blockSize = (int)Math.pow(2.0, this.fullMapProperties.zoomLevel.get().intValue());
        int mouseDragX = (this.mx - this.msx) * Math.max(1, this.scaleFactor) / blockSize;
        int mouseDragY = (this.my - this.msy) * Math.max(1, this.scaleFactor) / blockSize;
        this.msx = this.mx;
        this.msy = this.my;
        try {
            gridRenderer.move(-mouseDragX, -mouseDragY);
            gridRenderer.updateTiles(state.getMapType(), state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), false, 0.0, 0.0);
            gridRenderer.setZoom(this.fullMapProperties.zoomLevel.get());
        }
        catch (Exception e) {
            this.logger.error("Error moving grid: " + e);
        }
        this.setFollow(false);
        this.refreshState();
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        try {
            super.func_231048_c_(mouseX, mouseY, button);
            if (this.sliderCaveLayer.isVisible()) {
                this.isScrolling = false;
                return true;
            }
            if (this.isScrolling.booleanValue()) {
                this.isScrolling = false;
                this.updateGrid();
            }
            Point2D.Double mousePosition = new Point2D.Double(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor);
            this.layerDelegate.onMouseMove(this.minecraft, gridRenderer, mousePosition, this.getMapFontScale(), this.isScrolling);
            return true;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            return false;
        }
    }

    public void toggleMapType() {
        this.updateMapType(state.toggleMapType());
    }

    private void updateMapType(MapType newType) {
        if (!newType.isAllowed()) {
            newType = state.getMapType();
        }
        state.setMapType(newType);
        this.buttonDay.setToggled(newType.isDay(), false);
        this.buttonNight.setToggled(newType.isNight(), false);
        this.buttonTopo.setToggled(newType.isTopo(), false);
        if (newType.isUnderground()) {
            this.sliderCaveLayer.setValue(newType.vSlice);
        }
        state.requireRefresh();
    }

    public void zoomIn() {
        if (this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom) {
            this.setZoom(this.fullMapProperties.zoomLevel.get() + 1);
        }
    }

    public void zoomOut() {
        if (this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom) {
            this.setZoom(this.fullMapProperties.zoomLevel.get() - 1);
        }
    }

    private void setZoom(int zoom) {
        if (state.setZoom(zoom)) {
            this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
            this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
            this.refreshState();
        }
    }

    public void toggleSearchBar(boolean toggled) {
        this.searchToolBar.setEnabled(toggled);
        this.searchToolBar.setVisible(toggled);
        this.buttonSearch.setToggled(toggled);
        this.searchTextZ.setVisible(toggled);
        this.searchTextX.setVisible(toggled);
        this.buttonExecuteSearch.setVisible(toggled);
    }

    void executeSearch() {
        this.buttonExecuteSearch.setToggled(true, false);
        try {
            int x = Integer.parseInt(this.searchTextX.getText());
            int z = Integer.parseInt(this.searchTextZ.getText());
            this.centerOn(x, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void toggleFollow() {
        boolean isFollow = !Fullscreen.state.follow.get();
        this.setFollow(isFollow);
        if (isFollow && this.minecraft.field_71439_g != null) {
            this.sliderCaveLayer.setValue(this.minecraft.field_71439_g.field_70162_ai);
            if (state.getMapType().isUnderground()) {
                this.sliderCaveLayer.checkClickListeners();
            }
        }
    }

    void setFollow(Boolean follow) {
        Fullscreen.state.follow.set(follow);
        if (follow.booleanValue()) {
            state.resetMapType();
            this.refreshState();
        }
    }

    public void createWaypointAtMouse() {
        Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_71417_B.func_198024_e(), this.minecraft.field_71417_B.func_198026_f());
        BlockPos blockPos = this.layerDelegate.getBlockPos(this.minecraft, gridRenderer, mousePosition);
        Waypoint waypoint = Waypoint.at(blockPos, Waypoint.Type.Normal, this.minecraft.field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().toString());
        UIManager.INSTANCE.openWaypointEditor(waypoint, true, this);
    }

    public void chatPositionAtMouse() {
        Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_71417_B.func_198024_e(), this.minecraft.field_71417_B.func_198026_f());
        BlockPos blockPos = this.layerDelegate.getBlockPos(this.minecraft, gridRenderer, mousePosition);
        Waypoint waypoint = Waypoint.at(blockPos, Waypoint.Type.Normal, state.getDimension().func_240901_a_().toString());
        this.chatOpenedFromEvent = true;
        this.openChat(waypoint.toChatString());
    }

    public boolean isChatOpen() {
        return this.chat != null && !this.chat.isHidden();
    }

    @Override
    public boolean func_231046_a_(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                if (this.isChatOpen()) {
                    this.chat.close();
                } else {
                    UIManager.INSTANCE.closeAll();
                }
                return true;
            }
        }
        if (this.minecraft.field_71474_y.field_74310_D.getKey().func_197937_c() == key && !this.isChatOpen()) {
            this.chatOpenedFromEvent = true;
            this.openChat("");
            return true;
        }
        if (this.minecraft.field_71474_y.field_74323_J.getKey().func_197937_c() == key && !this.isChatOpen()) {
            this.chatOpenedFromEvent = true;
            this.openChat("/");
            return true;
        }
        if (this.isChatOpen()) {
            this.chat.func_231046_a_(key, value, modifier);
        }
        return super.func_231046_a_(key, value, modifier);
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.isChatOpen() && this.chatOpenedFromEvent) {
            this.chatOpenedFromEvent = false;
            return false;
        }
        if (this.searchTextX.isMouseOver() && !this.isChatOpen()) {
            return this.searchTextX.func_231042_a_(typedChar, keyCode);
        }
        if (this.searchTextZ.isMouseOver() && !this.isChatOpen()) {
            return this.searchTextZ.func_231042_a_(typedChar, keyCode);
        }
        return this.chat.func_231042_a_(typedChar, keyCode);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.chat != null) {
            this.chat.func_231023_e_();
        }
    }

    public void func_238651_a_(MatrixStack mStack, int layer) {
        DrawUtil.drawRectangle(mStack, 0.0, 0.0, this.field_230708_k_, this.field_230709_l_, this.bgColor, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawMap(MatrixStack mStack) {
        boolean refreshReady = this.isRefreshReady();
        StatTimer timer = refreshReady ? this.drawMapTimerWithRefresh : this.drawMapTimer;
        MapType mapType = state.getMapType();
        timer.start();
        try {
            Point2D.Double playerPixel;
            this.sizeDisplay(false);
            double xOffset = 0.0;
            double yOffset = 0.0;
            if (this.isScrolling.booleanValue()) {
                int blockSize = (int)Math.pow(2.0, this.fullMapProperties.zoomLevel.get().intValue());
                double mouseDragX = (this.mx - this.msx) * Math.max(1, this.scaleFactor) / blockSize;
                double mouseDragY = (this.my - this.msy) * Math.max(1, this.scaleFactor) / blockSize;
                xOffset = mouseDragX * (double)blockSize;
                yOffset = mouseDragY * (double)blockSize;
            } else if (refreshReady) {
                this.refreshState();
            } else {
                gridRenderer.setContext(state.getWorldDir(), mapType);
            }
            gridRenderer.clearGlErrors(false);
            gridRenderer.updateRotation(0.0);
            if (Fullscreen.state.follow.get()) {
                gridRenderer.center(state.getWorldDir(), mapType, this.minecraft.field_71439_g.func_226277_ct_(), this.minecraft.field_71439_g.func_226281_cx_(), this.fullMapProperties.zoomLevel.get());
            }
            gridRenderer.updateTiles(mapType, state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), false, 0.0, 0.0);
            gridRenderer.draw(mStack, 1.0f, 0.8f, xOffset, yOffset, this.fullMapProperties.showGrid.get());
            gridRenderer.draw(mStack, state.getDrawSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            gridRenderer.draw(mStack, state.getDrawWaypointSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            if (this.fullMapProperties.showSelf.get().booleanValue() && (playerPixel = gridRenderer.getPixel(this.minecraft.field_71439_g.func_226277_ct_(), this.minecraft.field_71439_g.func_226281_cx_())) != null) {
                float scale = this.fullMapProperties.playerDisplayScale.get().floatValue();
                TextureImpl bgTex = TextureCache.getTexture(TextureCache.PlayerArrowBG);
                TextureImpl fgTex = TextureCache.getTexture(TextureCache.PlayerArrow);
                DrawUtil.drawColoredEntity(mStack, ((Point2D)playerPixel).getX() + xOffset, ((Point2D)playerPixel).getY() + yOffset, bgTex, 0xFFFFFF, 1.0f, scale, this.minecraft.field_71439_g.field_70177_z);
                int playerColor = this.coreProperties.getColor(this.coreProperties.colorSelf);
                DrawUtil.drawColoredEntity(mStack, ((Point2D)playerPixel).getX() + xOffset, ((Point2D)playerPixel).getY() + yOffset, fgTex, playerColor, 1.0f, scale, this.minecraft.field_71439_g.field_70177_z);
            }
            gridRenderer.draw(mStack, this.layerDelegate.getDrawSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            this.sizeDisplay(true);
        }
        finally {
            timer.stop();
            gridRenderer.clearGlErrors(true);
        }
    }

    private float getMapFontScale() {
        return this.fullMapProperties.fontScale.get().floatValue();
    }

    public void centerOn(Waypoint waypoint) {
        if (waypoint.getDimensions().contains(DimensionHelper.getDimName((Entity)this.minecraft.field_71439_g))) {
            if (!waypoint.isPersistent()) {
                this.addTempMarker(waypoint);
            }
            this.centerOn(waypoint.getX(), waypoint.getZ());
        }
    }

    public void centerOn(int x, int z) {
        Fullscreen.state.follow.set(false);
        state.requireRefresh();
        gridRenderer.center(state.getWorldDir(), state.getMapType(), x, z, this.fullMapProperties.zoomLevel.get());
        this.refreshState();
        this.func_231023_e_();
    }

    public void addTempMarker(Waypoint waypoint) {
        try {
            BlockPos pos = waypoint.getBlockPos();
            PolygonOverlay polygonOverlay = new PolygonOverlay("journeymap", waypoint.getName(), (RegistryKey<World>)this.minecraft.field_71439_g.func_130014_f_().func_234923_W_(), new ShapeProperties().setStrokeColor(255).setStrokeOpacity(1.0f).setStrokeWidth(1.5f), new MapPolygon(pos.func_177982_a(-1, 0, 2), pos.func_177982_a(2, 0, 2), pos.func_177982_a(2, 0, -1), pos.func_177982_a(-1, 0, -1)));
            polygonOverlay.setActiveMapTypes(EnumSet.allOf(Context.MapType.class));
            polygonOverlay.setActiveUIs(EnumSet.of(Context.UI.Fullscreen));
            polygonOverlay.setLabel(waypoint.getName());
            this.tempOverlays.add(polygonOverlay);
            ClientAPI.INSTANCE.show(polygonOverlay);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error showing temp location marker: " + LogFormatter.toPartialString(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshState() {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (player == null) {
            this.logger.warn("Could not get player");
            return;
        }
        StatTimer timer = StatTimer.get("Fullscreen.refreshState");
        timer.start();
        try {
            this.menuToolbarBounds = null;
            this.optionsToolbarBounds = null;
            this.fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
            state.refresh(this.minecraft, (PlayerEntity)player, this.fullMapProperties);
            MapType mapType = state.getMapType();
            gridRenderer.setContext(state.getWorldDir(), mapType);
            if (Fullscreen.state.follow.get()) {
                gridRenderer.center(state.getWorldDir(), mapType, this.minecraft.field_71439_g.func_226277_ct_(), this.minecraft.field_71439_g.func_226281_cx_(), this.fullMapProperties.zoomLevel.get());
            } else {
                gridRenderer.setZoom(this.fullMapProperties.zoomLevel.get());
            }
            gridRenderer.updateTiles(mapType, state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), true, 0.0, 0.0);
            state.generateDrawSteps(this.minecraft, gridRenderer, this.waypointRenderer, this.radarRenderer, this.fullMapProperties, false);
            LocationFormat.LocationFormatKeys locationFormatKeys = this.locationFormat.getFormatKeys(this.fullMapProperties.locationFormat.get());
            Fullscreen.state.playerLastPos = locationFormatKeys.format(this.fullMapProperties.locationFormatVerbose.get(), MathHelper.func_76128_c((double)this.minecraft.field_71439_g.func_226277_ct_()), MathHelper.func_76128_c((double)this.minecraft.field_71439_g.func_226281_cx_()), MathHelper.func_76128_c((double)this.minecraft.field_71439_g.func_174813_aQ().field_72338_b), this.minecraft.field_71439_g.field_70162_ai) + " " + state.getPlayerBiome();
            state.updateLastRefresh();
        }
        finally {
            timer.stop();
        }
    }

    public void openChat(String defaultText) {
        if (this.chat != null) {
            this.chat.setText(defaultText);
            this.chat.setHidden(false);
        } else {
            this.chat = new MapChat(defaultText, false);
            this.chat.func_231152_a_(this.minecraft, this.field_230708_k_, this.field_230709_l_);
        }
    }

    @Override
    public void close() {
        for (Overlay temp : this.tempOverlays) {
            ClientAPI.INSTANCE.remove(temp);
        }
        gridRenderer.updateUIState(false);
        if (this.chat != null) {
            this.chat.close();
        }
    }

    public void func_231164_f_() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    boolean isRefreshReady() {
        if (this.isScrolling.booleanValue()) {
            return false;
        }
        return state.shouldRefresh(super.getMinecraft(), this.fullMapProperties) || gridRenderer.hasUnloadedTile();
    }

    public double getScreenScaleFactor() {
        return this.scaleFactor;
    }

    public void moveCanvas(int deltaBlockX, int deltaBlockz) {
        this.refreshState();
        gridRenderer.move(deltaBlockX, deltaBlockz);
        gridRenderer.updateTiles(state.getMapType(), state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), true, 0.0, 0.0);
        ClientAPI.INSTANCE.flagOverlaysForRerender();
        this.setFollow(false);
    }

    public void showCaveLayers() {
        if (!state.isUnderground()) {
            this.updateMapType(MapType.underground(3, state.getDimension()));
        }
    }

    @Override
    protected void drawLogo(MatrixStack mStack) {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n());
        Theme.Container.Toolbar toolbar = ThemeLoader.getCurrentTheme().container.toolbar;
        double scale = this.scaleFactor * 2;
        DrawUtil.sizeDisplay(this.field_230708_k_, this.field_230709_l_);
        DrawUtil.drawImage(mStack, this.logo, toolbar.horizontal.margin, toolbar.vertical.margin, false, (float)(1.0 / scale), 0.0);
    }

    @Override
    public final boolean func_231177_au__() {
        return false;
    }

    public void setTheme(String name) {
        try {
            MiniMapProperties mmp = JourneymapClient.getInstance().getMiniMapProperties(JourneymapClient.getInstance().getActiveMinimapId());
            mmp.shape.set(Shape.Rectangle);
            mmp.sizePercent.set(20);
            mmp.save();
            Theme theme = ThemeLoader.getThemeByName(name);
            ThemeLoader.setCurrentTheme(theme);
            UIManager.INSTANCE.getMiniMap().reset();
            ChatLog.announceI18N("jm.common.ui_theme_applied", new Object[0]);
            UIManager.INSTANCE.closeAll();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Could not load Theme: " + LogFormatter.toString(e));
        }
    }
}

