/*
 * Decompiled with CFR 0.152.
 */
package net.launchers.mod.block.abstraction;

import java.util.List;
import java.util.Random;
import net.launchers.mod.entity.abstraction.AbstractLauncherBlockEntity;
import net.launchers.mod.initializer.LMSounds;
import net.launchers.mod.network.LaunchersNetworkHandler;
import net.launchers.mod.network.packet.UnboundedEntityVelocityS2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2767;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;

public abstract class AbstractLauncherBlock
extends class_2248
implements class_2343 {
    public static final class_2960 LAUNCH_SOUND = new class_2960("launchersmod", "launcher_block_launch");
    public static final class_2746 TRIGGERED;
    public static final class_2758 MODELS;
    private float launchForce = 1.0f;
    private int maxStackable = 4;
    protected float stackPowerPercentage;
    public float stackMultiplier;
    public float baseMultiplier;

    public AbstractLauncherBlock(class_2248.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)MODELS, (Comparable)Integer.valueOf(0))).method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public void method_9554(class_1937 world, class_2338 pos, class_1297 entity, float distance) {
        entity.method_5747(distance, 0.0f);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{MODELS, TRIGGERED});
    }

    public void launchEntities(class_1937 world, class_2338 pos, List<? extends class_1297> entities) {
        if (!world.field_9236) {
            class_2248 current;
            if (entities.size() < 1) {
                return;
            }
            float force = this.launchForce * this.baseMultiplier;
            class_2338 currentPos = pos.method_10074();
            double multiplier = 1.0;
            for (int currentIndex = 1; currentIndex < this.maxStackable && (current = world.method_8320(currentPos).method_11614()) instanceof AbstractLauncherBlock; ++currentIndex) {
                AbstractLauncherBlock launcherBlock = (AbstractLauncherBlock)current;
                multiplier += (double)launcherBlock.stackMultiplier;
                currentPos = currentPos.method_10074();
            }
            force = (float)((double)force * multiplier);
            for (class_1297 class_12972 : entities) {
                System.out.println(force);
                class_12972.method_18799(new class_243(0.0, (double)force, 0.0));
                UnboundedEntityVelocityS2CPacket packet = new UnboundedEntityVelocityS2CPacket(class_12972.method_5628(), 0.0f, force, 0.0f);
                LaunchersNetworkHandler.sendToAll(packet, world.method_8503().method_3760());
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 neighborPos, boolean moved) {
        boolean isRetracted;
        AbstractLauncherBlockEntity launcherBlockEntity = (AbstractLauncherBlockEntity)world.method_8321(pos);
        boolean isRecevingRedstonePower = world.method_8479(pos);
        boolean isTriggered = (Boolean)state.method_11654((class_2769)TRIGGERED);
        boolean bl = isRetracted = launcherBlockEntity.launcherState == AbstractLauncherBlockEntity.LauncherState.RETRACTED;
        if (!isRetracted) {
            return;
        }
        if (isRecevingRedstonePower && !isTriggered) {
            world.method_8397().method_8676(pos, (Object)this, this.method_9563((class_4538)world));
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isRecevingRedstonePower && isTriggered) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        if (this.canLaunch((class_1937)world, pos)) {
            List livingEntities = world.method_18467(class_1309.class, new class_238(pos).method_1009(0.15, 1.25, 0.15));
            List entities = world.method_18467(class_1542.class, new class_238(pos).method_1009(0.15, 1.25, 0.15));
            livingEntities.addAll(entities);
            this.launchEntities((class_1937)world, pos, livingEntities);
            this.playLaunchSound((class_1937)world, pos);
            ((AbstractLauncherBlockEntity)world.method_8321(pos)).startExtending();
        }
    }

    protected void playLaunchSound(class_1937 world, class_2338 pos) {
        double d = (double)pos.method_10263() + 0.5;
        double e = pos.method_10264();
        double f = (double)pos.method_10260() + 0.5;
        world.method_8503().method_3760().method_14581((class_2596)this.createLaunchSoundPacket(d, e, f));
    }

    public class_2767 createLaunchSoundPacket(double x, double y, double z) {
        return new class_2767(LMSounds.LAUNCHER_BLOCK_LAUNCH_SOUNDEVENT, class_3419.field_15245, x, y, z, 1.0f, 1.0f);
    }

    public int method_9563(class_4538 worldView) {
        return 2;
    }

    public boolean canLaunch(class_1937 world, class_2338 pos) {
        AbstractLauncherBlockEntity launcherBlockEntity = (AbstractLauncherBlockEntity)world.method_8321(pos);
        class_2338 up = pos.method_10084();
        return !world.method_8320(up).method_11621((class_1922)world, up) && launcherBlockEntity.launcherState == AbstractLauncherBlockEntity.LauncherState.RETRACTED;
    }

    public abstract class_2586 method_10123(class_1922 var1);

    static {
        MODELS = class_2758.method_11867((String)"models", (int)0, (int)2);
        TRIGGERED = class_2741.field_12522;
    }
}

