/*
 * Decompiled with CFR 0.152.
 */
package net.launchers.mod.initializer;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.registry.CommandRegistry;
import net.launchers.mod.initializer.LMBlock;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

public final class LMCommands {
    private static final String LAUNCHER_ID = "l";
    private static final String P_LAUNCHER_ID = "p";
    private static final String E_LAUNCHER_ID = "e";

    public static void initialize() {
        CommandRegistry.INSTANCE.register(false, dispatcher -> Lcalc.define((CommandDispatcher<class_2168>)dispatcher));
    }

    private static final class Lcalc {
        private Lcalc() {
        }

        public static void define(CommandDispatcher<class_2168> dispatcher) {
            ArrayList launchersList = new ArrayList();
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lcalc").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"first", (ArgumentType)StringArgumentType.word()).suggests(Lcalc.suggestedStrings()).executes(ctx -> {
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
                return Lcalc.checkIdsAndPrintForce(launchersList, (CommandContext<class_2168>)ctx);
            })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"second", (ArgumentType)StringArgumentType.word()).suggests(Lcalc.suggestedStrings()).executes(ctx -> {
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"second"));
                return Lcalc.checkIdsAndPrintForce(launchersList, (CommandContext<class_2168>)ctx);
            })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"third", (ArgumentType)StringArgumentType.word()).suggests(Lcalc.suggestedStrings()).executes(ctx -> {
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"second"));
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"third"));
                return Lcalc.checkIdsAndPrintForce(launchersList, (CommandContext<class_2168>)ctx);
            })).then(class_2170.method_9244((String)"fourth", (ArgumentType)StringArgumentType.word()).suggests(Lcalc.suggestedStrings()).executes(ctx -> {
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"second"));
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"third"));
                launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"fourth"));
                return Lcalc.checkIdsAndPrintForce(launchersList, (CommandContext<class_2168>)ctx);
            })))))).executes(ctx -> Lcalc.checkIdsAndPrintForce(launchersList, (CommandContext<class_2168>)ctx)));
        }

        private static boolean areLauncherIdValid(ArrayList<String> ids) {
            for (int i = 0; i < ids.size(); ++i) {
                String current = ids.get(i);
                if (current.equals(LMCommands.LAUNCHER_ID) || current.equals(LMCommands.P_LAUNCHER_ID) || current.equals(LMCommands.E_LAUNCHER_ID)) continue;
                return false;
            }
            return !ids.isEmpty();
        }

        private static float getStackForceByLauncherId(String id) {
            switch (id) {
                case "l": {
                    return LMBlock.LAUNCHER_BLOCK.stackMultiplier;
                }
                case "p": {
                    return LMBlock.POWERED_LAUNCHER_BLOCK.stackMultiplier;
                }
                case "e": {
                    return LMBlock.EXTREME_LAUNCHER_BLOCK.stackMultiplier;
                }
            }
            return 0.0f;
        }

        private static float getBaseForceByLauncherId(String id) {
            switch (id) {
                case "l": {
                    return LMBlock.LAUNCHER_BLOCK.baseMultiplier;
                }
                case "p": {
                    return LMBlock.POWERED_LAUNCHER_BLOCK.baseMultiplier;
                }
                case "e": {
                    return LMBlock.EXTREME_LAUNCHER_BLOCK.baseMultiplier;
                }
            }
            return 0.0f;
        }

        private static float getForce(ArrayList<String> ids) {
            float base = Lcalc.getBaseForceByLauncherId(ids.get(0));
            float multipier = 1.0f;
            for (int i = 1; i < ids.size(); ++i) {
                multipier += Lcalc.getStackForceByLauncherId(ids.get(i));
            }
            return base * multipier;
        }

        private static int checkIdsAndPrintForce(ArrayList<String> launchersList, CommandContext<class_2168> context) {
            if (!Lcalc.areLauncherIdValid(launchersList)) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("\nOne or more parameters are not correct.\nUsage:\nl: Launcher\np: Powered Launcher\ne: Extreme Launcher\n"), false);
                launchersList.clear();
                return 0;
            }
            String printString = "\nStack: \n";
            for (int i = 0; i < launchersList.size(); ++i) {
                printString = printString + launchersList.get(i) + "\n";
            }
            printString = printString + "Force: " + Lcalc.getForce(launchersList);
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(printString), false);
            launchersList.clear();
            return 1;
        }

        public static SuggestionProvider<class_2168> suggestedStrings() {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add(LMCommands.LAUNCHER_ID);
            suggestions.add(LMCommands.P_LAUNCHER_ID);
            suggestions.add(LMCommands.E_LAUNCHER_ID);
            return (ctx, builder) -> Lcalc.getSuggestionsBuilder(builder, suggestions);
        }

        private static CompletableFuture<Suggestions> getSuggestionsBuilder(SuggestionsBuilder builder, List<String> list) {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            if (list.isEmpty()) {
                return Suggestions.empty();
            }
            for (String str : list) {
                if (!str.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
                builder.suggest(str);
            }
            return builder.buildFuture();
        }
    }
}

