/*
 * Decompiled with CFR 0.152.
 */
package net.launchers.mod.entity.abstraction;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_3000;
import net.minecraft.class_3532;

public abstract class AbstractLauncherBlockEntity
extends class_2586
implements class_3000,
BlockEntityClientSerializable {
    private final class_265 RETRACTED_BASE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final class_265 EXTENDED_BASE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private final class_265 SHORT_EXTENDER_SHAPE = class_2248.method_9541((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private final class_265 LONG_EXTENDER_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final class_265 HEAD_SHAPE = class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public LauncherState[] states;
    private float extensionStride = 1.0f;
    private float retractingStride = this.extensionStride / 4.0f;
    private int retractingDelay = 2;
    private float maxExtendCoefficient;
    private float progress;
    private float lastProgress;
    private boolean extending = true;
    protected int currentTick = 0;
    public LauncherState launcherState;

    public AbstractLauncherBlockEntity(class_2591<?> type) {
        super(type);
        this.states = LauncherState.values();
        this.launcherState = LauncherState.RETRACTED;
    }

    public boolean isRetracted() {
        return this.launcherState == LauncherState.RETRACTED;
    }

    public class_265 getCollisionShape() {
        class_265 baseShape = null;
        if (this.isRetracted()) {
            baseShape = this.RETRACTED_BASE_SHAPE;
            return baseShape;
        }
        baseShape = this.EXTENDED_BASE_SHAPE;
        class_265 extenderShape = null;
        extenderShape = (double)this.progress < 0.35 ? class_259.method_1084((class_265)baseShape, (class_265)this.SHORT_EXTENDER_SHAPE.method_1096(0.0, (double)this.progress - 0.25, 0.0)) : class_259.method_1084((class_265)baseShape, (class_265)this.LONG_EXTENDER_SHAPE.method_1096(0.0, (double)(this.progress - 0.25f), 0.0));
        return class_259.method_1084((class_265)extenderShape, (class_265)this.HEAD_SHAPE.method_1096(0.0, (double)this.progress, 0.0));
    }

    @Environment(value=EnvType.CLIENT)
    public float getDeltaProgress(float tickDelta) {
        if (tickDelta > 1.0f) {
            tickDelta = 1.0f;
        }
        return class_3532.method_16439((float)tickDelta, (float)this.lastProgress, (float)this.progress);
    }

    public void method_16896() {
        switch (this.launcherState) {
            case EXTENDED: {
                ++this.currentTick;
                if (this.currentTick < this.retractingDelay) break;
                this.currentTick = 0;
                this.startRetracting();
                break;
            }
            case RETRACTED: {
                break;
            }
            case MOVING: {
                this.lastProgress = this.progress;
                if (this.extending) {
                    if (this.lastProgress >= 1.0f) {
                        this.launcherState = LauncherState.EXTENDED;
                        this.lastProgress = 1.0f;
                        break;
                    }
                    this.progress += this.extensionStride;
                    if (!(this.progress >= 1.0f)) break;
                    this.progress = 1.0f;
                    break;
                }
                if (this.lastProgress <= 0.0f) {
                    this.launcherState = LauncherState.RETRACTED;
                    this.lastProgress = 0.0f;
                    break;
                }
                this.progress -= this.retractingStride;
                if (!(this.progress <= 0.0f)) break;
                this.progress = 0.0f;
            }
        }
    }

    public void startExtending() {
        this.extending = true;
        this.launcherState = LauncherState.MOVING;
        this.progress = 0.0f;
        this.sync();
    }

    public void startRetracting() {
        this.extending = false;
        this.launcherState = LauncherState.MOVING;
        if (!this.field_11863.field_9236) {
            this.sync();
        }
    }

    public void fromTag(class_2487 tag) {
        super.method_11014(this.field_11863.method_8320(this.field_11867), tag);
        this.currentTick = tag.method_10550("currentTick");
        this.lastProgress = this.progress = tag.method_10583("progress");
        this.extending = tag.method_10577("extending");
        this.launcherState = this.states[tag.method_10550("launcherState")];
    }

    public class_2487 method_11007(class_2487 tag) {
        tag.method_10569("currentTick", this.currentTick);
        tag.method_10548("progress", this.lastProgress);
        tag.method_10556("extending", this.extending);
        tag.method_10569("launcherState", this.launcherState.ordinal());
        return super.method_11007(tag);
    }

    public void fromClientTag(class_2487 compoundTag) {
        this.fromTag(compoundTag);
    }

    public class_2487 toClientTag(class_2487 compoundTag) {
        return this.method_11007(compoundTag);
    }

    public static enum LauncherState {
        EXTENDED,
        RETRACTED,
        MOVING;

    }
}

