/*
 * Decompiled with CFR 0.152.
 */
package net.launchers.mod.block.abstraction;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.launchers.mod.entity.abstraction.AbstractLauncherBlockTileEntity;
import net.launchers.mod.initializer.LSounds;
import net.launchers.mod.loader.LLoader;
import net.launchers.mod.network.NetworkHandler;
import net.launchers.mod.network.packet.UnboundedEntityVelocityS2CPacket;
import net.launchers.mod.utils.MathUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractLauncherBlock
extends Block
implements ITileEntityProvider {
    public static final ResourceLocation LAUNCH_SOUND = new ResourceLocation("launchersmodforge", "launcher_block_launch");
    public static final IntegerProperty MODELS = IntegerProperty.func_177719_a((String)"models", (int)0, (int)2);
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    private float launchForce = 1.0f;
    private int maxStackable = 4;
    protected float stackPowerPercentage;
    public float stackMultiplier;
    public float baseMultiplier;

    public AbstractLauncherBlock(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        entity.func_225503_b_(distance, 0.0f);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, MODELS});
        super.func_206840_a(builder);
    }

    public void launchEntities(World world, BlockPos pos, List<? extends Entity> entities) {
        if (!world.field_72995_K) {
            Block current;
            if (entities.size() < 1) {
                return;
            }
            float force = this.launchForce * this.baseMultiplier;
            BlockState parentState = world.func_180495_p(pos);
            Direction stackDirection = ((Direction)parentState.func_177229_b((Property)FACING)).func_176734_d();
            BlockPos currentPos = pos.func_177972_a(stackDirection);
            int currentIndex = 1;
            double multiplier = 1.0;
            if (!stackDirection.equals((Object)Direction.UP) && !stackDirection.equals((Object)Direction.DOWN)) {
                multiplier *= 1.75;
            }
            while (currentIndex < this.maxStackable && (current = world.func_180495_p(currentPos).func_177230_c()) instanceof AbstractLauncherBlock && ((Direction)world.func_180495_p(currentPos).func_177229_b((Property)FACING)).equals((Object)parentState.func_177229_b((Property)FACING))) {
                AbstractLauncherBlock launcherBlock = (AbstractLauncherBlock)current;
                multiplier += (double)launcherBlock.stackMultiplier;
                currentPos = currentPos.func_177972_a(stackDirection);
                ++currentIndex;
            }
            force = (float)((double)force * multiplier);
            for (Entity entity : entities) {
                Vector3d initialVelocity = entity.func_213322_ci();
                Vector3d vectorForce = MathUtils.fromDirection((Direction)world.func_180495_p(pos).func_177229_b((Property)FACING));
                Vector3d velocity = vectorForce.func_186678_a((double)force).func_178787_e(initialVelocity);
                entity.func_213317_d(velocity);
                UnboundedEntityVelocityS2CPacket packet = new UnboundedEntityVelocityS2CPacket(entity.func_145782_y(), velocity);
                NetworkHandler.sendToAll(packet, world.func_73046_m().func_184103_al());
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block p_220069_4_, BlockPos neighborPos, boolean p_220069_6_) {
        boolean isRetracted;
        AbstractLauncherBlockTileEntity launcherBlockEntity = (AbstractLauncherBlockTileEntity)world.func_175625_s(pos);
        boolean isRecevingRedstonePower = world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a());
        boolean bl = isRetracted = launcherBlockEntity.launcherState == AbstractLauncherBlockTileEntity.LauncherState.RETRACTED;
        if (!isRetracted) {
            return;
        }
        if (isRecevingRedstonePower) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.getTickRate((IWorldReader)world));
        }
    }

    protected abstract void playLaunchSound(World var1, BlockPos var2);

    public SPlaySoundPacket createLaunchSoundPacket(double x, double y, double z) {
        return new SPlaySoundPacket(LSounds.LAUNCHER_SOUND_EVENT.getId(), SoundCategory.BLOCKS, new Vector3d(x, y, z), 1.0f, 1.0f);
    }

    public boolean canLaunch(World world, BlockPos pos) {
        AbstractLauncherBlockTileEntity launcherBlockEntity = (AbstractLauncherBlockTileEntity)world.func_175625_s(pos);
        BlockPos offset = pos.func_177972_a((Direction)world.func_180495_p(pos).func_177229_b((Property)FACING));
        return (world.func_180495_p(offset).func_196958_f() || world.func_180495_p(offset).func_177230_c().equals(Blocks.field_150473_bD)) && launcherBlockEntity.launcherState == AbstractLauncherBlockTileEntity.LauncherState.RETRACTED;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random p_225534_4_) {
        LLoader.LOGGER.debug("Launching");
        if (this.canLaunch((World)world, pos)) {
            List entities = world.func_217357_a(Entity.class, new AxisAlignedBB(pos.func_177972_a((Direction)state.func_177229_b((Property)FACING))));
            this.launchEntities((World)world, pos, entities);
            this.playLaunchSound((World)world, pos);
            ((AbstractLauncherBlockTileEntity)world.func_175625_s(pos)).startExtending();
        }
    }

    public int getTickRate(IWorldReader worldView) {
        return 1;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

