/*
 * Decompiled with CFR 0.152.
 */
package net.launchers.mod.entity.abstraction;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;

public class AbstractLauncherBlockTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final VoxelShape RETRACTED_BASE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final VoxelShape EXTENDED_BASE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private final VoxelShape SHORT_EXTENDER_SHAPE = Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private final VoxelShape LONG_EXTENDER_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final VoxelShape HEAD_SHAPE = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public LauncherState[] states;
    private float extensionStride = 1.0f;
    private float retractingStride = this.extensionStride / 4.0f;
    private int retractingDelay = 2;
    private float maxExtendCoefficient;
    private float progress;
    private float lastProgress;
    private boolean extending = true;
    protected int currentTick = 0;
    public LauncherState launcherState;

    public AbstractLauncherBlockTileEntity(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
        this.states = LauncherState.values();
        this.launcherState = LauncherState.RETRACTED;
    }

    public boolean isRetracted() {
        return this.launcherState == LauncherState.RETRACTED;
    }

    public void func_73660_a() {
        switch (this.launcherState) {
            case EXTENDED: {
                ++this.currentTick;
                if (this.currentTick < this.retractingDelay) break;
                this.currentTick = 0;
                this.startRetracting();
                break;
            }
            case RETRACTED: {
                break;
            }
            case MOVING: {
                this.lastProgress = this.progress;
                if (this.extending) {
                    if (this.lastProgress >= 1.0f) {
                        this.launcherState = LauncherState.EXTENDED;
                        this.lastProgress = 1.0f;
                        break;
                    }
                    this.progress += this.extensionStride;
                    if (!(this.progress >= 1.0f)) break;
                    this.progress = 1.0f;
                    break;
                }
                if (this.lastProgress <= 0.0f) {
                    this.launcherState = LauncherState.RETRACTED;
                    this.lastProgress = 0.0f;
                    break;
                }
                this.progress -= this.retractingStride;
                if (!(this.progress <= 0.0f)) break;
                this.progress = 0.0f;
            }
        }
        if (!this.field_145850_b.field_72995_K && this.lastProgress != this.progress) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void startExtending() {
        this.extending = true;
        this.launcherState = LauncherState.MOVING;
        this.progress = 0.0f;
    }

    public void startRetracting() {
        this.extending = false;
        this.launcherState = LauncherState.MOVING;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("currentTick", this.currentTick);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74757_a("extending", this.extending);
        nbt.func_74768_a("launcherState", this.launcherState.ordinal());
        return nbt;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = this.func_189517_E_();
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), tag);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.currentTick = tag.func_74762_e("currentTick");
        this.progress = tag.func_74760_g("progress");
        this.extending = tag.func_74767_n("extending");
        this.launcherState = this.states[tag.func_74762_e("launcherState")];
        super.handleUpdateTag(state, tag);
    }

    public float getDeltaProgress(float tickDelta) {
        if (tickDelta > 1.0f) {
            tickDelta = 1.0f;
        }
        return MathHelper.func_219799_g((float)tickDelta, (float)this.lastProgress, (float)this.progress);
    }

    public static enum LauncherState {
        EXTENDED,
        RETRACTED,
        MOVING;

    }
}

