/*
 * Decompiled with CFR 0.152.
 */
package net.launchers.mod.initializer;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.launchers.mod.block.abstraction.AbstractLauncherBlock;
import net.launchers.mod.initializer.LBlocks;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class LCommands {
    private static final String LAUNCHER_ID = "l";
    private static final String P_LAUNCHER_ID = "p";
    private static final String E_LAUNCHER_ID = "e";

    public static void initialize(CommandDispatcher<CommandSource> dispatcher) {
        ArrayList launchersList = new ArrayList();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lcalc").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"first", (ArgumentType)StringArgumentType.word()).suggests(LCommands.suggestedStrings()).executes(ctx -> {
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
            return LCommands.checkIdsAndPrintForce(launchersList, (CommandContext<CommandSource>)ctx);
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"second", (ArgumentType)StringArgumentType.word()).suggests(LCommands.suggestedStrings()).executes(ctx -> {
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"second"));
            return LCommands.checkIdsAndPrintForce(launchersList, (CommandContext<CommandSource>)ctx);
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"third", (ArgumentType)StringArgumentType.word()).suggests(LCommands.suggestedStrings()).executes(ctx -> {
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"second"));
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"third"));
            return LCommands.checkIdsAndPrintForce(launchersList, (CommandContext<CommandSource>)ctx);
        })).then(Commands.func_197056_a((String)"fourth", (ArgumentType)StringArgumentType.word()).suggests(LCommands.suggestedStrings()).executes(ctx -> {
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"first"));
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"second"));
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"third"));
            launchersList.add(StringArgumentType.getString((CommandContext)ctx, (String)"fourth"));
            return LCommands.checkIdsAndPrintForce(launchersList, (CommandContext<CommandSource>)ctx);
        })))))).executes(ctx -> LCommands.checkIdsAndPrintForce(launchersList, (CommandContext<CommandSource>)ctx)));
    }

    private static boolean areLauncherIdValid(ArrayList<String> ids) {
        for (String current : ids) {
            if (current.equals(LAUNCHER_ID) || current.equals(P_LAUNCHER_ID) || current.equals(E_LAUNCHER_ID)) continue;
            return false;
        }
        return !ids.isEmpty();
    }

    private static float getStackForceByLauncherId(String id) {
        switch (id) {
            case "l": {
                return ((AbstractLauncherBlock)((Block)LBlocks.LAUNCHER_BLOCK.get()).getBlock()).stackMultiplier;
            }
            case "p": {
                return ((AbstractLauncherBlock)((Block)LBlocks.POWERED_LAUNCHER_BLOCK.get()).getBlock()).stackMultiplier;
            }
            case "e": {
                return ((AbstractLauncherBlock)((Block)LBlocks.EXTREME_LAUNCHER_BLOCK.get()).getBlock()).stackMultiplier;
            }
        }
        return 0.0f;
    }

    private static float getBaseForceByLauncherId(String id) {
        switch (id) {
            case "l": {
                return ((AbstractLauncherBlock)((Block)LBlocks.LAUNCHER_BLOCK.get()).getBlock()).baseMultiplier;
            }
            case "p": {
                return ((AbstractLauncherBlock)((Block)LBlocks.POWERED_LAUNCHER_BLOCK.get()).getBlock()).baseMultiplier;
            }
            case "e": {
                return ((AbstractLauncherBlock)((Block)LBlocks.EXTREME_LAUNCHER_BLOCK.get()).getBlock()).baseMultiplier;
            }
        }
        return 0.0f;
    }

    private static float getForce(ArrayList<String> ids) {
        float base = LCommands.getBaseForceByLauncherId(ids.get(0));
        float multipier = 1.0f;
        for (int i = 1; i < ids.size(); ++i) {
            multipier += LCommands.getStackForceByLauncherId(ids.get(i));
        }
        return base * multipier;
    }

    private static int checkIdsAndPrintForce(ArrayList<String> launchersList, CommandContext<CommandSource> context) {
        if (!LCommands.areLauncherIdValid(launchersList)) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("\nOne or more parameters are not correct.\nUsage:\nl: Launcher\np: Powered Launcher\ne: Extreme Launcher\n"));
            launchersList.clear();
            return 0;
        }
        String printString = "\nStack: \n";
        for (int i = 0; i < launchersList.size(); ++i) {
            printString = printString + launchersList.get(i) + "\n";
        }
        printString = printString + "Force: " + LCommands.getForce(launchersList);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(printString), false);
        launchersList.clear();
        return 1;
    }

    public static SuggestionProvider<CommandSource> suggestedStrings() {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add(LAUNCHER_ID);
        suggestions.add(P_LAUNCHER_ID);
        suggestions.add(E_LAUNCHER_ID);
        return (ctx, builder) -> LCommands.getSuggestionsBuilder(builder, suggestions);
    }

    private static CompletableFuture<Suggestions> getSuggestionsBuilder(SuggestionsBuilder builder, List<String> list) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (list.isEmpty()) {
            return Suggestions.empty();
        }
        for (String str : list) {
            if (!str.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }
}

