/*
 * Decompiled with CFR 0.152.
 */
package net.launchers.mod.network.packet;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.launchers.mod.initializer.LNetwork;
import net.launchers.mod.loader.LLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class UnboundedEntityVelocityS2CPacket {
    private Vector3d velocity;
    private int entityId;

    public UnboundedEntityVelocityS2CPacket(PacketBuffer buffer) {
        this.read(buffer);
    }

    public UnboundedEntityVelocityS2CPacket(int entityId, Vector3d velocity) {
        this.velocity = velocity;
        this.entityId = entityId;
    }

    public UnboundedEntityVelocityS2CPacket(int entityId, float x, float y, float z) {
        this(entityId, new Vector3d((double)x, (double)y, (double)z));
    }

    public UnboundedEntityVelocityS2CPacket(Entity entity, Vector3d velocity) {
        this(entity.func_145782_y(), velocity);
    }

    public UnboundedEntityVelocityS2CPacket(Entity entity, float x, float y, float z) {
        this(entity.func_145782_y(), new Vector3d((double)x, (double)y, (double)z));
    }

    public void sendTo(PlayerEntity player) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        this.write(buf);
        LNetwork.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)this);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            LLoader.LOGGER.info("Entity: " + this.entityId + ", player: " + player.func_145782_y());
            Entity targetEntity = player.field_70170_p.func_73045_a(this.entityId);
            targetEntity.func_213317_d(this.velocity);
        });
        return true;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
        buf.writeDouble(this.velocity.field_72450_a);
        buf.writeDouble(this.velocity.field_72448_b);
        buf.writeDouble(this.velocity.field_72449_c);
    }

    public void read(PacketBuffer buf) {
        this.entityId = buf.func_150792_a();
        this.velocity = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

