/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty;

import com.mlib.Random;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class MajruszsHelper {
    @Nullable
    public static Player getPlayerFromDamageSource(DamageSource damageSource) {
        return damageSource.m_7639_() instanceof Player ? (Player)damageSource.m_7639_() : null;
    }

    public static boolean isHuman(@Nullable Entity entity) {
        return entity instanceof Player || entity instanceof Villager || entity instanceof Pillager || entity instanceof Witch;
    }

    public static boolean isAnimal(@Nullable Entity entity) {
        return entity instanceof Animal;
    }

    public static void addTranslatableText(List<Component> tooltip, String translationKey) {
        tooltip.add((Component)new TranslatableComponent(translationKey).m_130940_(ChatFormatting.GRAY));
    }

    public static void addTranslatableTexts(List<Component> tooltip, String ... translationKeys) {
        for (String translationKey : translationKeys) {
            MajruszsHelper.addTranslatableText(tooltip, translationKey);
        }
    }

    public static void addAdvancedTranslatableText(List<Component> tooltip, TooltipFlag flag, String translationKey) {
        if (flag.m_7050_()) {
            MajruszsHelper.addTranslatableText(tooltip, translationKey);
        }
    }

    public static void addAdvancedTranslatableTexts(List<Component> tooltip, TooltipFlag flag, String ... translationKeys) {
        if (flag.m_7050_()) {
            for (String translationKey : translationKeys) {
                MajruszsHelper.addAdvancedTranslatableText(tooltip, flag, translationKey);
            }
        }
    }

    public static MutableComponent getDisabledItemComponent() {
        return new TranslatableComponent("majruszs_difficulty.items.disabled_tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    }

    public static void addExtraTextIfItemIsDisabled(List<Component> tooltip, boolean isEnabled) {
        if (!isEnabled) {
            tooltip.add((Component)MajruszsHelper.getDisabledItemComponent());
        }
    }

    public static MutableComponent getMoreDetailsComponent() {
        return new TranslatableComponent("majruszs_difficulty.items.advanced_tooltip").m_130940_(ChatFormatting.GRAY);
    }

    public static void addMoreDetailsText(List<Component> tooltip) {
        tooltip.add((Component)MajruszsHelper.getMoreDetailsComponent());
    }

    public static MutableComponent getEmptyLine() {
        return new TextComponent(" ");
    }

    public static void addEmptyLine(List<Component> tooltip) {
        tooltip.add((Component)MajruszsHelper.getEmptyLine());
    }

    public static boolean teleportNearby(LivingEntity target, ServerLevel world, double insideOffset, double outsideOffset) {
        double distanceFactor = insideOffset;
        if (target.f_19791_ + 8.0 > (double)world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)target.f_19790_, (int)target.f_19792_)) {
            distanceFactor = outsideOffset;
        }
        Vec3 newPosition = Random.getRandomVector3d((double)(-distanceFactor), (double)distanceFactor, (double)-1.0, (double)1.0, (double)(-distanceFactor), (double)distanceFactor).m_82549_(target.m_20182_());
        double y = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)newPosition.f_82479_, (int)newPosition.f_82481_) + 1;
        return !(y < 5.0) && target.m_20984_(newPosition.f_82479_, target.f_19791_ + 8.0 > y ? y : newPosition.f_82480_, newPosition.f_82481_, true);
    }
}

