/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.commands;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.commands.ChangeGameStageCommand;
import com.majruszs_difficulty.commands.GetClampedRegionalDifficultyCommands;
import com.majruszs_difficulty.commands.GetGameStageCommand;
import com.majruszs_difficulty.commands.HighlightUndeadArmyCommands;
import com.majruszs_difficulty.commands.KillUndeadArmyCommands;
import com.majruszs_difficulty.commands.StartUndeadArmyCommands;
import com.majruszs_difficulty.commands.StopUndeadArmyCommands;
import com.majruszs_difficulty.commands.TreasureBagResetProgressCommands;
import com.majruszs_difficulty.commands.UndeadArmyProgressCommands;
import com.majruszs_difficulty.commands.UndeadArmyUndeadLeftCommands;
import com.mlib.commands.BaseCommand;
import com.mlib.commands.IRegistrableCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.phys.Vec3;

public class CommandsHelper {
    public static final List<IRegistrableCommand> COMMANDS = new ArrayList<IRegistrableCommand>();
    public static final LiteralArgumentBuilder<CommandSourceStack> UNDEAD_ARMY_ARGUMENT = BaseCommand.literal((String)"undeadarmy");
    public static final LiteralArgumentBuilder<CommandSourceStack> TREASURE_BAG_ARGUMENT = BaseCommand.literal((String)"treasurebag");

    public static MutableComponent createGameStageMessage(GameState.State state, String translationID) {
        return new TranslatableComponent("commands.gamestage." + translationID, new Object[]{GameState.getGameStateText(state)});
    }

    public static MutableComponent createBaseMessageWithPosition(String translationKey, Vec3 position, Object ... objects) {
        Object[] copy = new Object[objects.length + 1];
        copy[objects.length] = CommandsHelper.getPositionFormatted(position);
        System.arraycopy(objects, 0, copy, 0, objects.length);
        return new TranslatableComponent(translationKey, copy);
    }

    public static String getPositionFormatted(Vec3 position) {
        return String.format("(%d, %d, %d)", (int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_);
    }

    static {
        COMMANDS.add(new StopUndeadArmyCommands());
        COMMANDS.add(new StartUndeadArmyCommands());
        COMMANDS.add(new KillUndeadArmyCommands());
        COMMANDS.add(new HighlightUndeadArmyCommands());
        COMMANDS.add(new UndeadArmyUndeadLeftCommands());
        COMMANDS.add(new UndeadArmyProgressCommands());
        COMMANDS.add(new ChangeGameStageCommand());
        COMMANDS.add(new GetGameStageCommand());
        COMMANDS.add(new GetClampedRegionalDifficultyCommands());
        COMMANDS.add(new TreasureBagResetProgressCommands());
    }
}

