/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.entities;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.entities.MobsConfig;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.math.VectorHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EliteSkeletonEntity
extends Skeleton {
    public static final Potion[] ARROW_POTIONS = new Potion[]{Potions.f_43582_, Potions.f_43584_, Potions.f_43615_, Potions.f_43593_};
    public static final EntityType<EliteSkeletonEntity> type = EntityType.Builder.m_20704_(EliteSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.0f).m_20712_(MajruszsDifficulty.getLocation("elite_skeleton").toString());
    private static final float ARROW_VELOCITY = 2.0f;
    private static final float ARROW_INACCURACY = 0.0f;
    private int quickShotsLeft = 0;

    public EliteSkeletonEntity(EntityType<? extends Skeleton> type, Level world) {
        super(type, world);
        this.f_32130_ = new RangedBowAttackGoal((Monster)this, 0.8333333333333334, this.getAttackCooldown(), 20.0f);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        MobsConfig.EliteSkeletonConfig config = Instances.ENTITIES_CONFIG.eliteSkeleton;
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty((LivingEntity)this);
        this.handleQuickShot(config.quickShotChance.get() * clampedRegionalDifficulty);
        this.handleExtraArrows(config.multiShotChance.get() * clampedRegionalDifficulty, target, distanceFactor);
        this.spawnArrow(0.0, target, distanceFactor);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (MajruszLibrary.RANDOM.nextFloat() * 0.4f + 0.8f));
    }

    public static AttributeSupplier getAttributeMap() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.5).m_22265_();
    }

    protected void spawnArrow(double yFactor, LivingEntity target, float distanceFactor) {
        ItemStack heldItemStack = this.m_21205_();
        AbstractArrow arrowEntity = this.getArrowEntity(distanceFactor);
        if (heldItemStack.m_41720_() instanceof BowItem) {
            arrowEntity = ((BowItem)heldItemStack.m_41720_()).customArrow(arrowEntity);
        }
        Vec3 offset = VectorHelper.subtract((Vec3)new Vec3(target.m_20185_(), 0.0, target.m_20189_()), (Vec3)new Vec3(this.m_20185_(), 0.0, this.m_20189_()));
        double distance = VectorHelper.length((Vec3)offset);
        double y = target.m_20227_(0.2) - arrowEntity.m_20186_();
        arrowEntity.m_6686_(offset.f_82479_, y + distance * 0.2 + yFactor, offset.f_82481_, 2.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)arrowEntity);
    }

    protected AbstractArrow getArrowEntity(float distanceFactor) {
        ItemStack ammunition = new ItemStack((ItemLike)Items.f_42412_);
        double tippedArrowChance = Instances.ENTITIES_CONFIG.eliteSkeleton.tippedArrowChance.get() * GameState.getRegionalDifficulty((LivingEntity)this);
        if (Random.tryChance((double)tippedArrowChance) && ammunition.m_41720_() instanceof ArrowItem) {
            ammunition = new ItemStack((ItemLike)Items.f_42738_);
            PotionUtils.m_43549_((ItemStack)ammunition, (Potion)ARROW_POTIONS[MajruszLibrary.RANDOM.nextInt(ARROW_POTIONS.length)]);
        }
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)ammunition, (float)distanceFactor);
    }

    protected int getAttackCooldown() {
        return this.f_19853_.m_46791_() != Difficulty.HARD ? 40 : 20;
    }

    protected void handleQuickShot(double quickShotChance) {
        if (this.quickShotsLeft == 0 && Random.tryChance((double)quickShotChance) && this.f_19853_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 6, 0.5, 0.25, 0.5, 0.125);
            this.quickShotsLeft = 3;
            this.f_32130_.m_25797_(1);
        } else if (this.quickShotsLeft > 0 && --this.quickShotsLeft == 0) {
            this.f_32130_.m_25797_(this.getAttackCooldown());
        }
    }

    protected void handleExtraArrows(double multiShotChance, LivingEntity target, float distanceFactor) {
        if (this.quickShotsLeft == 0 && Random.tryChance((double)multiShotChance)) {
            this.spawnArrow(1.25, target, distanceFactor);
            this.spawnArrow(-1.25, target, distanceFactor);
        }
    }
}

