/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.entities.EliteSkeletonEntity;
import com.majruszs_difficulty.entities.GiantEntity;
import com.majruszs_difficulty.entities.ParasiteEntity;
import com.majruszs_difficulty.entities.TankEntity;
import com.majruszs_difficulty.generation.OreGeneration;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BiomeLoading {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLoad(BiomeLoadingEvent event) {
        Biome.BiomeCategory category = event.getCategory();
        MobSpawnInfoBuilder spawnInfoBuilder = event.getSpawns();
        BiomeGenerationSettingsBuilder generationSettingsBuilder = event.getGeneration();
        if (BiomeLoading.doBiomeCategoryBelongsToOverworld(category)) {
            BiomeLoading.addOverworldEntities(spawnInfoBuilder);
            BiomeLoading.addOverworldStructures(generationSettingsBuilder);
        } else if (BiomeLoading.doBiomeCategoryBelongsToNether(category)) {
            BiomeLoading.addNetherEntities(spawnInfoBuilder);
        } else if (BiomeLoading.doBiomeCategoryBelongsToTheEnd(category)) {
            BiomeLoading.addEndEntities(spawnInfoBuilder);
            BiomeLoading.addEndStructures(generationSettingsBuilder);
            BiomeLoading.addEndOres(generationSettingsBuilder);
        }
    }

    protected static void addOverworldEntities(MobSpawnInfoBuilder spawnInfoBuilder) {
        BiomeLoading.addFreshEntity(spawnInfoBuilder, MobCategory.MONSTER, EntityType.f_20459_, 20, 1, 2);
        BiomeLoading.addFreshEntity(spawnInfoBuilder, MobCategory.MONSTER, GiantEntity.type, 3, 1, 1);
        BiomeLoading.addFreshEntity(spawnInfoBuilder, MobCategory.MONSTER, EliteSkeletonEntity.type, 20, 1, 1);
        BiomeLoading.addFreshEntity(spawnInfoBuilder, MobCategory.MONSTER, TankEntity.type, 3, 1, 1);
    }

    protected static void addOverworldStructures(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
    }

    protected static void addNetherEntities(MobSpawnInfoBuilder spawnInfoBuilder) {
        Set entityTypes = spawnInfoBuilder.getEntityTypes();
        if (entityTypes.contains(EntityType.f_20524_) || entityTypes.contains(EntityType.f_20497_)) {
            BiomeLoading.addFreshEntity(spawnInfoBuilder, MobCategory.MONSTER, EliteSkeletonEntity.type, 5, 1, 1);
        }
    }

    protected static void addEndEntities(MobSpawnInfoBuilder spawnInfoBuilder) {
        BiomeLoading.addFreshEntity(spawnInfoBuilder, MobCategory.MONSTER, ParasiteEntity.type, 1, 2, 6);
    }

    protected static void addEndStructures(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
    }

    protected static void addEndOres(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
        for (ConfiguredFeature<?, ?> ore : OreGeneration.END_ORES) {
            generationSettingsBuilder.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, ore);
        }
    }

    protected static boolean doBiomeCategoryBelongsToOverworld(Biome.BiomeCategory category) {
        boolean isTaiga = category == Biome.BiomeCategory.TAIGA;
        boolean isExtremeHills = category == Biome.BiomeCategory.EXTREME_HILLS;
        boolean isJungle = category == Biome.BiomeCategory.JUNGLE;
        boolean isMesa = category == Biome.BiomeCategory.MESA;
        boolean isPlains = category == Biome.BiomeCategory.PLAINS;
        boolean isSavanna = category == Biome.BiomeCategory.SAVANNA;
        boolean isIcy = category == Biome.BiomeCategory.ICY;
        boolean isBeach = category == Biome.BiomeCategory.BEACH;
        boolean isForest = category == Biome.BiomeCategory.FOREST;
        boolean isOcean = category == Biome.BiomeCategory.OCEAN;
        boolean isDesert = category == Biome.BiomeCategory.DESERT;
        boolean isRiver = category == Biome.BiomeCategory.RIVER;
        boolean isSwamp = category == Biome.BiomeCategory.SWAMP;
        boolean isMushroom = category == Biome.BiomeCategory.MUSHROOM;
        return isTaiga || isExtremeHills || isJungle || isMesa || isPlains || isSavanna || isIcy || isBeach || isForest || isOcean || isDesert || isRiver || isSwamp || isMushroom;
    }

    protected static boolean doBiomeCategoryBelongsToNether(Biome.BiomeCategory category) {
        return category == Biome.BiomeCategory.NETHER;
    }

    protected static boolean doBiomeCategoryBelongsToTheEnd(Biome.BiomeCategory category) {
        return category == Biome.BiomeCategory.THEEND;
    }

    private static void addFreshEntity(MobSpawnInfoBuilder spawnInfoBuilder, MobCategory classification, EntityType<?> entityType, int weight, int minimumCount, int maximumCount) {
        MobSpawnSettings.SpawnerData spawners = new MobSpawnSettings.SpawnerData(entityType, weight, minimumCount, maximumCount);
        spawnInfoBuilder.m_48376_(classification, spawners);
    }
}

