/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.mlib.items.ItemHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public abstract class GiveItemOnSpawnBase
extends OnEnemyToBeSpawnedBase {
    protected final EquipmentSlot equipmentSlotType;
    protected final boolean shouldBeEnchanted;
    protected final boolean shouldBeDamaged;

    public GiveItemOnSpawnBase(String configName, String configComment, double defaultChance, GameState.State minimumState, boolean shouldChanceBeMultipliedByCRD, EquipmentSlot equipmentSlotType, boolean shouldBeEnchanted, boolean shouldBeDamaged) {
        super(configName, configComment, defaultChance, minimumState, shouldChanceBeMultipliedByCRD);
        this.equipmentSlotType = equipmentSlotType;
        this.shouldBeEnchanted = shouldBeEnchanted;
        this.shouldBeDamaged = shouldBeDamaged;
    }

    @Override
    public void onExecute(LivingEntity entity, ServerLevel world) {
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty(entity);
        entity.m_8061_(this.equipmentSlotType, this.getFinalItemStack(clampedRegionalDifficulty));
    }

    public abstract ItemStack getItemStack();

    protected ItemStack getFinalItemStack(double clampedRegionalDifficulty) {
        if (this.shouldBeEnchanted) {
            if (this.shouldBeDamaged) {
                return ItemHelper.damageAndEnchantItem((ItemStack)this.getItemStack(), (double)clampedRegionalDifficulty, (boolean)true, (double)0.5);
            }
            return ItemHelper.enchantItem((ItemStack)this.getItemStack(), (double)clampedRegionalDifficulty, (boolean)true);
        }
        return this.shouldBeDamaged ? ItemHelper.damageItem((ItemStack)this.getItemStack(), (double)0.5) : this.getItemStack();
    }
}

