/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.config.GameStateDoubleConfig;
import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class StrengthenedEntityAttributesOnSpawn
extends OnEnemyToBeSpawnedBase {
    protected static final AttributeHandler MAX_HEALTH_ATTRIBUTE = new AttributeHandler("ba9de909-4a9e-43da-9d14-fbcbc2403316", "MonsterSpawnHealthBonus", Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_BASE);
    protected static final AttributeHandler DAMAGE_ATTRIBUTE = new AttributeHandler("053d92c8-ccb5-4b95-9add-c31aca144177", "MonsterSpawnDamageBonus", Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final String CONFIG_NAME = "SpawnBonuses";
    private static final String CONFIG_COMMENT = "Damage and health bonuses of hostile creatures.";
    protected final GameStateDoubleConfig healthBonuses;
    protected final GameStateDoubleConfig damageBonuses;
    protected final DoubleConfig multiplierAtNight;

    public StrengthenedEntityAttributesOnSpawn() {
        super(CONFIG_NAME, CONFIG_COMMENT, 1.0, GameState.State.NORMAL, false);
        String health_comment = "Extra health multiplier.";
        String damage_comment = "Extra damage multiplier.";
        String night_comment = "Extra damage and health multiplier at night.";
        this.healthBonuses = new GameStateDoubleConfig("HealthMultiplier", health_comment, 0.0, 0.2, 0.4, 0.0, 10.0);
        this.damageBonuses = new GameStateDoubleConfig("DamageMultiplier", damage_comment, 0.0, 0.2, 0.4, 0.0, 10.0);
        this.multiplierAtNight = new DoubleConfig("night_multiplier", night_comment, false, 2.0, 1.0, 10.0);
        this.featureGroup.addConfigs(new IConfig[]{this.healthBonuses, this.damageBonuses, this.multiplierAtNight});
    }

    @Override
    public void onExecute(LivingEntity entity, ServerLevel world) {
        double bonusMultiplier = this.getAttributeMultiplier(world);
        MAX_HEALTH_ATTRIBUTE.setValue(this.healthBonuses.getCurrentGameStateValue() * bonusMultiplier).apply(entity);
        DAMAGE_ATTRIBUTE.setValue(this.damageBonuses.getCurrentGameStateValue() * bonusMultiplier).apply(entity);
        entity.m_21153_(entity.m_21233_());
    }

    @Override
    public boolean shouldBeExecuted(LivingEntity entity) {
        return AttributeHandler.hasAttribute((LivingEntity)entity, (Attribute)Attributes.f_22281_) && super.shouldBeExecuted(entity);
    }

    protected double getAttributeMultiplier(ServerLevel world) {
        double multiplier = 1.0;
        if (world.m_46462_()) {
            multiplier *= this.multiplierAtNight.get().doubleValue();
        }
        return multiplier;
    }
}

