/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.features.when_damaged.ChanceWhenDamagedBase;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class EndermanTeleportOnAttack
extends ChanceWhenDamagedBase {
    private static final String CONFIG_NAME = "EndermanTeleport";
    private static final String CONFIG_COMMENT = "Enderman attack teleports the player somewhere nearby.";

    public EndermanTeleportOnAttack() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.5, GameState.State.MASTER, true);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        if (!this.tryChance(target)) {
            return;
        }
        ServerLevel world = (ServerLevel)target.f_19853_;
        if (!MajruszsHelper.teleportNearby(target, world, 5.0, 10.0)) {
            return;
        }
        world.m_6263_(null, target.f_19854_, target.f_19855_, target.f_19856_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123760_, target.f_19854_, target.m_20227_(0.5), target.f_19856_, 10, 0.25, 0.25, 0.25, 0.1);
        if (target instanceof ServerPlayer) {
            Instances.BASIC_TRIGGER.trigger((ServerPlayer)target, "enderman_teleport_attack");
        }
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return attacker instanceof EnderMan && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

