/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.entities.ParasiteEntity;
import com.majruszs_difficulty.features.when_damaged.ChanceWhenDamagedBase;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ParasiteInfestOnAttack
extends ChanceWhenDamagedBase {
    private static final String CONFIG_NAME = "ParasiteInfest";
    private static final String CONFIG_COMMENT = "Makes parasite have a chance to infest the target.";

    public ParasiteInfestOnAttack() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.25, GameState.State.NORMAL, false);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        if (attacker == null || !this.tryChance(target)) {
            return;
        }
        ParasiteEntity.spawnEffects((ServerLevel)target.f_19853_, attacker.m_142538_());
        attacker.m_142687_(Entity.RemovalReason.DISCARDED);
        Instances.INFESTED.applyTo(target);
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return attacker instanceof ParasiteEntity && attacker.equals((Object)damageSource.m_7640_()) && Instances.INFESTED.canBeAppliedTo(target) && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

