/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.effects.BleedingEffect;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedApplyEffectBase;
import com.mlib.CommonHelper;
import com.mlib.effects.EffectHelper;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class WhenDamagedApplyBleedingBase
extends WhenDamagedApplyEffectBase {
    public WhenDamagedApplyBleedingBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds) {
        super(configName, configComment, defaultChance, defaultDurationInSeconds, GameState.State.NORMAL, false, Instances.BLEEDING);
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return Instances.BLEEDING.mayBleed((Entity)target) && !(damageSource instanceof BleedingEffect.EntityBleedingDamageSource) && super.shouldBeExecuted(attacker, target, damageSource);
    }

    @Override
    protected void applyEffect(@Nullable LivingEntity attacker, LivingEntity target, MobEffect effect, Difficulty difficulty) {
        BleedingEffect.BleedingMobEffectInstance effectInstance = new BleedingEffect.BleedingMobEffectInstance(this.getDurationInTicks(difficulty), this.getAmplifier(difficulty), false, true, attacker);
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (MobEffectInstance)effectInstance);
        ServerPlayer serverPlayer = (ServerPlayer)CommonHelper.castIfPossible(ServerPlayer.class, (Object)attacker);
        if (serverPlayer != null) {
            Instances.BASIC_TRIGGER.trigger(serverPlayer, "bleeding_inflicted");
        }
    }

    @Override
    protected int getAmplifier(Difficulty difficulty) {
        return Instances.BLEEDING.getAmplifier();
    }

    @Override
    public double calculateChance(LivingEntity target) {
        return Instances.BLEEDING.getChanceMultiplierDependingOnArmor(target) * super.calculateChance(target);
    }
}

