/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.goals;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class FollowGroupLeaderGoal
extends Goal {
    protected final Mob follower;
    protected final Mob leader;
    protected final double speedModifier;
    protected final float maxDistanceFromLeader;
    protected final float stopDistance;
    private final PathNavigation navigation;
    protected int ticksToRecalculatePath;

    public FollowGroupLeaderGoal(Mob follower, Mob leader, double speedModifier, float maxDistanceFromLeader, float stopDistance) {
        this.follower = follower;
        this.leader = leader;
        this.navigation = follower.m_21573_();
        this.speedModifier = speedModifier;
        this.maxDistanceFromLeader = maxDistanceFromLeader;
        this.stopDistance = stopDistance;
        this.ticksToRecalculatePath = 0;
    }

    public boolean m_8036_() {
        return this.leader != null && this.leader.m_6084_() && this.leader.m_20270_((Entity)this.follower) >= this.maxDistanceFromLeader && this.follower.m_5448_() == null;
    }

    public void m_8037_() {
        if (this.leader == null) {
            return;
        }
        if (--this.ticksToRecalculatePath > 0) {
            return;
        }
        this.follower.m_21563_().m_24960_((Entity)this.leader, 10.0f, (float)this.follower.m_21529_());
        this.ticksToRecalculatePath = 10;
        double distance = this.follower.m_20270_((Entity)this.leader);
        if (distance <= (double)this.maxDistanceFromLeader) {
            this.recalculatePath(distance);
        } else {
            this.navigation.m_5624_((Entity)this.leader, this.speedModifier);
        }
    }

    public boolean m_8045_() {
        return this.leader != null && !this.navigation.m_26571_() && (double)this.follower.m_20270_((Entity)this.leader) > (double)this.stopDistance;
    }

    public void m_8056_() {
        this.ticksToRecalculatePath = 0;
    }

    protected void recalculatePath(double distance) {
        this.navigation.m_26573_();
        LookControl lookcontroller = this.leader.m_21563_();
        if (distance <= (double)this.maxDistanceFromLeader || lookcontroller.m_24969_() == this.follower.m_20185_() && lookcontroller.m_24970_() == this.follower.m_20186_() && lookcontroller.m_24971_() == this.follower.m_20189_()) {
            double d4 = this.follower.m_20185_() - this.leader.m_20185_();
            double d5 = this.follower.m_20189_() - this.leader.m_20189_();
            this.navigation.m_26519_(this.follower.m_20185_() - d4, this.follower.m_20186_(), this.follower.m_20189_() - d5, this.speedModifier);
        }
    }
}

