/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.items.CustomArmorMaterial;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EndArmorItem
extends ArmorItem {
    private static final String ARMOR_TICK_TAG = "EndArmorTickCounter";

    public EndArmorItem(EquipmentSlot slot) {
        super((ArmorMaterial)CustomArmorMaterial.END, slot, new Item.Properties().m_41491_(Instances.ITEM_GROUP).m_41497_(Rarity.UNCOMMON).m_41486_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        MajruszsHelper.addExtraTextIfItemIsDisabled(tooltip, Instances.END_SHARD_ORE.isEnabled());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        CompoundTag data = entity.getPersistentData();
        data.m_128405_(ARMOR_TICK_TAG, (data.m_128451_(ARMOR_TICK_TAG) + 1) % 320);
        Object register = "textures/models/armor/end_layer_";
        register = (String)register + (slot == EquipmentSlot.LEGS ? "2" : "1") + "_";
        register = (String)register + (1 + data.m_128451_(ARMOR_TICK_TAG) / 80) + ".png";
        ResourceLocation textureLocation = MajruszsDifficulty.getLocation((String)register);
        return textureLocation.toString();
    }
}

