/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.events.TreasureBagOpenedEvent;
import com.majruszs_difficulty.features.treasure_bag.LootProgress;
import com.majruszs_difficulty.features.treasure_bag.LootProgressClient;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class TreasureBagItem
extends Item {
    public static final List<TreasureBagItem> TREASURE_BAGS = new ArrayList<TreasureBagItem>();
    protected static final ConfigGroup CONFIG_GROUP = new ConfigGroup("TreasureBag", "Configuration for treasure bags.");
    private static final String ITEM_TOOLTIP_TRANSLATION_KEY = "majruszs_difficulty.treasure_bag.item_tooltip";
    private final ResourceLocation lootTableLocation;
    private final String id;
    private final AvailabilityConfig availability;

    public TreasureBagItem(String id, String entityNameForConfiguration) {
        super(new Item.Properties().m_41487_(16).m_41491_(Instances.ITEM_GROUP).m_41497_(Rarity.UNCOMMON));
        this.lootTableLocation = new ResourceLocation("majruszs_difficulty", "gameplay/" + id + "_treasure_loot");
        this.id = id;
        this.availability = new AvailabilityConfig(id, TreasureBagItem.getComment(entityNameForConfiguration), false, true);
        CONFIG_GROUP.addConfig((IConfig)this.availability);
        TREASURE_BAGS.add(this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                this.handleStatistics((ServerPlayer)player);
            }
            world.m_5594_(null, player.m_142538_(), SoundEvents.f_12019_, SoundSource.AMBIENT, 1.0f, 0.9f);
            if (this.availability.isEnabled()) {
                List<ItemStack> loot = this.generateLoot(player);
                MinecraftForge.EVENT_BUS.post((Event)new TreasureBagOpenedEvent(player, this, loot));
                LootProgress.updateProgress(this, player, loot);
                for (ItemStack reward : loot) {
                    if (player.m_7066_(reward)) {
                        player.m_150109_().m_36054_(reward);
                        continue;
                    }
                    world.m_7967_((Entity)new ItemEntity(world, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), reward));
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        MajruszsHelper.addExtraTextIfItemIsDisabled(tooltip, this.availability.isEnabled());
        MajruszsHelper.addAdvancedTranslatableTexts(tooltip, flag, ITEM_TOOLTIP_TRANSLATION_KEY, " ");
        LootProgressClient.addDropList(this, tooltip);
    }

    public static LootContext generateLootContext(Player player) {
        LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerLevel)player.f_19853_);
        lootContextBuilder.m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_());
        lootContextBuilder.m_78972_(LootContextParams.f_81455_, (Object)player);
        return lootContextBuilder.m_78975_(LootContextParamSets.f_81416_);
    }

    private static String getComment(String treasureBagSourceName) {
        return "Is treasure bag from " + treasureBagSourceName + " available in survival mode?";
    }

    public RegistryObject<TreasureBagItem> register() {
        return RegistryHandler.ITEMS.register(this.id + "_treasure_bag", () -> this);
    }

    public boolean isAvailable() {
        return this.availability.isEnabled();
    }

    protected List<ItemStack> generateLoot(Player player) {
        LootTable lootTable = this.getLootTable();
        return lootTable.m_79129_(TreasureBagItem.generateLootContext(player));
    }

    public LootTable getLootTable() {
        return ServerLifecycleHooks.getCurrentServer().m_129898_().m_79217_(this.lootTableLocation);
    }

    protected void handleStatistics(ServerPlayer player) {
        Stat statistic = Stats.f_12982_.m_12902_((Object)this);
        ServerStatsCounter statisticsManager = player.m_8951_();
        player.m_36246_(statistic);
        Instances.TREASURE_BAG_TRIGGER.trigger(player, this, statisticsManager.m_13015_(statistic));
    }

    static {
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)CONFIG_GROUP);
    }
}

